/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body.player;

import net.minecraft.class_1280;
import net.minecraft.class_1282;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1738;
import net.minecraft.class_243;
import net.minecraft.class_3468;
import net.minecraft.class_8103;
import net.minecraft.class_8111;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.BodySide;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.body.player.parts.ArmBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.FootBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.HeadBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.LegBodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.parts.TorsoBodyPart;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.mixin.ModifyAppliedDamageInvoker;
import xyz.srgnis.bodyhealthsystem.registry.ModStatusEffects;
import xyz.srgnis.bodyhealthsystem.util.ProjectileHitTracker;
import xyz.srgnis.bodyhealthsystem.util.Utils;

public class PlayerBody
extends Body {
    public PlayerBody(class_1657 player) {
        this.entity = player;
    }

    @Override
    public void initParts() {
        class_1657 player = (class_1657)this.entity;
        this.addPart(PlayerBodyParts.HEAD, new HeadBodyPart(player));
        this.addPart(PlayerBodyParts.TORSO, new TorsoBodyPart(player));
        this.addPart(PlayerBodyParts.LEFT_ARM, new ArmBodyPart(BodySide.LEFT, player));
        this.addPart(PlayerBodyParts.RIGHT_ARM, new ArmBodyPart(BodySide.RIGHT, player));
        this.addPart(PlayerBodyParts.LEFT_FOOT, new FootBodyPart(BodySide.LEFT, player));
        this.addPart(PlayerBodyParts.RIGHT_FOOT, new FootBodyPart(BodySide.RIGHT, player));
        this.addPart(PlayerBodyParts.LEFT_LEG, new LegBodyPart(BodySide.LEFT, player));
        this.addPart(PlayerBodyParts.RIGHT_LEG, new LegBodyPart(BodySide.RIGHT, player));
        this.noCriticalParts.putAll(this.parts);
    }

    @Override
    public void applyDamageBySource(float amount, class_1282 source) {
        if (source == null) {
            super.applyDamageBySource(amount, source);
            return;
        }
        if (source.method_49708(class_8111.field_42345) || source.method_49708(class_8111.field_42339)) {
            this.applyFallDamage(amount, source);
        } else if (source.method_49708(class_8111.field_42336) || source.method_49708(class_8111.field_42338) || source.method_49708(class_8111.field_42325) || source.method_49708(class_8111.field_42331) || source.method_49708(class_8111.field_42332)) {
            this.applyDamageFullRandom(amount, source);
        } else if (source.method_49708(class_8111.field_42343)) {
            this.applyDamageLocal(amount, source, this.getPart(PlayerBodyParts.TORSO));
        } else if (source.method_49708(class_8111.field_42342)) {
            this.applyDamageLocal(Config.drowningDamage, source, this.getPart(PlayerBodyParts.TORSO));
        } else if (source.method_49708(class_8111.field_42346) || source.method_49708(class_8111.field_42357) || source.method_49708(class_8111.field_42356) || source.method_49708(class_8111.field_42358)) {
            this.applyDamageLocal(amount, source, this.getPart(PlayerBodyParts.HEAD));
        } else if (source.method_49708(class_8111.field_42321) || source.method_49708(class_8111.field_42323) || source.method_49708(class_8111.field_42322) || source.method_5526() instanceof class_1665) {
            class_243 norm = ProjectileHitTracker.getLastHit((class_1657)this.entity);
            BodyPart part = this.selectPartFromNormalized(norm);
            if (part != null) {
                this.applyDamageLocal(amount, source, part);
            } else {
                this.applyDamageLocalRandom(amount, source);
            }
            ProjectileHitTracker.clear((class_1657)this.entity);
        } else {
            this.applyDamageLocalRandom(amount, source);
        }
    }

    public void applyFallDamage(float amount, class_1282 source) {
        float remaining = this.takeDamage(amount /= 2.0f, source, this.getPart(PlayerBodyParts.RIGHT_FOOT));
        if (remaining > 0.0f) {
            remaining = this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.RIGHT_LEG));
        }
        if (remaining > 0.0f) {
            this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.TORSO));
        }
        if ((remaining = this.takeDamage(amount, source, this.getPart(PlayerBodyParts.LEFT_FOOT))) > 0.0f) {
            remaining = this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.LEFT_LEG));
        }
        if (remaining > 0.0f) {
            this.takeDamage(remaining, source, this.getPart(PlayerBodyParts.TORSO));
        }
    }

    @Override
    public void applyCriticalPartsEffect() {
        if (this.entity.method_6112(ModStatusEffects.MORPHINE_EFFECT) == null && this.entity.method_6112(ModStatusEffects.ADRENALINE_EFFECT) == null) {
            int amplifier = -1;
            amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.RIGHT_FOOT));
            amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.LEFT_FOOT));
            amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.RIGHT_LEG));
            amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.LEFT_LEG));
            if (this.isCrawlingRequired()) {
                amplifier = Math.min(amplifier, 1);
            }
            this.applyStatusEffectWithAmplifier(class_1294.field_5909, amplifier);
            amplifier = -1;
            amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.RIGHT_ARM));
            this.applyStatusEffectWithAmplifier(class_1294.field_5901, amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.LEFT_ARM)));
            amplifier = -1;
            amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.TORSO));
            this.applyStatusEffectWithAmplifier(class_1294.field_5911, amplifier += this.getAmplifier(this.getPart(PlayerBodyParts.HEAD)));
        }
    }

    public boolean isCrawlingRequired() {
        BodyPart leftLeg = this.getPart(PlayerBodyParts.LEFT_LEG);
        BodyPart rightLeg = this.getPart(PlayerBodyParts.RIGHT_LEG);
        BodyPart leftFoot = this.getPart(PlayerBodyParts.LEFT_FOOT);
        BodyPart rightFoot = this.getPart(PlayerBodyParts.RIGHT_FOOT);
        return leftLeg.getHealth() <= 0.0f && rightLeg.getHealth() <= 0.0f && leftFoot.getHealth() <= 0.0f && rightFoot.getHealth() <= 0.0f;
    }

    @Override
    public float takeDamage(float amount, class_1282 source, BodyPart part) {
        class_1657 player = (class_1657)this.entity;
        amount = this.applyArmorToDamage(source, amount, part);
        float f = amount = ((ModifyAppliedDamageInvoker)this.entity).invokeModifyAppliedDamage(source, amount);
        amount = Math.max(amount - this.entity.method_6067(), 0.0f);
        this.entity.method_6073(this.entity.method_6067() - (f - amount));
        float g = f - amount;
        if (g > 0.0f && g < 3.4028235E37f) {
            player.method_7339(class_3468.field_15365, Math.round(g * 10.0f));
        }
        if (amount == 0.0f) {
            return amount;
        }
        player.method_7322(source.method_5528());
        float h = this.entity.method_6032();
        player.method_6066().method_5547(source, amount);
        if (amount < 3.4028235E37f) {
            player.method_7339(class_3468.field_15388, Math.round(amount * 10.0f));
        }
        float remaining = source.method_49708(class_8111.field_42349) && this.entity.method_6059(class_1294.field_5899) ? part.damageWithoutKill(amount) : part.damage(amount);
        return remaining;
    }

    @Override
    public float applyArmorToDamage(class_1282 source, float amount, BodyPart part) {
        if (part.getAffectedArmor().method_7909() instanceof class_1738 && !source.method_48789(class_8103.field_42241)) {
            class_1657 player = (class_1657)this.entity;
            class_1738 armorItem = (class_1738)part.getAffectedArmor().method_7909();
            player.method_31548().method_7375(source, amount, new int[]{part.getArmorSlot()});
            amount = class_1280.method_5496((float)amount, (float)Utils.modifyProtection(armorItem, part.getArmorSlot()), (float)Utils.modifyToughness(armorItem, part.getArmorSlot()));
        }
        return amount;
    }

    private BodyPart selectPartFromNormalized(class_243 norm) {
        if (norm == null) {
            return null;
        }
        double x = norm.field_1352;
        double y = norm.field_1351;
        if (y < 0.15) {
            return this.getPart(x >= 0.0 ? PlayerBodyParts.LEFT_FOOT : PlayerBodyParts.RIGHT_FOOT);
        }
        if (y < 0.45) {
            return this.getPart(x >= 0.0 ? PlayerBodyParts.LEFT_LEG : PlayerBodyParts.RIGHT_LEG);
        }
        if (y < 0.75) {
            if (Math.abs(x) > 0.585) {
                return this.getPart(x >= 0.0 ? PlayerBodyParts.LEFT_ARM : PlayerBodyParts.RIGHT_ARM);
            }
            return this.getPart(PlayerBodyParts.TORSO);
        }
        return this.getPart(PlayerBodyParts.HEAD);
    }
}

