/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.mixin;

import net.minecraft.class_1041;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.constants.GUIConstants;
import xyz.srgnis.bodyhealthsystem.mixin.HandledScreenAccessor;
import xyz.srgnis.bodyhealthsystem.util.Draw;

@Mixin(value={class_490.class})
public abstract class InventoryScreenHudMixin {
    @Inject(method={"render(Lnet/minecraft/client/gui/DrawContext;IIF)V"}, at={@At(value="TAIL")})
    private void bhs$renderBodyHudOnInventory(class_332 drawContext, int mouseX, int mouseY, float delta, CallbackInfo ci) {
        if (!Config.showInventoryBodyHud) {
            return;
        }
        class_746 class_7462 = class_310.method_1551().field_1724;
        if (!(class_7462 instanceof BodyProvider)) {
            return;
        }
        BodyProvider provider = (BodyProvider)class_7462;
        if (provider.getBody() == null) {
            return;
        }
        class_1041 window = class_310.method_1551().method_22683();
        int screenW = window.method_4486();
        int screenH = window.method_4502();
        int bodyW = GUIConstants.SCALED_BODY_WIDTH;
        int bodyH = GUIConstants.SCALED_BODY_HEIGHT;
        HandledScreenAccessor acc = (HandledScreenAccessor)((Object)this);
        int baseY = acc.getY_BHS() + (acc.getBackgroundHeight_BHS() - bodyH) / 2;
        if (baseY < 2) {
            baseY = 2;
        }
        if (baseY + bodyH > screenH - 2) {
            baseY = Math.max(2, screenH - 2 - bodyH);
        }
        BodyPart leftArm = provider.getBody().getPart(PlayerBodyParts.LEFT_ARM);
        BodyPart rightArm = provider.getBody().getPart(PlayerBodyParts.RIGHT_ARM);
        BodyPart leftLeg = provider.getBody().getPart(PlayerBodyParts.LEFT_LEG);
        BodyPart rightLeg = provider.getBody().getPart(PlayerBodyParts.RIGHT_LEG);
        class_327 tr = class_310.method_1551().field_1772;
        int leftMarginNeeded = tr.method_1727(InventoryScreenHudMixin.formatHealth(leftLeg)) + 3;
        int rightMarginNeeded = tr.method_1727(InventoryScreenHudMixin.formatHealth(rightLeg)) + 3;
        int baseXRight = acc.getX_BHS() + acc.getBackgroundWidth_BHS() + 8;
        int baseXLeft = acc.getX_BHS() - 8 - bodyW;
        int baseX = baseXRight + bodyW + rightMarginNeeded <= screenW - 2 ? baseXRight : (baseXLeft - leftMarginNeeded >= 2 ? baseXLeft : Math.min(baseXRight, Math.max(2, screenW - 2 - (bodyW + rightMarginNeeded))));
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.HEAD, baseX + GUIConstants.SCALED_HEAD_X_OFFSET, baseY + GUIConstants.SCALED_HEAD_Y_OFFSET, GUIConstants.SCALED_HEAD_WIDTH, GUIConstants.SCALED_HEAD_HEIGHT);
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.LEFT_ARM, baseX + GUIConstants.SCALED_LEFT_ARM_X_OFFSET, baseY + GUIConstants.SCALED_LEFT_ARM_Y_OFFSET, GUIConstants.SCALED_LEFT_ARM_WIDTH, GUIConstants.SCALED_LEFT_ARM_HEIGHT);
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.TORSO, baseX + GUIConstants.SCALED_TORSO_X_OFFSET, baseY + GUIConstants.SCALED_TORSO_Y_OFFSET, GUIConstants.SCALED_TORSO_WIDTH, GUIConstants.SCALED_TORSO_HEIGHT);
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.RIGHT_ARM, baseX + GUIConstants.SCALED_RIGHT_ARM_X_OFFSET, baseY + GUIConstants.SCALED_RIGHT_ARM_Y_OFFSET, GUIConstants.SCALED_RIGHT_ARM_WIDTH, GUIConstants.SCALED_RIGHT_ARM_HEIGHT);
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.LEFT_LEG, baseX + GUIConstants.SCALED_LEFT_LEG_X_OFFSET, baseY + GUIConstants.SCALED_LEFT_LEG_Y_OFFSET, GUIConstants.SCALED_LEFT_LEG_WIDTH, GUIConstants.SCALED_LEFT_LEG_HEIGHT);
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.RIGHT_LEG, baseX + GUIConstants.SCALED_RIGHT_LEG_X_OFFSET, baseY + GUIConstants.SCALED_RIGHT_LEG_Y_OFFSET, GUIConstants.SCALED_RIGHT_LEG_WIDTH, GUIConstants.SCALED_RIGHT_LEG_HEIGHT);
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.LEFT_FOOT, baseX + GUIConstants.SCALED_LEFT_FOOT_X_OFFSET, baseY + GUIConstants.SCALED_LEFT_FOOT_Y_OFFSET, GUIConstants.SCALED_LEFT_FOOT_WIDTH, GUIConstants.SCALED_LEFT_FOOT_HEIGHT);
        InventoryScreenHudMixin.drawPart(drawContext, provider, PlayerBodyParts.RIGHT_FOOT, baseX + GUIConstants.SCALED_RIGHT_FOOT_X_OFFSET, baseY + GUIConstants.SCALED_RIGHT_FOOT_Y_OFFSET, GUIConstants.SCALED_RIGHT_FOOT_WIDTH, GUIConstants.SCALED_RIGHT_FOOT_HEIGHT);
        int white = 0xFFFFFF;
        BodyPart head = provider.getBody().getPart(PlayerBodyParts.HEAD);
        String headStr = InventoryScreenHudMixin.formatHealth(head);
        int headTextW = tr.method_1727(headStr);
        int headX = baseX + GUIConstants.SCALED_HEAD_X_OFFSET + (GUIConstants.SCALED_HEAD_WIDTH - headTextW) / 2;
        int headY = baseY + GUIConstants.SCALED_HEAD_Y_OFFSET + (GUIConstants.SCALED_HEAD_HEIGHT - 9) / 2;
        drawContext.method_25303(tr, headStr, headX, headY, white);
        BodyPart torso = provider.getBody().getPart(PlayerBodyParts.TORSO);
        String torsoStr = InventoryScreenHudMixin.formatHealth(torso);
        int torsoTextW = tr.method_1727(torsoStr);
        int torsoX = baseX + GUIConstants.SCALED_TORSO_X_OFFSET + (GUIConstants.SCALED_TORSO_WIDTH - torsoTextW) / 2;
        int torsoY = baseY + GUIConstants.SCALED_TORSO_Y_OFFSET + (GUIConstants.SCALED_TORSO_HEIGHT - 9) / 2;
        drawContext.method_25303(tr, torsoStr, torsoX, torsoY, white);
        String laStr = InventoryScreenHudMixin.formatHealth(leftArm);
        int laTextW = tr.method_1727(laStr);
        int laX = baseX + GUIConstants.SCALED_LEFT_ARM_X_OFFSET + (GUIConstants.SCALED_LEFT_ARM_WIDTH - laTextW) / 2;
        int laY = baseY + GUIConstants.SCALED_LEFT_ARM_Y_OFFSET + (GUIConstants.SCALED_LEFT_ARM_HEIGHT - 9) / 2;
        drawContext.method_25303(tr, laStr, laX, laY, white);
        String raStr = InventoryScreenHudMixin.formatHealth(rightArm);
        int raTextW = tr.method_1727(raStr);
        int raX = baseX + GUIConstants.SCALED_RIGHT_ARM_X_OFFSET + (GUIConstants.SCALED_RIGHT_ARM_WIDTH - raTextW) / 2;
        int raY = baseY + GUIConstants.SCALED_RIGHT_ARM_Y_OFFSET + (GUIConstants.SCALED_RIGHT_ARM_HEIGHT - 9) / 2;
        drawContext.method_25303(tr, raStr, raX, raY, white);
        BodyPart leftLegPart = leftLeg;
        String llStr = InventoryScreenHudMixin.formatHealth(leftLegPart);
        int llTextW = tr.method_1727(llStr);
        int llY = baseY + GUIConstants.SCALED_LEFT_LEG_Y_OFFSET + GUIConstants.SCALED_LEFT_LEG_HEIGHT / 2 - 4;
        int llX = baseX + GUIConstants.SCALED_LEFT_LEG_X_OFFSET - llTextW - 2;
        drawContext.method_25303(tr, llStr, llX, llY, white);
        BodyPart rightLegPart = rightLeg;
        String rlStr = InventoryScreenHudMixin.formatHealth(rightLegPart);
        int rlY = baseY + GUIConstants.SCALED_RIGHT_LEG_Y_OFFSET + GUIConstants.SCALED_RIGHT_LEG_HEIGHT / 2 - 4;
        int rlX = baseX + GUIConstants.SCALED_RIGHT_LEG_X_OFFSET + GUIConstants.SCALED_RIGHT_LEG_WIDTH + 2;
        drawContext.method_25303(tr, rlStr, rlX, rlY, white);
        BodyPart leftFoot = provider.getBody().getPart(PlayerBodyParts.LEFT_FOOT);
        BodyPart rightFoot = provider.getBody().getPart(PlayerBodyParts.RIGHT_FOOT);
        String lfStr = InventoryScreenHudMixin.formatHealth(leftFoot);
        String rfStr = InventoryScreenHudMixin.formatHealth(rightFoot);
        int lfTextW = tr.method_1727(lfStr);
        int rfTextW = tr.method_1727(rfStr);
        int lfX = baseX + GUIConstants.SCALED_LEFT_FOOT_X_OFFSET + (GUIConstants.SCALED_LEFT_FOOT_WIDTH - lfTextW) / 2;
        int rfX = baseX + GUIConstants.SCALED_RIGHT_FOOT_X_OFFSET + (GUIConstants.SCALED_RIGHT_FOOT_WIDTH - rfTextW) / 2;
        int feetY = baseY + GUIConstants.SCALED_LEFT_FOOT_Y_OFFSET + GUIConstants.SCALED_LEFT_FOOT_HEIGHT + 2;
        drawContext.method_25303(tr, lfStr, lfX, feetY, white);
        drawContext.method_25303(tr, rfStr, rfX, feetY, white);
    }

    private static void drawPart(class_332 ctx, BodyProvider provider, class_2960 partId, int x, int y, int w, int h) {
        BodyPart p = provider.getBody().getPart(partId);
        int color = Draw.selectHealthColor(p);
        Draw.drawHealthRectangle(ctx, x, y, w, h, color);
    }

    private static String formatHealth(BodyPart p) {
        return String.valueOf(Math.round(p.getHealth()));
    }
}

