/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.mixin;

import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3966;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import xyz.srgnis.bodyhealthsystem.util.ProjectileHitTracker;

@Mixin(value={class_1665.class})
public class ProjectileHitMixin {
    private static final double ARM_X_THRESHOLD = 0.85;

    @Inject(method={"onEntityHit"}, at={@At(value="HEAD")})
    private void bhs$recordHit(class_3966 entityHitResult, CallbackInfo ci) {
        class_1297 self = (class_1297)this;
        if (entityHitResult == null) {
            return;
        }
        class_1297 hitEntity = entityHitResult.method_17782();
        if (!(hitEntity instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)hitEntity;
        if (player.method_37908().field_9236) {
            return;
        }
        class_243 hitPos = entityHitResult.method_17784();
        class_243 projPos = self.method_19538();
        class_238 box = player.method_5829();
        double centerX = (box.field_1323 + box.field_1320) * 0.5;
        double centerZ = (box.field_1321 + box.field_1324) * 0.5;
        double distHit = ProjectileHitMixin.horizontalDistance(hitPos, centerX, centerZ);
        double distProj = ProjectileHitMixin.horizontalDistance(projPos, centerX, centerZ);
        class_243 best = distProj > distHit ? projPos : hitPos;
        double py = ProjectileHitMixin.clamp(best.field_1351, box.field_1322, box.field_1325);
        class_243 adjustedHit = new class_243(best.field_1352, py, best.field_1350);
        class_243 origin = new class_243(centerX, py, centerZ);
        class_243 offset = adjustedHit.method_1020(origin);
        double height = Math.max((double)player.method_17682(), 1.8);
        double halfWidth = Math.max((double)player.method_17681() * 0.5, 0.3);
        double yawRad = Math.toRadians(player.method_43078());
        class_243 forward = new class_243(-Math.sin(yawRad), 0.0, Math.cos(yawRad)).method_1029();
        class_243 right = new class_243(forward.field_1350, 0.0, -forward.field_1352).method_1029();
        double localX = offset.method_1026(right);
        double localZ = offset.method_1026(forward);
        double xNorm = ProjectileHitMixin.clamp(localX / halfWidth, -1.0, 1.0);
        double yNorm = ProjectileHitMixin.clamp((py - box.field_1322) / height, 0.0, 1.0);
        double zNorm = ProjectileHitMixin.clamp(localZ / halfWidth, -1.0, 1.0);
        ProjectileHitTracker.record(player, xNorm, yNorm, zNorm);
    }

    private static String classifyBodyPart(double xNorm, double yNorm) {
        String side = "";
        if (xNorm < -0.25) {
            side = "Right ";
        } else if (xNorm > 0.25) {
            side = "Left ";
        }
        if (yNorm < 0.15) {
            return side + "Foot";
        }
        if (yNorm < 0.45) {
            return side + "Leg";
        }
        if (yNorm < 0.75) {
            if (yNorm >= 0.55 && Math.abs(xNorm) > 0.85) {
                return side + "Arm";
            }
            return "Torso";
        }
        return side + "Head";
    }

    private static double horizontalDistance(class_243 v, double cx, double cz) {
        double dx = v.field_1352 - cx;
        double dz = v.field_1350 - cz;
        return Math.sqrt(dx * dx + dz * dz);
    }

    private static double clamp(double v, double min, double max) {
        return Math.max(min, Math.min(max, v));
    }
}

