/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body;

import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;

public abstract class BodyPart {
    private float maxHealth;
    private float health;
    private boolean broken = false;
    private Boolean brokenTopHalf = null;
    protected float criticalThreshold;
    private class_1309 entity;
    private class_2960 identifier;
    protected int armorSlot;
    protected Body body;
    protected boolean isKillRequirement = false;
    protected class_2371<class_1799> armorList;

    public BodyPart(float maxHealth, float health, class_1309 entity, class_2960 identifier) {
        this.maxHealth = maxHealth;
        this.health = health;
        this.entity = entity;
        this.identifier = identifier;
        this.body = ((BodyProvider)entity).getBody();
    }

    public void setHealth(float health) {
        this.health = Math.min(Math.max(health, 0.0f), this.maxHealth);
        this.body.checkNoCritical(this);
    }

    public void heal() {
        this.setHealth(this.maxHealth);
    }

    public float heal(float amount) {
        float newHealth = this.health + amount;
        this.setHealth(newHealth);
        return newHealth - this.health;
    }

    public void damage() {
        this.setHealth(0.0f);
    }

    public float damage(float amount) {
        float newHealth = this.health - amount;
        this.setHealth(newHealth);
        return Math.max(0.0f, -newHealth);
    }

    public float damageWithoutKill(float amount) {
        float newHealth = this.health - amount;
        if (this.isKillRequirement) {
            this.setHealth(Math.max(1.0f, newHealth));
        } else {
            this.setHealth(newHealth);
        }
        return Math.max(0.0f, -newHealth);
    }

    public class_1799 getAffectedArmor() {
        return (class_1799)this.armorList.get(this.armorSlot);
    }

    public int getArmorSlot() {
        return this.armorSlot;
    }

    public float getHealth() {
        return this.health;
    }

    public float getMaxHealth() {
        return this.maxHealth;
    }

    public void setMaxHealth(float maxHealth) {
        this.maxHealth = maxHealth;
    }

    public class_1309 getEntity() {
        return this.entity;
    }

    public void setEntity(class_1309 entity) {
        this.entity = entity;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(class_2960 identifier) {
        this.identifier = identifier;
    }

    public float getCriticalThreshold() {
        return this.criticalThreshold;
    }

    public void writeToNbt(class_2487 nbt) {
        class_2487 new_nbt = new class_2487();
        new_nbt.method_10548("health", this.health);
        new_nbt.method_10556("broken", this.broken);
        if (this.brokenTopHalf != null) {
            new_nbt.method_10556("brokenTopHalf", this.brokenTopHalf.booleanValue());
        }
        nbt.method_10566(this.identifier.toString(), (class_2520)new_nbt);
    }

    public void readFromNbt(class_2487 nbt) {
        this.health = nbt.method_10583("health");
        this.broken = nbt.method_10545("broken") ? nbt.method_10577("broken") : false;
        this.brokenTopHalf = nbt.method_10545("brokenTopHalf") ? Boolean.valueOf(nbt.method_10577("brokenTopHalf")) : null;
    }

    public String toString() {
        return this.identifier.method_12832() + " | MaxHP: " + this.maxHealth + " | HP " + this.health + "\n";
    }

    public boolean isDamaged() {
        return this.health < this.maxHealth;
    }

    public boolean isBroken() {
        return this.broken;
    }

    public void setBroken(boolean broken) {
        this.broken = broken;
    }

    public Boolean getBrokenTopHalf() {
        return this.brokenTopHalf;
    }

    public void setBrokenTopHalf(Boolean brokenTopHalf) {
        this.brokenTopHalf = brokenTopHalf;
    }
}

