/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.body;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_5712;
import net.minecraft.class_8111;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.mixin.ModifyAppliedDamageInvoker;
import xyz.srgnis.bodyhealthsystem.network.ServerNetworking;
import xyz.srgnis.bodyhealthsystem.registry.ModStatusEffects;
import xyz.srgnis.bodyhealthsystem.util.Utils;

public abstract class Body {
    protected final HashMap<class_2960, BodyPart> parts = new HashMap();
    protected HashMap<class_2960, BodyPart> noCriticalParts = new HashMap();
    protected final HashMap<class_2960, Float> absorptionBuckets = new HashMap();
    protected final HashMap<class_2960, Float> boostBuckets = new HashMap();
    protected class_1309 entity;
    protected boolean suppressBoneBreakEvaluation = false;
    protected float lastKnownMaxHealth = -1.0f;
    protected int boneGraceTicksRemaining = 0;
    protected boolean bonePenaltyActive = false;
    protected int bonePenaltyTickCounter = 0;
    protected boolean downed = false;
    protected int bleedOutTicksRemaining = 0;
    protected boolean beingRevived = false;
    protected UUID reviverUuid = null;
    protected boolean pendingDeath = false;

    public abstract void initParts();

    public void addPart(class_2960 identifier, BodyPart part) {
        this.parts.put(identifier, part);
        this.absorptionBuckets.put(identifier, Float.valueOf(0.0f));
        this.boostBuckets.put(identifier, Float.valueOf(0.0f));
    }

    public BodyPart getPart(class_2960 identifier) {
        return this.parts.get(identifier);
    }

    public void removePart(class_2960 identifier) {
        this.parts.remove(identifier);
    }

    public ArrayList<BodyPart> getParts() {
        return new ArrayList<BodyPart>(this.parts.values());
    }

    public ArrayList<class_2960> getPartsIdentifiers() {
        return new ArrayList<class_2960>(this.parts.keySet());
    }

    public ArrayList<BodyPart> getNoCriticalParts() {
        return new ArrayList<BodyPart>(this.noCriticalParts.values());
    }

    public ArrayList<class_2960> getNoCriticalIdentifiers() {
        return new ArrayList<class_2960>(this.noCriticalParts.keySet());
    }

    public void writeToNbt(class_2487 nbt) {
        class_2487 new_nbt = new class_2487();
        for (BodyPart part : this.getParts()) {
            part.writeToNbt(new_nbt);
        }
        new_nbt.method_10556("downed", this.downed);
        new_nbt.method_10569("bleedOutTicksRemaining", this.bleedOutTicksRemaining);
        nbt.method_10566("bodyhealthsystem", (class_2520)new_nbt);
    }

    public void readFromNbt(class_2487 nbt) {
        class_2487 bodyNbt = nbt.method_10562("bodyhealthsystem");
        if (!bodyNbt.method_33133()) {
            this.noCriticalParts.clear();
            for (class_2960 partId : this.getPartsIdentifiers()) {
                if (bodyNbt.method_10562(partId.toString()).method_33133()) continue;
                BodyPart part = this.getPart(partId);
                part.readFromNbt(bodyNbt.method_10562(partId.toString()));
                if (!(part.getHealth() > 0.0f)) continue;
                this.noCriticalParts.put(part.getIdentifier(), part);
            }
            if (bodyNbt.method_10545("downed")) {
                this.downed = bodyNbt.method_10577("downed");
            }
            if (bodyNbt.method_10545("bleedOutTicksRemaining")) {
                this.bleedOutTicksRemaining = bodyNbt.method_10550("bleedOutTicksRemaining");
            } else if (this.downed && this.bleedOutTicksRemaining <= 0) {
                this.bleedOutTicksRemaining = this.isTorsoBroken() ? 800 : 1600;
            }
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Body of " + this.entity.method_5477().getString() + "\n");
        for (BodyPart p : this.getParts()) {
            s.append(p.toString());
        }
        return s.toString();
    }

    public void healAll() {
        for (BodyPart part : this.getParts()) {
            part.heal();
        }
    }

    public void heal(float amount) {
        if (amount > 0.0f) {
            ArrayList<BodyPart> parts_l = this.getParts();
            Collections.shuffle(parts_l);
            for (BodyPart part : parts_l) {
                if (amount <= 0.0f) break;
                amount = part.heal(amount);
            }
        }
    }

    public void healPart(int amount, class_2960 partID) {
        this.healPart((float)amount, this.getPart(partID));
    }

    public void healPart(float amount, BodyPart part) {
        part.heal(amount);
    }

    public void applyDamageBySource(float amount, class_1282 source) {
        this.applyDamageLocalRandom(amount, source);
    }

    public void applyDamageLocal(float amount, class_1282 source, BodyPart part) {
        this.takeDamage(amount, source, part);
    }

    public void applyDamageLocalRandom(float amount, class_1282 source) {
        this.takeDamage(amount, source, this.getNoCriticalParts().get(this.entity.method_6051().method_43048(this.noCriticalParts.size())));
    }

    public void applyDamageGeneral(float amount, class_1282 source) {
        this.applyDamageList(amount, source, this.getParts());
    }

    public void applyDamageGeneralRandom(float amount, class_1282 source) {
        this.applyDamageListRandom(amount, source, this.getParts());
    }

    public void applyDamageList(float amount, class_1282 source, List<BodyPart> parts) {
        float split_amount = amount / (float)parts.size();
        for (BodyPart bodyPart : parts) {
            this.takeDamage(split_amount, source, bodyPart);
        }
    }

    public void applyDamageListRandom(float amount, class_1282 source, List<BodyPart> parts) {
        List<Float> damages = Utils.n_random(amount, parts.size());
        int i = 0;
        for (BodyPart bodyPart : parts) {
            this.takeDamage(damages.get(i).floatValue(), source, bodyPart);
            ++i;
        }
    }

    public void applyDamageRandomList(float amount, class_1282 source) {
        List<BodyPart> randomlist = Utils.random_sublist(this.getNoCriticalParts(), this.entity.method_6051().method_43048(this.getNoCriticalParts().size() + 1));
        this.applyDamageList(amount, source, randomlist);
    }

    public void applyDamageFullRandom(float amount, class_1282 source) {
        List<BodyPart> randomlist = Utils.random_sublist(this.getNoCriticalParts(), this.entity.method_6051().method_43048(this.getNoCriticalParts().size() + 1));
        this.applyDamageListRandom(amount, source, randomlist);
    }

    public float takeDamage(float amount, class_1282 source, BodyPart part) {
        amount = this.applyArmorToDamage(source, amount, part);
        float f = amount = ((ModifyAppliedDamageInvoker)this.entity).invokeModifyAppliedDamage(source, amount);
        this.ensureAbsorptionBucketsUpToDate();
        float currentAbs = this.entity.method_6067();
        float bucket = this.getAbsorptionBucket(part);
        float consumed = Math.min(amount, bucket);
        if (consumed > 0.0f) {
            this.consumeAbsorptionFromBucket(part, consumed);
            this.entity.method_6073(Math.max(0.0f, currentAbs - consumed));
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_3222) {
                class_3222 spe = (class_3222)class_12972;
                spe.method_7339(class_3468.field_15408, Math.round(consumed * 10.0f));
            }
            amount -= consumed;
        }
        if (amount == 0.0f) {
            return 0.0f;
        }
        float previousHealth = part.getHealth();
        float remaining = source.method_49708(class_8111.field_42349) && this.entity.method_6112(class_1294.field_5899) != null ? part.damageWithoutKill(amount) : part.damage(amount);
        if (!part.getIdentifier().equals((Object)PlayerBodyParts.HEAD) && !this.suppressBoneBreakEvaluation) {
            this.evaluateBoneBreak(part, previousHealth, amount);
        }
        this.entity.method_6066().method_5547(source, amount);
        this.entity.method_32876(class_5712.field_28736);
        return remaining;
    }

    private void evaluateBoneBreak(BodyPart part, float previousHealth, float rawDamage) {
        float max = part.getMaxHealth();
        float newHealth = part.getHealth();
        if (newHealth <= 0.0f) {
            part.setBroken(true);
            if (this.isArm(part)) {
                this.assignArmBrokenHalf(part);
            }
            return;
        }
        float healthRatio = previousHealth / max;
        float baseChance = 0.0f;
        if (healthRatio < 1.0f) {
            baseChance = healthRatio >= 0.5f ? (1.0f - healthRatio) * 0.6f : 0.3f + (0.5f - healthRatio) * 1.4f;
        }
        float damageRatio = Math.min(rawDamage / max, 1.0f);
        float bonus = 0.15f * damageRatio;
        float chance = Math.min(baseChance + bonus, 1.0f);
        if (this.entity.method_6051().method_43057() < chance) {
            part.setBroken(true);
            if (this.isArm(part)) {
                this.assignArmBrokenHalf(part);
            }
        }
    }

    private boolean isArm(BodyPart part) {
        class_2960 id = part.getIdentifier();
        return id.equals((Object)PlayerBodyParts.LEFT_ARM) || id.equals((Object)PlayerBodyParts.RIGHT_ARM);
    }

    private void assignArmBrokenHalf(BodyPart part) {
        if (part.getBrokenTopHalf() == null) {
            part.setBrokenTopHalf(this.entity.method_6051().method_43056());
        }
    }

    public abstract float applyArmorToDamage(class_1282 var1, float var2, BodyPart var3);

    public abstract void applyCriticalPartsEffect();

    public void applyBrokenBonesEffects() {
        boolean showBleeding;
        int brokenArms;
        int brokenCount;
        class_1309 class_13092 = this.entity;
        if (!(class_13092 instanceof class_1657)) {
            return;
        }
        class_1657 player = (class_1657)class_13092;
        if (this.entity.method_37908().field_9236) {
            return;
        }
        if (!this.anyBoneBroken()) {
            this.bonePenaltyActive = false;
            this.boneGraceTicksRemaining = 0;
            this.bonePenaltyTickCounter = 0;
            player.method_6016(class_1294.field_5909);
            player.method_6016(class_1294.field_5901);
            player.method_6016(class_1294.field_5911);
            player.method_6016(ModStatusEffects.BLEEDING_EFFECT);
            return;
        }
        if (!this.bonePenaltyActive) {
            if (this.boneGraceTicksRemaining > 0) {
                --this.boneGraceTicksRemaining;
            } else {
                this.bonePenaltyActive = true;
                this.bonePenaltyTickCounter = 0;
            }
        }
        if ((brokenCount = this.brokenBonesCount()) > 0) {
            int amp = Math.max(0, brokenCount - 1);
            player.method_6092(new class_1293(class_1294.field_5909, 40, amp, false, false, false));
        }
        if ((brokenArms = this.countBrokenArms()) > 0) {
            int amp = Math.max(0, brokenArms - 1);
            player.method_6092(new class_1293(class_1294.field_5901, 40, amp, false, false, false));
        }
        if (this.isTorsoBroken()) {
            player.method_6092(new class_1293(class_1294.field_5911, 40, 1, false, false, false));
        }
        if (this.bothFeetBroken()) {
            player.method_6092(new class_1293(class_1294.field_5909, 40, 0, false, false, false));
        }
        boolean bl = showBleeding = this.bonePenaltyActive || !this.bonePenaltyActive && this.boneGraceTicksRemaining <= 200;
        if (showBleeding) {
            player.method_6092(new class_1293(ModStatusEffects.BLEEDING_EFFECT, 40, 0, false, true, true));
        } else {
            player.method_6016(ModStatusEffects.BLEEDING_EFFECT);
        }
        if (this.bonePenaltyActive) {
            ++this.bonePenaltyTickCounter;
            if (this.bonePenaltyTickCounter >= 200) {
                this.bonePenaltyTickCounter = 0;
                int stacks = this.brokenBonesCount();
                if (stacks > 0) {
                    float dmg = 0.5f * (float)stacks;
                    BodyPart torso = this.getPart(PlayerBodyParts.TORSO);
                    ArrayList<BodyPart> aliveNonHeadNonTorso = new ArrayList<BodyPart>();
                    for (BodyPart p : this.getParts()) {
                        class_2960 id = p.getIdentifier();
                        if (id.equals((Object)PlayerBodyParts.HEAD) || id.equals((Object)PlayerBodyParts.TORSO) || !(p.getHealth() > 0.0f)) continue;
                        aliveNonHeadNonTorso.add(p);
                    }
                    boolean othersDestroyed = this.allOtherNonHeadPartsDestroyed();
                    BodyPart target = null;
                    if (torso != null && torso.getHealth() <= 2.0f && !othersDestroyed) {
                        if (!aliveNonHeadNonTorso.isEmpty()) {
                            target = (BodyPart)aliveNonHeadNonTorso.get(this.entity.method_6051().method_43048(aliveNonHeadNonTorso.size()));
                        }
                    } else {
                        target = torso;
                        if ((target == null || target.getHealth() <= 0.0f) && !aliveNonHeadNonTorso.isEmpty()) {
                            target = (BodyPart)aliveNonHeadNonTorso.get(this.entity.method_6051().method_43048(aliveNonHeadNonTorso.size()));
                        }
                    }
                    if (target != null) {
                        if (target == torso && torso != null && torso.getHealth() > 0.0f && !othersDestroyed && torso.getHealth() <= 2.0f) {
                            if (!aliveNonHeadNonTorso.isEmpty()) {
                                BodyPart reroute = (BodyPart)aliveNonHeadNonTorso.get(this.entity.method_6051().method_43048(aliveNonHeadNonTorso.size()));
                                this.applyBleedingDamageTo(player, reroute, dmg);
                            }
                        } else if (target == torso && torso != null && !othersDestroyed && torso.getHealth() > 2.0f) {
                            float allowed = Math.max(0.0f, torso.getHealth() - 2.0f);
                            float toTorso = Math.min(dmg, allowed);
                            float remainder = dmg - toTorso;
                            if (toTorso > 0.0f) {
                                this.applyBleedingDamageTo(player, torso, toTorso);
                            }
                            if (remainder > 0.0f && !aliveNonHeadNonTorso.isEmpty()) {
                                BodyPart reroute = (BodyPart)aliveNonHeadNonTorso.get(this.entity.method_6051().method_43048(aliveNonHeadNonTorso.size()));
                                this.applyBleedingDamageTo(player, reroute, remainder);
                            }
                        } else {
                            this.applyBleedingDamageTo(player, target, dmg);
                        }
                        this.updateHealth();
                        ServerNetworking.broadcastBody((class_1297)player);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyBleedingDamageTo(class_1657 player, BodyPart target, float amount) {
        if (target == null || amount <= 0.0f) {
            return;
        }
        this.suppressBoneBreakEvaluation = true;
        try {
            this.takeDamage(amount, player.method_48923().method_48830(), target);
        }
        finally {
            this.suppressBoneBreakEvaluation = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyNonBreakingDamage(float amount, class_1282 source, BodyPart target) {
        if (target == null || amount <= 0.0f) {
            return;
        }
        this.suppressBoneBreakEvaluation = true;
        try {
            this.takeDamage(amount, source, target);
        }
        finally {
            this.suppressBoneBreakEvaluation = false;
        }
    }

    public void applyStatusEffectWithAmplifier(class_1291 effect, int amplifier) {
        if (amplifier >= 0) {
            class_1293 s = this.entity.method_6112(effect);
            if (s == null) {
                this.entity.method_6092(new class_1293(effect, 40, amplifier));
            } else if (s.method_5578() > amplifier || s.method_5584() <= 5 || s.method_5578() != amplifier) {
                this.entity.method_6092(new class_1293(effect, 40, amplifier));
            }
        }
    }

    public int getAmplifier(BodyPart part) {
        if (part.getHealth() <= part.getCriticalThreshold()) {
            return 1;
        }
        return 0;
    }

    public void updateHealth() {
        BodyPart head = this.getPart(PlayerBodyParts.HEAD);
        BodyPart torso = this.getPart(PlayerBodyParts.TORSO);
        if (head != null && head.getHealth() <= 0.0f) {
            this.entity.method_6033(0.0f);
            return;
        }
        if (torso != null && torso.getHealth() <= 0.0f) {
            this.startDowned();
            if (this.entity.method_6032() < 1.0f) {
                this.entity.method_6033(1.0f);
            }
            return;
        }
        float max_effective = 0.0f;
        float actual_health = 0.0f;
        for (BodyPart part : this.getParts()) {
            float boost = this.getBoostForPart(part.getIdentifier());
            max_effective += part.getMaxHealth() + Math.max(0.0f, boost);
            actual_health += part.getHealth();
        }
        if (max_effective > 0.0f) {
            float ratio = actual_health / max_effective;
            if (ratio <= 0.01f) {
                this.startDowned();
                if (this.entity.method_6032() > 1.0f) {
                    this.entity.method_6033(1.0f);
                }
                return;
            }
            this.entity.method_6033(this.entity.method_6063() * ratio);
        }
    }

    public boolean shouldDie() {
        BodyPart head = this.getPart(PlayerBodyParts.HEAD);
        return head != null && head.getHealth() <= 0.0f;
    }

    public void checkNoCritical(BodyPart part) {
        if (part.getHealth() > 0.0f) {
            this.noCriticalParts.putIfAbsent(part.getIdentifier(), part);
        } else {
            this.noCriticalParts.remove(part.getIdentifier());
        }
    }

    public void applyTotem() {
        for (BodyPart part : this.getParts()) {
            if (!(part.getHealth() < 1.0f)) continue;
            part.setHealth(1.0f);
        }
        this.updateHealth();
    }

    public void onBoneBrokenEvent(BodyPart part) {
        this.boneGraceTicksRemaining = this.boneGraceTicksRemaining <= 0 && !this.bonePenaltyActive ? 2400 : Math.max(0, this.boneGraceTicksRemaining - 600);
        class_1309 class_13092 = this.entity;
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            if (!this.entity.method_37908().field_9236) {
                player.method_6092(new class_1293(class_1294.field_5919, 100, 0, false, false));
            }
        }
    }

    public void onBoneTreatmentApplied() {
        this.boneGraceTicksRemaining = Math.max(0, this.boneGraceTicksRemaining) + 320;
    }

    protected int countBrokenArms() {
        int c = 0;
        BodyPart la = this.getPart(PlayerBodyParts.LEFT_ARM);
        BodyPart ra = this.getPart(PlayerBodyParts.RIGHT_ARM);
        if (la != null && la.isBroken()) {
            ++c;
        }
        if (ra != null && ra.isBroken()) {
            ++c;
        }
        return c;
    }

    protected int countBrokenLegs() {
        int c = 0;
        BodyPart ll = this.getPart(PlayerBodyParts.LEFT_LEG);
        BodyPart rl = this.getPart(PlayerBodyParts.RIGHT_LEG);
        if (ll != null && ll.isBroken()) {
            ++c;
        }
        if (rl != null && rl.isBroken()) {
            ++c;
        }
        return c;
    }

    protected boolean bothFeetBroken() {
        BodyPart lf = this.getPart(PlayerBodyParts.LEFT_FOOT);
        BodyPart rf = this.getPart(PlayerBodyParts.RIGHT_FOOT);
        return lf != null && rf != null && lf.isBroken() && rf.isBroken();
    }

    protected boolean isTorsoBroken() {
        BodyPart t = this.getPart(PlayerBodyParts.TORSO);
        return t != null && t.isBroken();
    }

    public boolean isDowned() {
        return this.downed;
    }

    public boolean isBeingRevived() {
        return this.beingRevived;
    }

    public void setDowned(boolean downed) {
        this.downed = downed;
    }

    public void setBeingRevived(boolean beingRevived) {
        this.beingRevived = beingRevived;
    }

    public int getBleedOutTicksRemaining() {
        return this.bleedOutTicksRemaining;
    }

    public void setBleedOutTicksRemaining(int ticks) {
        this.bleedOutTicksRemaining = ticks;
    }

    public boolean tryBeginRevive(class_1657 reviver) {
        if (!this.downed) {
            return false;
        }
        if (this.beingRevived) {
            return this.reviverUuid != null && this.reviverUuid.equals(reviver.method_5667());
        }
        this.beingRevived = true;
        this.reviverUuid = reviver.method_5667();
        return true;
    }

    public void endRevive(class_1657 reviver) {
        if (this.reviverUuid != null && this.reviverUuid.equals(reviver.method_5667())) {
            this.beingRevived = false;
            this.reviverUuid = null;
        }
    }

    public void startDowned() {
        if (this.downed) {
            return;
        }
        this.downed = true;
        this.bleedOutTicksRemaining = this.isTorsoBroken() ? 800 : 1600;
    }

    public void clearDowned() {
        this.downed = false;
        this.beingRevived = false;
        this.reviverUuid = null;
        this.bleedOutTicksRemaining = 0;
    }

    public boolean isPendingDeath() {
        return this.pendingDeath;
    }

    public void onVanillaDeath() {
        this.clearDowned();
        this.pendingDeath = false;
    }

    public void forceGiveUp() {
        if (this.entity == null || this.entity.method_37908().field_9236) {
            return;
        }
        if (!this.downed) {
            return;
        }
        this.pendingDeath = true;
        if (this.entity.method_5805()) {
            this.entity.method_5643(this.entity.method_48923().method_48829(), 1000.0f);
        }
    }

    public void tickDowned() {
        if (!this.downed) {
            return;
        }
        if (this.entity.method_37908().field_9236) {
            return;
        }
        if (!this.beingRevived) {
            if (this.bleedOutTicksRemaining > 0) {
                --this.bleedOutTicksRemaining;
            }
            if (this.bleedOutTicksRemaining <= 0) {
                if (this.entity.method_5805()) {
                    this.pendingDeath = true;
                    this.entity.method_5643(this.entity.method_48923().method_48829(), 1000.0f);
                }
                this.clearDowned();
            }
        }
    }

    public void applyRevival(int healPerPart, int bonesToFix) {
        if (!this.downed) {
            return;
        }
        for (BodyPart p : this.getParts()) {
            if (!(p.getHealth() < p.getMaxHealth())) continue;
            p.setHealth(Math.min(p.getMaxHealth(), p.getHealth() + (float)healPerPart));
        }
        this.fixBrokenBonesPreferTorso(bonesToFix);
        this.clearDowned();
        this.pendingDeath = false;
        this.updateHealth();
    }

    private void fixBrokenBonesPreferTorso(int count) {
        if (count <= 0) {
            return;
        }
        ArrayList<BodyPart> candidates = new ArrayList<BodyPart>();
        BodyPart torso = this.getPart(PlayerBodyParts.TORSO);
        if (torso != null && torso.isBroken()) {
            torso.setBroken(false);
            torso.setBrokenTopHalf(null);
            if (torso.getHealth() <= 0.0f) {
                torso.setHealth(1.0f);
            }
            --count;
        }
        if (count <= 0) {
            return;
        }
        for (BodyPart p : this.getParts()) {
            if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
            candidates.add(p);
        }
        Collections.shuffle(candidates, new Random());
        for (BodyPart p : candidates) {
            if (count <= 0) break;
            p.setBroken(false);
            p.setBrokenTopHalf(null);
            if (p.getHealth() <= 0.0f) {
                p.setHealth(1.0f);
            }
            --count;
        }
    }

    private boolean allOtherNonHeadPartsDestroyed() {
        for (BodyPart p : this.getParts()) {
            class_2960 id = p.getIdentifier();
            if (id.equals((Object)PlayerBodyParts.HEAD) || id.equals((Object)PlayerBodyParts.TORSO) || !(p.getHealth() > 0.0f)) continue;
            return false;
        }
        return true;
    }

    protected boolean anyBoneBroken() {
        for (BodyPart p : this.getParts()) {
            if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
            return true;
        }
        return false;
    }

    protected int brokenBonesCount() {
        int c = 0;
        for (BodyPart p : this.getParts()) {
            if (p.getIdentifier().equals((Object)PlayerBodyParts.HEAD) || !p.isBroken()) continue;
            ++c;
        }
        return c;
    }

    protected void ensureAbsorptionBucketsUpToDate() {
        float reclaim = 0.0f;
        for (BodyPart bodyPart : this.getParts()) {
            class_2960 id;
            float b;
            if (!(bodyPart.getHealth() <= 0.0f) || !((b = this.absorptionBuckets.getOrDefault(id = bodyPart.getIdentifier(), Float.valueOf(0.0f)).floatValue()) > 0.0f)) continue;
            reclaim += b;
            this.absorptionBuckets.put(id, Float.valueOf(0.0f));
        }
        if (reclaim > 0.0f) {
            this.addAbsorptionToBuckets(reclaim);
        }
        float totalBuckets = 0.0f;
        for (class_2960 id : this.absorptionBuckets.keySet()) {
            totalBuckets += this.absorptionBuckets.get(id).floatValue();
        }
        float f = this.entity.method_6067();
        if (f > totalBuckets + 0.001f) {
            float delta = f - totalBuckets;
            this.addAbsorptionToBuckets(delta);
        } else if (f + 0.001f < totalBuckets) {
            float factor = f <= 0.0f ? 0.0f : f / Math.max(totalBuckets, 1.0E-4f);
            for (class_2960 id : new ArrayList<class_2960>(this.absorptionBuckets.keySet())) {
                this.absorptionBuckets.put(id, Float.valueOf(this.absorptionBuckets.get(id).floatValue() * factor));
            }
        }
    }

    protected void addAbsorptionToBuckets(float amount) {
        float current;
        float add;
        if (amount <= 0.0f) {
            return;
        }
        class_2960 HEAD = PlayerBodyParts.HEAD;
        class_2960 TORSO = PlayerBodyParts.TORSO;
        BodyPart head = this.getPart(HEAD);
        BodyPart torso = this.getPart(TORSO);
        if (head != null && head.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.absorptionBuckets.getOrDefault(HEAD, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.absorptionBuckets.put(HEAD, Float.valueOf(current + add));
            amount -= add;
        }
        if (amount > 0.0f && torso != null && torso.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.absorptionBuckets.getOrDefault(TORSO, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.absorptionBuckets.put(TORSO, Float.valueOf(current + add));
            amount -= add;
        }
        ArrayList<BodyPart> alive = new ArrayList<BodyPart>();
        for (BodyPart p : this.getParts()) {
            if (!(p.getHealth() > 0.0f)) continue;
            alive.add(p);
        }
        if (amount > 0.0f && !alive.isEmpty()) {
            float share = amount / (float)alive.size();
            for (BodyPart p : alive) {
                class_2960 id = p.getIdentifier();
                float current2 = this.absorptionBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
                this.absorptionBuckets.put(id, Float.valueOf(current2 + share));
            }
        }
    }

    private void addAliveIf(List<BodyPart> list, class_2960 id) {
        BodyPart p = this.getPart(id);
        if (p != null && p.getHealth() > 0.0f) {
            list.add(p);
        }
    }

    protected void ensureBoostBucketsUpToDate() {
        float reclaim = 0.0f;
        for (BodyPart bodyPart : this.getParts()) {
            class_2960 id;
            float b;
            if (!(bodyPart.getHealth() <= 0.0f) || !((b = this.boostBuckets.getOrDefault(id = bodyPart.getIdentifier(), Float.valueOf(0.0f)).floatValue()) > 0.0f)) continue;
            reclaim += b;
            this.boostBuckets.put(id, Float.valueOf(0.0f));
        }
        if (reclaim > 0.0f) {
            this.addBoostToBuckets(reclaim, false);
        }
        float totalBuckets = 0.0f;
        for (class_2960 id : this.boostBuckets.keySet()) {
            totalBuckets += this.boostBuckets.get(id).floatValue();
        }
        float f = Math.max(0.0f, this.entity.method_6063() - 20.0f);
        if (f > totalBuckets + 0.001f) {
            float delta = f - totalBuckets;
            this.addBoostToBuckets(delta, false);
        } else if (f + 0.001f < totalBuckets) {
            float factor = f <= 0.0f ? 0.0f : f / Math.max(totalBuckets, 1.0E-4f);
            for (class_2960 id : new ArrayList<class_2960>(this.boostBuckets.keySet())) {
                this.boostBuckets.put(id, Float.valueOf(this.boostBuckets.get(id).floatValue() * factor));
            }
        }
        this.clampAllPartsToEffectiveCap();
    }

    private void clampAllPartsToEffectiveCap() {
        for (BodyPart p : this.getParts()) {
            float boost = this.getBoostForPart(p.getIdentifier());
            float cap = p.getMaxHealth() + Math.max(0.0f, boost);
            if (!(p.getHealth() > cap)) continue;
            p.setHealth(cap);
        }
    }

    protected void addBoostToBuckets(float amount, boolean grantHealthIgnored) {
        float current;
        float add;
        if (amount <= 0.0f) {
            return;
        }
        class_2960 HEAD = PlayerBodyParts.HEAD;
        class_2960 TORSO = PlayerBodyParts.TORSO;
        BodyPart head = this.getPart(HEAD);
        BodyPart torso = this.getPart(TORSO);
        if (head != null && head.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.boostBuckets.getOrDefault(HEAD, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.boostBuckets.put(HEAD, Float.valueOf(current + add));
            amount -= add;
        }
        if (amount > 0.0f && torso != null && torso.getHealth() > 0.0f && (add = Math.min(2.0f - (current = this.boostBuckets.getOrDefault(TORSO, Float.valueOf(0.0f)).floatValue()), amount)) > 0.0f) {
            this.boostBuckets.put(TORSO, Float.valueOf(current + add));
            amount -= add;
        }
        ArrayList<BodyPart> alive = new ArrayList<BodyPart>();
        for (BodyPart p : this.getParts()) {
            if (!(p.getHealth() > 0.0f)) continue;
            alive.add(p);
        }
        if (amount > 0.0f && !alive.isEmpty()) {
            float share = amount / (float)alive.size();
            for (BodyPart p : alive) {
                class_2960 id = p.getIdentifier();
                float current2 = this.boostBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
                this.boostBuckets.put(id, Float.valueOf(current2 + share));
            }
        }
    }

    protected float getAbsorptionBucket(BodyPart part) {
        if (part == null) {
            return 0.0f;
        }
        return this.absorptionBuckets.getOrDefault(part.getIdentifier(), Float.valueOf(0.0f)).floatValue();
    }

    protected void consumeAbsorptionFromBucket(BodyPart part, float amount) {
        if (part == null || amount <= 0.0f) {
            return;
        }
        class_2960 id = part.getIdentifier();
        float current = this.absorptionBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        float newVal = Math.max(0.0f, current - amount);
        this.absorptionBuckets.put(id, Float.valueOf(newVal));
    }

    protected float getBoostBucket(BodyPart part) {
        if (part == null) {
            return 0.0f;
        }
        return this.boostBuckets.getOrDefault(part.getIdentifier(), Float.valueOf(0.0f)).floatValue();
    }

    protected void consumeBoostFromBucket(BodyPart part, float amount) {
        if (part == null || amount <= 0.0f) {
            return;
        }
        class_2960 id = part.getIdentifier();
        float current = this.boostBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
        float newVal = Math.max(0.0f, current - amount);
        this.boostBuckets.put(id, Float.valueOf(newVal));
    }

    public void prepareBucketSync() {
        this.ensureAbsorptionBucketsUpToDate();
        this.ensureBoostBucketsUpToDate();
    }

    public void clientSetAbsorptionBucket(class_2960 id, float value) {
        this.absorptionBuckets.put(id, Float.valueOf(Math.max(0.0f, value)));
    }

    public void clientSetBoostBucket(class_2960 id, float value) {
        this.boostBuckets.put(id, Float.valueOf(Math.max(0.0f, value)));
    }

    public float getAbsorptionForPart(class_2960 id) {
        return this.absorptionBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public float getBoostForPart(class_2960 id) {
        return this.boostBuckets.getOrDefault(id, Float.valueOf(0.0f)).floatValue();
    }

    public boolean syncBoostIfNeeded() {
        float current;
        float f = current = this.entity != null ? this.entity.method_6063() : 0.0f;
        if (this.lastKnownMaxHealth < 0.0f) {
            this.lastKnownMaxHealth = current;
            this.ensureBoostBucketsUpToDate();
            this.clampAllPartsToEffectiveCap();
            return true;
        }
        if (Math.abs(current - this.lastKnownMaxHealth) > 0.01f) {
            this.lastKnownMaxHealth = current;
            this.ensureBoostBucketsUpToDate();
            this.clampAllPartsToEffectiveCap();
            this.updateHealth();
            return true;
        }
        return false;
    }
}

