/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.client.hud;

import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_490;
import net.minecraft.class_746;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.constants.GUIConstants;
import xyz.srgnis.bodyhealthsystem.items.MedkitItem;
import xyz.srgnis.bodyhealthsystem.items.TraumaKitItem;
import xyz.srgnis.bodyhealthsystem.items.UpgradedMedkitItem;
import xyz.srgnis.bodyhealthsystem.util.Draw;

public class BHSHud
implements HudRenderCallback {
    private static int startX;
    private static int startY;

    public void onHudRender(class_332 drawContext, float v) {
        float reviveProgress = this.getReviveProgressClient();
        if (reviveProgress > 0.0f) {
            this.drawReviveProgress(drawContext, reviveProgress);
        }
        if (Config.showInventoryBodyHud && class_310.method_1551().field_1755 instanceof class_490) {
            return;
        }
        BHSHud.setHudCords();
        BodyProvider player = (BodyProvider)class_310.method_1551().field_1724;
        if (player != null && class_310.method_1551().field_1761.method_2908()) {
            drawContext.method_51448().method_22903();
            drawContext.method_51448().method_46416(0.0f, 0.0f, -1.0f);
            drawContext.method_51448().method_22905(Config.hudScale, Config.hudScale, 1.0f);
            int color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.HEAD));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.HEAD_X_OFFSET, startY + GUIConstants.HEAD_Y_OFFSET, GUIConstants.HEAD_WIDTH, GUIConstants.HEAD_HEIGHT, color);
            color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.LEFT_ARM));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.LEFT_ARM_X_OFFSET, startY + GUIConstants.LEFT_ARM_Y_OFFSET, GUIConstants.LEFT_ARM_WIDTH, GUIConstants.LEFT_ARM_HEIGHT, color);
            color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.TORSO));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.TORSO_X_OFFSET, startY + GUIConstants.TORSO_Y_OFFSET, GUIConstants.TORSO_WIDTH, GUIConstants.TORSO_HEIGHT, color);
            color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.RIGHT_ARM));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.RIGHT_ARM_X_OFFSET, startY + GUIConstants.RIGHT_ARM_Y_OFFSET, GUIConstants.RIGHT_ARM_WIDTH, GUIConstants.RIGHT_ARM_HEIGHT, color);
            color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.LEFT_LEG));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.LEFT_LEG_X_OFFSET, startY + GUIConstants.LEFT_LEG_Y_OFFSET, GUIConstants.LEFT_LEG_WIDTH, GUIConstants.LEFT_LEG_HEIGHT, color);
            color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.RIGHT_LEG));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.RIGHT_LEG_X_OFFSET, startY + GUIConstants.RIGHT_LEG_Y_OFFSET, GUIConstants.RIGHT_LEG_WIDTH, GUIConstants.RIGHT_LEG_HEIGHT, color);
            color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.LEFT_FOOT));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.LEFT_FOOT_X_OFFSET, startY + GUIConstants.LEFT_FOOT_Y_OFFSET, GUIConstants.LEFT_FOOT_WIDTH, GUIConstants.LEFT_FOOT_HEIGHT, color);
            color = Draw.selectHealthColor(player.getBody().getPart(PlayerBodyParts.RIGHT_FOOT));
            Draw.drawHealthRectangle(drawContext, startX + GUIConstants.RIGHT_FOOT_X_OFFSET, startY + GUIConstants.RIGHT_FOOT_Y_OFFSET, GUIConstants.RIGHT_FOOT_WIDTH, GUIConstants.RIGHT_FOOT_HEIGHT, color);
            drawContext.method_51448().method_22909();
        }
    }

    private static void setHudCords() {
        switch (Config.hudPosition) {
            case TOP_LEFT: {
                startX = Config.hudXOffset;
                startY = Config.hudYOffset;
                break;
            }
            case TOP_RIGHT: {
                startX = class_310.method_1551().method_22683().method_4486() - GUIConstants.BODY_WIDTH - Config.hudXOffset;
                startY = Config.hudYOffset;
                break;
            }
            case BOTTOM_LEFT: {
                startX = Config.hudXOffset;
                startY = class_310.method_1551().method_22683().method_4502() - GUIConstants.BODY_HEIGHT - Config.hudYOffset;
                break;
            }
            case BOTTOM_RIGHT: {
                startX = class_310.method_1551().method_22683().method_4486() - GUIConstants.BODY_WIDTH - Config.hudXOffset;
                startY = class_310.method_1551().method_22683().method_4502() - GUIConstants.BODY_HEIGHT - Config.hudYOffset;
            }
        }
    }

    private float getReviveProgressClient() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return 0.0f;
        }
        if (!player.method_6115()) {
            return 0.0f;
        }
        class_1799 active = player.method_6030();
        if (active == null) {
            return 0.0f;
        }
        class_1792 item = active.method_7909();
        if (!(item instanceof MedkitItem || item instanceof UpgradedMedkitItem || item instanceof TraumaKitItem)) {
            return 0.0f;
        }
        int total = item.method_7881(active);
        int left = player.method_6014();
        if (total <= 0) {
            return 0.0f;
        }
        int elapsed = Math.max(0, total - left);
        float p = (float)elapsed / (float)total;
        if (p <= 0.0f || p > 1.0001f) {
            return 0.0f;
        }
        return p;
    }

    private void drawReviveProgress(class_332 ctx, float progress) {
        class_310 mc = class_310.method_1551();
        int sw = mc.method_22683().method_4486();
        int sh = mc.method_22683().method_4502();
        int width = 80;
        int height = 6;
        int x = (sw - width) / 2;
        int y = sh / 2 + 10;
        int bg = -1442840576;
        int fg = -11751600;
        int border = -855638017;
        ctx.method_25294(x - 1, y - 1, x + width + 1, y, border);
        ctx.method_25294(x - 1, y + height, x + width + 1, y + height + 1, border);
        ctx.method_25294(x - 1, y, x, y + height, border);
        ctx.method_25294(x + width, y, x + width + 1, y + height, border);
        ctx.method_25294(x, y, x + width, y + height, bg);
        int filled = (int)((float)width * Math.min(Math.max(progress, 0.0f), 1.0f));
        ctx.method_25294(x, y, x + filled, y + height, fg);
    }
}

