/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.client.screen;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import xyz.srgnis.bodyhealthsystem.BHSMain;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.PlayerBodyParts;
import xyz.srgnis.bodyhealthsystem.client.screen.BodyOperationsScreenHandler;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.constants.GUIConstants;
import xyz.srgnis.bodyhealthsystem.network.ClientNetworking;
import xyz.srgnis.bodyhealthsystem.util.Draw;

public class BodyOperationsScreen
extends class_465<BodyOperationsScreenHandler> {
    private static final class_2960 TEX_BONEMAIN = new class_2960("bodyhealthsystem", "textures/gui/bonemain.png");
    private static final class_2960 TEX_RIBCAGE = new class_2960("bodyhealthsystem", "textures/gui/ribcage.png");
    private static final class_2960 TEX_SKULL = new class_2960("bodyhealthsystem", "textures/gui/skull.png");
    private static final class_2960 TEX_FOOT = new class_2960("bodyhealthsystem", "textures/gui/foot.png");
    private static final class_2960 TEX_BONEMAIN_BROKEN = new class_2960("bodyhealthsystem", "textures/gui/bonemainbroken.png");
    private static final class_2960 TEX_RIBCAGE_BROKEN = new class_2960("bodyhealthsystem", "textures/gui/ribcagebroken.png");
    private static final class_2960 TEX_FOOT_BROKEN = new class_2960("bodyhealthsystem", "textures/gui/footbroken.png");
    private static final class_2960 TEX_HEALTHSCREEN = new class_2960("bodyhealthsystem", "textures/gui/healthscreen.png");
    private static final class_2960 VANILLA_ICONS = new class_2960("textures/gui/icons.png");
    private static final class_2960 TEX_HARDCORE_HEART = new class_2960("bodyhealthsystem", "textures/gui/hardcoreheart.png");
    private static final int SHEET_W = 256;
    private static final int SHEET_H = 256;
    private static final int GUI_TEX_W = 195;
    private static final int GUI_TEX_H = 136;
    private static final float DRAW_SCALE = 1.6f;
    private static final int LEFT_INSET = 8;
    private static final int RIGHT_INSET = 8;
    private static final int TOP_INSET = 18;
    private static final int BOTTOM_INSET = 16;
    private static final int RIGHT_PANEL_W = 90;
    private static final int GAP = 10;
    private float bodyScale = 1.0f;
    private static boolean BONE_LAYER_ENABLED = true;
    private boolean disabledByMedkit = false;
    private boolean boneLayerWasEnabledOnOpen = false;
    private boolean usedMedkit = false;
    private static final float BODY_Y_SHIFT_LOGICAL = 5.0f;
    private boolean showTemperature = false;
    private double bodyTempC = 36.6;
    private long lastUpdateNanos = 0L;
    private long lastTempRequestNanos = 0L;
    private class_4185 tempToggleBtn;

    public BodyOperationsScreen(BodyOperationsScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = Math.round(312.0f);
        this.field_2779 = Math.round(217.6f);
    }

    protected void method_25426() {
        super.method_25426();
        if (!((BodyOperationsScreenHandler)this.field_2797).getItemStack().method_7960() && BONE_LAYER_ENABLED) {
            this.boneLayerWasEnabledOnOpen = true;
            BONE_LAYER_ENABLED = false;
            this.disabledByMedkit = true;
        }
        if (((BodyOperationsScreenHandler)this.field_2797).getEntity() != null) {
            class_2540 buf = PacketByteBufs.create();
            buf.writeInt(((BodyOperationsScreenHandler)this.field_2797).getEntity().method_5628());
            ClientPlayNetworking.send((class_2960)BHSMain.id("data_request"), (class_2540)buf);
        }
        this.computeBodyScale();
        this.addWidgets();
        this.lastUpdateNanos = System.nanoTime();
        this.bodyTempC = 36.6;
    }

    private void addWidgets() {
        this.method_37067();
        class_1309 target = ((BodyOperationsScreenHandler)this.field_2797).getEntity();
        if (target == null) {
            return;
        }
        boolean allowClick = !((BodyOperationsScreenHandler)this.field_2797).getItemStack().method_7960();
        int startX = (this.field_22789 - this.field_2792) / 2;
        int startY = (this.field_22790 - this.field_2779) / 2;
        int left = startX + Math.round(12.8f);
        int topRegion = Math.round(28.800001f);
        int bottomRegion = Math.round(25.6f);
        int top = startY + topRegion;
        int availH = this.field_2779 - topRegion - bottomRegion;
        int bodyHpx = Math.round((float)GUIConstants.SCALED_BODY_HEIGHT * this.bodyScale);
        int shiftY = Math.round(8.0f);
        int baseY = top + Math.max(0, (availH - bodyHpx) / 2) - shiftY;
        int baseX = left;
        this.method_37063((class_364)new PartButton(PlayerBodyParts.HEAD, baseX + this.sx(GUIConstants.SCALED_HEAD_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_HEAD_Y_OFFSET), this.sx(GUIConstants.SCALED_HEAD_WIDTH), this.sy(GUIConstants.SCALED_HEAD_HEIGHT), allowClick));
        this.method_37063((class_364)new PartButton(PlayerBodyParts.LEFT_ARM, baseX + this.sx(GUIConstants.SCALED_LEFT_ARM_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_LEFT_ARM_Y_OFFSET), this.sx(GUIConstants.SCALED_LEFT_ARM_WIDTH), this.sy(GUIConstants.SCALED_LEFT_ARM_HEIGHT), allowClick));
        this.method_37063((class_364)new PartButton(PlayerBodyParts.TORSO, baseX + this.sx(GUIConstants.SCALED_TORSO_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_TORSO_Y_OFFSET), this.sx(GUIConstants.SCALED_TORSO_WIDTH), this.sy(GUIConstants.SCALED_TORSO_HEIGHT), allowClick));
        this.method_37063((class_364)new PartButton(PlayerBodyParts.RIGHT_ARM, baseX + this.sx(GUIConstants.SCALED_RIGHT_ARM_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_RIGHT_ARM_Y_OFFSET), this.sx(GUIConstants.SCALED_RIGHT_ARM_WIDTH), this.sy(GUIConstants.SCALED_RIGHT_ARM_HEIGHT), allowClick));
        this.method_37063((class_364)new PartButton(PlayerBodyParts.LEFT_LEG, baseX + this.sx(GUIConstants.SCALED_LEFT_LEG_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_LEFT_LEG_Y_OFFSET), this.sx(GUIConstants.SCALED_LEFT_LEG_WIDTH), this.sy(GUIConstants.SCALED_LEFT_LEG_HEIGHT), allowClick));
        this.method_37063((class_364)new PartButton(PlayerBodyParts.RIGHT_LEG, baseX + this.sx(GUIConstants.SCALED_RIGHT_LEG_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_RIGHT_LEG_Y_OFFSET), this.sx(GUIConstants.SCALED_RIGHT_LEG_WIDTH), this.sy(GUIConstants.SCALED_RIGHT_LEG_HEIGHT), allowClick));
        this.method_37063((class_364)new PartButton(PlayerBodyParts.LEFT_FOOT, baseX + this.sx(GUIConstants.SCALED_LEFT_FOOT_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_LEFT_FOOT_Y_OFFSET), this.sx(GUIConstants.SCALED_LEFT_FOOT_WIDTH), this.sy(GUIConstants.SCALED_LEFT_FOOT_HEIGHT), allowClick));
        this.method_37063((class_364)new PartButton(PlayerBodyParts.RIGHT_FOOT, baseX + this.sx(GUIConstants.SCALED_RIGHT_FOOT_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_RIGHT_FOOT_Y_OFFSET), this.sx(GUIConstants.SCALED_RIGHT_FOOT_WIDTH), this.sy(GUIConstants.SCALED_RIGHT_FOOT_HEIGHT), allowClick));
        int rpLeft = startX + Math.round(155.2f);
        int rpTop = startY + Math.round(28.800001f);
        int btnW = Math.round(128.0f);
        int btnH = Math.round(32.0f);
        int btnX = rpLeft + Math.max(0, (Math.round(144.0f) - btnW) / 2);
        int btnY = rpTop;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Bone Layer"), b -> {
            BONE_LAYER_ENABLED = !BONE_LAYER_ENABLED;
        }).method_46434(btnX, btnY, btnW, btnH).method_46431());
        int btnY2 = btnY + btnH + Math.round(9.6f);
        this.tempToggleBtn = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.showTemperature ? "Show Health" : "Show Temp")), b -> {
            this.showTemperature = !this.showTemperature;
            this.tempToggleBtn.method_25355((class_2561)class_2561.method_43470((String)(this.showTemperature ? "Show Health" : "Show Temp")));
            if (this.showTemperature && ((BodyOperationsScreenHandler)this.field_2797).getEntity() != null) {
                ClientNetworking.requestBodyData(((BodyOperationsScreenHandler)this.field_2797).getEntity());
                this.lastTempRequestNanos = System.nanoTime();
            }
        }).method_46434(btnX, btnY2, btnW, btnH).method_46431();
        this.method_37063((class_364)this.tempToggleBtn);
    }

    private void computeBodyScale() {
        int logicalAvailW = 79;
        int logicalAvailH = 102;
        float sx = (float)logicalAvailW / (float)GUIConstants.SCALED_BODY_WIDTH;
        float sy = (float)logicalAvailH / (float)GUIConstants.SCALED_BODY_HEIGHT;
        this.bodyScale = Math.min(sx, sy);
        if (this.bodyScale > 1.2f) {
            this.bodyScale = 1.2f;
        }
        if (this.bodyScale < 0.7f) {
            this.bodyScale = 0.7f;
        }
        this.bodyScale *= 1.6f;
    }

    private int sx(int v) {
        return Math.round((float)v * this.bodyScale);
    }

    private int sy(int v) {
        return Math.round((float)v * this.bodyScale);
    }

    protected void method_2389(class_332 drawContext, float delta, int mouseX, int mouseY) {
        int startX = (this.field_22789 - this.field_2792) / 2;
        int startY = (this.field_22790 - this.field_2779) / 2;
        drawContext.method_25293(TEX_HEALTHSCREEN, startX, startY, this.field_2792, this.field_2779, 0.0f, 0.0f, 195, 136, 256, 256);
        int baseX = startX + Math.round(12.8f);
        int topRegion = Math.round(28.800001f);
        int bottomRegion = Math.round(25.6f);
        int top = startY + topRegion;
        int availH = this.field_2779 - topRegion - bottomRegion;
        int bodyHpx = Math.round((float)GUIConstants.SCALED_BODY_HEIGHT * this.bodyScale);
        int shiftY = Math.round(8.0f);
        int baseY = top + Math.max(0, (availH - bodyHpx) / 2) - shiftY;
        this.drawPart(drawContext, PlayerBodyParts.HEAD, baseX + this.sx(GUIConstants.SCALED_HEAD_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_HEAD_Y_OFFSET), this.sx(GUIConstants.SCALED_HEAD_WIDTH), this.sy(GUIConstants.SCALED_HEAD_HEIGHT));
        this.drawPart(drawContext, PlayerBodyParts.LEFT_ARM, baseX + this.sx(GUIConstants.SCALED_LEFT_ARM_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_LEFT_ARM_Y_OFFSET), this.sx(GUIConstants.SCALED_LEFT_ARM_WIDTH), this.sy(GUIConstants.SCALED_LEFT_ARM_HEIGHT));
        this.drawPart(drawContext, PlayerBodyParts.TORSO, baseX + this.sx(GUIConstants.SCALED_TORSO_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_TORSO_Y_OFFSET), this.sx(GUIConstants.SCALED_TORSO_WIDTH), this.sy(GUIConstants.SCALED_TORSO_HEIGHT));
        this.drawPart(drawContext, PlayerBodyParts.RIGHT_ARM, baseX + this.sx(GUIConstants.SCALED_RIGHT_ARM_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_RIGHT_ARM_Y_OFFSET), this.sx(GUIConstants.SCALED_RIGHT_ARM_WIDTH), this.sy(GUIConstants.SCALED_RIGHT_ARM_HEIGHT));
        this.drawPart(drawContext, PlayerBodyParts.LEFT_LEG, baseX + this.sx(GUIConstants.SCALED_LEFT_LEG_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_LEFT_LEG_Y_OFFSET), this.sx(GUIConstants.SCALED_LEFT_LEG_WIDTH), this.sy(GUIConstants.SCALED_LEFT_LEG_HEIGHT));
        this.drawPart(drawContext, PlayerBodyParts.RIGHT_LEG, baseX + this.sx(GUIConstants.SCALED_RIGHT_LEG_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_RIGHT_LEG_Y_OFFSET), this.sx(GUIConstants.SCALED_RIGHT_LEG_WIDTH), this.sy(GUIConstants.SCALED_RIGHT_LEG_HEIGHT));
        this.drawPart(drawContext, PlayerBodyParts.LEFT_FOOT, baseX + this.sx(GUIConstants.SCALED_LEFT_FOOT_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_LEFT_FOOT_Y_OFFSET), this.sx(GUIConstants.SCALED_LEFT_FOOT_WIDTH), this.sy(GUIConstants.SCALED_LEFT_FOOT_HEIGHT));
        this.drawPart(drawContext, PlayerBodyParts.RIGHT_FOOT, baseX + this.sx(GUIConstants.SCALED_RIGHT_FOOT_X_OFFSET), baseY + this.sy(GUIConstants.SCALED_RIGHT_FOOT_Y_OFFSET), this.sx(GUIConstants.SCALED_RIGHT_FOOT_WIDTH), this.sy(GUIConstants.SCALED_RIGHT_FOOT_HEIGHT));
    }

    protected void method_2388(class_332 drawContext, int mouseX, int mouseY) {
        int x = this.field_25267;
        int y = this.field_25268;
        class_2561 name = ((BodyOperationsScreenHandler)this.field_2797).getEntity().method_5477();
        drawContext.method_51439(this.field_22793, name, x, y, 0xFFFFFF, false);
        try {
            boolean hardcore = ((BodyOperationsScreenHandler)this.field_2797).getEntity().method_37908().method_8401().method_152();
            if (hardcore) {
                int nameW = this.field_22793.method_27525((class_5348)name);
                int heartSize = Math.max(7, Math.round(11.2f));
                int hx = x + nameW + 4;
                Objects.requireNonNull(this.field_22793);
                int hy = y + Math.max(0, (9 - heartSize) / 2);
                drawContext.method_25293(TEX_HARDCORE_HEART, hx, hy, heartSize, heartSize, 0.0f, 0.0f, 7, 7, 7, 7);
            }
        }
        catch (Exception hardcore) {
            // empty catch block
        }
        class_1799 item = ((BodyOperationsScreenHandler)this.field_2797).getItemStack();
        if (!item.method_7960()) {
            String using = item.method_7964().getString();
            int w = this.field_22793.method_1727(using);
            drawContext.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)using), this.field_2792 - 8 - w, y, 0xC0C0C0, false);
        }
    }

    public void method_25394(class_332 drawContext, int mouseX, int mouseY, float delta) {
        if (Config.enableTemperatureSystem && this.showTemperature) {
            Double sv;
            long now = System.nanoTime();
            class_1309 target = ((BodyOperationsScreenHandler)this.field_2797).getEntity();
            if (target != null && (sv = ClientNetworking.getLastBodyTempC((class_1297)target)) != null) {
                this.bodyTempC = sv;
            }
            if (this.lastTempRequestNanos == 0L || now - this.lastTempRequestNanos > 250000000L) {
                if (target != null) {
                    ClientNetworking.requestBodyData(target);
                }
                this.lastTempRequestNanos = now;
            }
        }
        this.method_25420(drawContext);
        super.method_25394(drawContext, mouseX, mouseY, delta);
        this.drawNumbers(drawContext);
        if (!this.showTemperature) {
            for (class_364 child : this.method_25396()) {
                float hbAlloc;
                BodyPart part;
                PartButton b;
                if (!(child instanceof PartButton) || !(b = (PartButton)child).method_25405(mouseX, mouseY) || (part = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(b.partId)) == null) continue;
                ArrayList<class_5250> list = new ArrayList<class_5250>();
                list.add(class_2561.method_43470((String)part.getIdentifier().method_12832()));
                float boost = ((BodyOperationsScreenHandler)this.field_2797).getBody().getBoostForPart(part.getIdentifier());
                float effMax = part.getMaxHealth() + Math.max(0.0f, boost);
                list.add(class_2561.method_43470((String)(Math.round(part.getHealth()) + "/" + Math.round(effMax))));
                float allocAbs = ((BodyOperationsScreenHandler)this.field_2797).getBody().getAbsorptionForPart(part.getIdentifier());
                if (allocAbs > 0.0f) {
                    list.add(class_2561.method_43470((String)("Absorption: " + Math.round(allocAbs))));
                }
                if ((hbAlloc = ((BodyOperationsScreenHandler)this.field_2797).getBody().getBoostForPart(part.getIdentifier())) > 0.0f) {
                    list.add(class_2561.method_43470((String)("Health Boost: " + Math.round(hbAlloc))));
                }
                if (part.isBroken()) {
                    list.add(class_2561.method_43470((String)"Broken"));
                }
                drawContext.method_51434(this.field_22793, list, mouseX, mouseY);
            }
        }
        this.method_2380(drawContext, mouseX, mouseY);
    }

    public void method_25419() {
        if (this.disabledByMedkit && this.boneLayerWasEnabledOnOpen) {
            BONE_LAYER_ENABLED = true;
        }
        super.method_25419();
    }

    private void drawNumbers(class_332 ctx) {
        int startX = (this.field_22789 - this.field_2792) / 2;
        int startY = (this.field_22790 - this.field_2779) / 2;
        int baseX = startX + Math.round(12.8f);
        int topRegion = Math.round(28.800001f);
        int bottomRegion = Math.round(25.6f);
        int top = startY + topRegion;
        int availH = this.field_2779 - topRegion - bottomRegion;
        int bodyHpx = Math.round((float)GUIConstants.SCALED_BODY_HEIGHT * this.bodyScale);
        int shiftY = Math.round(8.0f);
        int baseY = top + Math.max(0, (availH - bodyHpx) / 2) - shiftY;
        class_327 tr = class_310.method_1551().field_1772;
        int white = 0xFFFFFF;
        if (Config.enableTemperatureSystem && this.showTemperature) {
            String tempStr;
            if (Config.temperatureUnit == Config.TemperatureUnit.FAHRENHEIT) {
                double f = this.bodyTempC * 9.0 / 5.0 + 32.0;
                tempStr = String.format("%.1f\u00b0F", f);
            } else {
                tempStr = String.format("%.1f\u00b0C", this.bodyTempC);
            }
            int textW = tr.method_1727(tempStr);
            int torsoCenterX = baseX + this.sx(GUIConstants.SCALED_TORSO_X_OFFSET) + this.sx(GUIConstants.SCALED_TORSO_WIDTH) / 2;
            int torsoCenterY = baseY + this.sy(GUIConstants.SCALED_TORSO_Y_OFFSET) + this.sy(GUIConstants.SCALED_TORSO_HEIGHT) / 2 - 4;
            ctx.method_25303(tr, tempStr, torsoCenterX - textW / 2, torsoCenterY, 0xFFFFFF);
            return;
        }
        BodyPart head = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.HEAD);
        String headStr = this.formatHealth(head);
        int headTextW = tr.method_1727(headStr);
        int headX = baseX + this.sx(GUIConstants.SCALED_HEAD_X_OFFSET) + (this.sx(GUIConstants.SCALED_HEAD_WIDTH) - headTextW) / 2;
        int headY = baseY + this.sy(GUIConstants.SCALED_HEAD_Y_OFFSET) + (this.sy(GUIConstants.SCALED_HEAD_HEIGHT) - 9) / 2;
        ctx.method_25303(tr, headStr, headX, headY, white);
        BodyPart torso = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.TORSO);
        String torsoStr = this.formatHealth(torso);
        int torsoTextW = tr.method_1727(torsoStr);
        int torsoX = baseX + this.sx(GUIConstants.SCALED_TORSO_X_OFFSET) + (this.sx(GUIConstants.SCALED_TORSO_WIDTH) - torsoTextW) / 2;
        int torsoY = baseY + this.sy(GUIConstants.SCALED_TORSO_Y_OFFSET) + (this.sy(GUIConstants.SCALED_TORSO_HEIGHT) - 9) / 2;
        ctx.method_25303(tr, torsoStr, torsoX, torsoY, white);
        BodyPart la = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.LEFT_ARM);
        String laStr = this.formatHealth(la);
        int laTextW = tr.method_1727(laStr);
        int laX = baseX + this.sx(GUIConstants.SCALED_LEFT_ARM_X_OFFSET) + (this.sx(GUIConstants.SCALED_LEFT_ARM_WIDTH) - laTextW) / 2;
        int laY = baseY + this.sy(GUIConstants.SCALED_LEFT_ARM_Y_OFFSET) + (this.sy(GUIConstants.SCALED_LEFT_ARM_HEIGHT) - 9) / 2;
        ctx.method_25303(tr, laStr, laX, laY, white);
        BodyPart ra = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.RIGHT_ARM);
        String raStr = this.formatHealth(ra);
        int raTextW = tr.method_1727(raStr);
        int raX = baseX + this.sx(GUIConstants.SCALED_RIGHT_ARM_X_OFFSET) + (this.sx(GUIConstants.SCALED_RIGHT_ARM_WIDTH) - raTextW) / 2;
        int raY = baseY + this.sy(GUIConstants.SCALED_RIGHT_ARM_Y_OFFSET) + (this.sy(GUIConstants.SCALED_RIGHT_ARM_HEIGHT) - 9) / 2;
        ctx.method_25303(tr, raStr, raX, raY, white);
        BodyPart ll = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.LEFT_LEG);
        String llStr = this.formatHealth(ll);
        int llTextW = tr.method_1727(llStr);
        int llY = baseY + this.sy(GUIConstants.SCALED_LEFT_LEG_Y_OFFSET) + this.sy(GUIConstants.SCALED_LEFT_LEG_HEIGHT) / 2 - 4;
        int llX = baseX + this.sx(GUIConstants.SCALED_LEFT_LEG_X_OFFSET) - llTextW - 2;
        ctx.method_25303(tr, llStr, llX, llY, white);
        BodyPart rl = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.RIGHT_LEG);
        String rlStr = this.formatHealth(rl);
        int rlY = baseY + this.sy(GUIConstants.SCALED_RIGHT_LEG_Y_OFFSET) + this.sy(GUIConstants.SCALED_RIGHT_LEG_HEIGHT) / 2 - 4;
        int rlX = baseX + this.sx(GUIConstants.SCALED_RIGHT_LEG_X_OFFSET) + this.sx(GUIConstants.SCALED_RIGHT_LEG_WIDTH) + 2;
        ctx.method_25303(tr, rlStr, rlX, rlY, white);
        BodyPart lf = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.LEFT_FOOT);
        BodyPart rf = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(PlayerBodyParts.RIGHT_FOOT);
        String lfStr = this.formatHealth(lf);
        String rfStr = this.formatHealth(rf);
        int lfTextW = tr.method_1727(lfStr);
        int rfTextW = tr.method_1727(rfStr);
        int sep = Math.max(2, Math.round(4.8f));
        int lfX = baseX + this.sx(GUIConstants.SCALED_LEFT_FOOT_X_OFFSET) + (this.sx(GUIConstants.SCALED_LEFT_FOOT_WIDTH) - lfTextW) / 2 - sep;
        int rfX = baseX + this.sx(GUIConstants.SCALED_RIGHT_FOOT_X_OFFSET) + (this.sx(GUIConstants.SCALED_RIGHT_FOOT_WIDTH) - rfTextW) / 2 + sep;
        int feetY = baseY + this.sy(GUIConstants.SCALED_LEFT_FOOT_Y_OFFSET) + this.sy(GUIConstants.SCALED_LEFT_FOOT_HEIGHT) + 2;
        ctx.method_25303(tr, lfStr, lfX, feetY, white);
        ctx.method_25303(tr, rfStr, rfX, feetY, white);
    }

    private void drawPart(class_332 ctx, class_2960 partId, int x, int y, int w, int h) {
        BodyPart p = ((BodyOperationsScreenHandler)this.field_2797).getBody().getPart(partId);
        int color = this.showTemperature ? Draw.selectTemperatureColor(this.bodyTempC) : Draw.selectHealthColor(p);
        Draw.drawHealthRectangle(ctx, x, y, w, h, color);
        if (this.showTemperature) {
            return;
        }
        if (!BONE_LAYER_ENABLED) {
            return;
        }
        boolean broken = p.isBroken();
        class_2960 tex = this.selectBoneTexture(partId, broken);
        if (this.isDrawableResource(tex)) {
            if (partId.equals((Object)PlayerBodyParts.LEFT_ARM) || partId.equals((Object)PlayerBodyParts.RIGHT_ARM)) {
                int topH = h / 2;
                int bottomH = h - topH;
                if (broken) {
                    Boolean topBroken = p.getBrokenTopHalf();
                    if (topBroken == null) {
                        topBroken = Boolean.TRUE;
                    }
                    class_2960 brokenTex = TEX_BONEMAIN_BROKEN;
                    class_2960 normalTex = TEX_BONEMAIN;
                    if (topBroken.booleanValue()) {
                        ctx.method_25293(brokenTex, x, y, w, topH, 0.0f, 0.0f, 16, 16, 16, 16);
                        ctx.method_25293(normalTex, x, y + topH, w, bottomH, 0.0f, 0.0f, 16, 16, 16, 16);
                    } else {
                        ctx.method_25293(normalTex, x, y, w, topH, 0.0f, 0.0f, 16, 16, 16, 16);
                        ctx.method_25293(brokenTex, x, y + topH, w, bottomH, 0.0f, 0.0f, 16, 16, 16, 16);
                    }
                } else {
                    ctx.method_25293(tex, x, y, w, topH, 0.0f, 0.0f, 16, 16, 16, 16);
                    ctx.method_25293(tex, x, y + topH, w, bottomH, 0.0f, 0.0f, 16, 16, 16, 16);
                }
            } else {
                ctx.method_25293(tex, x, y, w, h, 0.0f, 0.0f, 16, 16, 16, 16);
            }
        }
    }

    private boolean isDrawableResource(class_2960 id) {
        boolean bl;
        block9: {
            class_3300 rm = class_310.method_1551().method_1478();
            Optional opt = rm.method_14486(id);
            if (opt.isEmpty()) {
                return false;
            }
            InputStream is = ((class_3298)opt.get()).method_14482();
            try {
                boolean bl2 = bl = is.read() != -1;
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return false;
                }
            }
            is.close();
        }
        return bl;
    }

    private class_2960 selectBoneTexture(class_2960 partId, boolean broken) {
        if (partId.equals((Object)PlayerBodyParts.HEAD)) {
            return TEX_SKULL;
        }
        if (partId.equals((Object)PlayerBodyParts.TORSO)) {
            return broken ? TEX_RIBCAGE_BROKEN : TEX_RIBCAGE;
        }
        if (partId.equals((Object)PlayerBodyParts.LEFT_FOOT) || partId.equals((Object)PlayerBodyParts.RIGHT_FOOT)) {
            return broken ? TEX_FOOT_BROKEN : TEX_FOOT;
        }
        return broken ? TEX_BONEMAIN_BROKEN : TEX_BONEMAIN;
    }

    private String formatHealth(BodyPart p) {
        if (p == null) {
            return "0/0";
        }
        Body body = ((BodyOperationsScreenHandler)this.field_2797).getBody();
        float boost = body.getBoostForPart(p.getIdentifier());
        float current = p.getHealth();
        float maxEff = p.getMaxHealth() + Math.max(0.0f, boost);
        return Math.round(current) + "/" + Math.round(maxEff);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 70) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private class PartButton
    extends class_4185 {
        private final class_2960 partId;
        private final boolean allowClick;

        public PartButton(class_2960 partId, int x, int y, int width, int height, boolean allowClick) {
            super(x, y, width, height, (class_2561)class_2561.method_43473(), btn -> {}, class_4185.field_40754);
            this.partId = partId;
            this.allowClick = allowClick;
        }

        public void method_25306() {
            if (!this.allowClick) {
                return;
            }
            BodyPart part = ((BodyOperationsScreenHandler)BodyOperationsScreen.this.field_2797).getBody().getPart(this.partId);
            if (part == null || !part.isDamaged()) {
                return;
            }
            ClientNetworking.useHealingItem((class_1297)((BodyOperationsScreenHandler)BodyOperationsScreen.this.field_2797).getEntity(), part.getIdentifier(), ((BodyOperationsScreenHandler)BodyOperationsScreen.this.field_2797).getItemStack());
            BodyOperationsScreen.this.usedMedkit = true;
            if (BodyOperationsScreen.this.disabledByMedkit && BodyOperationsScreen.this.boneLayerWasEnabledOnOpen) {
                BONE_LAYER_ENABLED = true;
            }
            BodyOperationsScreen.this.method_25419();
        }

        public void method_48579(class_332 drawContext, int mouseX, int mouseY, float delta) {
        }
    }
}

