/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.network;

import gavinx.temperatureapi.BodyTemperatureState;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerLoginConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerLoginNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import xyz.srgnis.bodyhealthsystem.BHSMain;
import xyz.srgnis.bodyhealthsystem.block.AirConditionerBlock;
import xyz.srgnis.bodyhealthsystem.block.AirConditionerBlockEntity;
import xyz.srgnis.bodyhealthsystem.block.SpaceHeaterBlock;
import xyz.srgnis.bodyhealthsystem.block.SpaceHeaterBlockEntity;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;
import xyz.srgnis.bodyhealthsystem.config.Config;
import xyz.srgnis.bodyhealthsystem.registry.ModItems;

public class ServerNetworking {
    public static void initialize() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            class_2540 cfg = PacketByteBufs.create();
            cfg.writeBoolean(Config.enableTemperatureSystem);
            sender.sendPacket(BHSMain.id("temp_cfg"), cfg);
        });
        ServerLoginNetworking.registerGlobalReceiver((class_2960)BHSMain.id("temp_cfg"), (server, handler, understood, buf, synchronizer, responseSender) -> {
            if (!understood) {
                if (Config.enableTemperatureSystem) {
                    handler.method_14380((class_2561)class_2561.method_43470((String)"This server requires Body Health System with temperature sync support. Please update your client mod."));
                }
                return;
            }
            boolean clientEnabled = buf.readBoolean();
            if (Config.enableTemperatureSystem && !clientEnabled) {
                handler.method_14380((class_2561)class_2561.method_43470((String)"This server requires the temperature system to be enabled in Body Health System config."));
            }
        });
        ServerPlayConnectionEvents.JOIN.register(ServerNetworking::syncBody);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BHSMain.MOD_IDENTIFIER, ServerNetworking::handleUseHealingItem);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BHSMain.id("data_request"), ServerNetworking::syncBody);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BHSMain.id("give_up"), (server, player, handler, buf, responseSender) -> server.execute(() -> {
            if (!(player instanceof BodyProvider)) {
                return;
            }
            Body body = ((BodyProvider)player).getBody();
            if (body != null && body.isDowned()) {
                body.forceGiveUp();
            }
        }));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BHSMain.id("temp_request"), (server, player, handler, buf, responseSender) -> {
            int entityId = buf.readInt();
            server.execute(() -> {
                class_1297 e = player.method_37908().method_8469(entityId);
                if (!(e instanceof class_3222)) {
                    return;
                }
                class_3222 spe = (class_3222)e;
                double tempC = 0.0;
                try {
                    tempC = BodyTemperatureState.getC((class_3222)spe);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                class_2540 out = PacketByteBufs.create();
                out.writeInt(entityId);
                out.writeDouble(tempC);
                ServerPlayNetworking.send((class_3222)player, (class_2960)BHSMain.id("temp_sync"), (class_2540)out);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BHSMain.id("ac_mode"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            boolean regulate = buf.readBoolean();
            server.execute(() -> {
                class_1937 world = player.method_37908();
                class_2586 be = world.method_8321(pos);
                if (be instanceof AirConditionerBlockEntity) {
                    AirConditionerBlockEntity ac = (AirConditionerBlockEntity)be;
                    ac.setRegulating(regulate);
                    class_2680 state = world.method_8320(pos);
                    if (state.method_26204() instanceof AirConditionerBlock && state.method_28498((class_2769)AirConditionerBlock.REGULATE) && (Boolean)state.method_11654((class_2769)AirConditionerBlock.REGULATE) != regulate) {
                        world.method_8652(pos, (class_2680)state.method_11657((class_2769)AirConditionerBlock.REGULATE, (Comparable)Boolean.valueOf(regulate)), 3);
                    }
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BHSMain.id("heater_mode"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            boolean regulate = buf.readBoolean();
            server.execute(() -> {
                class_1937 world = player.method_37908();
                class_2586 be = world.method_8321(pos);
                if (be instanceof SpaceHeaterBlockEntity) {
                    SpaceHeaterBlockEntity sh = (SpaceHeaterBlockEntity)be;
                    sh.setRegulating(regulate);
                    class_2680 state = world.method_8320(pos);
                    if (state.method_26204() instanceof SpaceHeaterBlock && state.method_28498((class_2769)SpaceHeaterBlock.REGULATE) && (Boolean)state.method_11654((class_2769)SpaceHeaterBlock.REGULATE) != regulate) {
                        world.method_8652(pos, (class_2680)state.method_11657((class_2769)SpaceHeaterBlock.REGULATE, (Comparable)Boolean.valueOf(regulate)), 3);
                    }
                }
            });
        });
    }

    private static void syncBody(MinecraftServer minecraftServer, class_3222 serverPlayerEntity, class_3244 serverPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        ServerNetworking.syncBody(serverPlayNetworkHandler.field_14140.method_37908().method_8469(packetByteBuf.readInt()), serverPlayNetworkHandler.field_14140);
    }

    private static void syncBody(class_1297 entity, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(entity.method_5628());
        Body body = ((BodyProvider)entity).getBody();
        body.prepareBucketSync();
        for (BodyPart part : body.getParts()) {
            class_2960 idf = part.getIdentifier();
            buf.method_10812(idf);
            buf.writeFloat(part.getHealth());
            buf.writeFloat(part.getMaxHealth());
            buf.writeBoolean(part.isBroken());
            boolean hasHalf = part.getBrokenTopHalf() != null;
            buf.writeBoolean(hasHalf);
            if (hasHalf) {
                buf.writeBoolean(part.getBrokenTopHalf().booleanValue());
            }
            buf.writeFloat(body.getAbsorptionForPart(idf));
            buf.writeFloat(body.getBoostForPart(idf));
        }
        buf.writeBoolean(body.isDowned());
        buf.writeInt(body.getBleedOutTicksRemaining());
        buf.writeBoolean(body.isBeingRevived());
        ServerPlayNetworking.send((class_3222)player, (class_2960)BHSMain.id("data_request"), (class_2540)buf);
    }

    public static void broadcastBody(class_1297 entity) {
        if (!(entity instanceof BodyProvider)) {
            return;
        }
        if (entity instanceof class_3222) {
            class_3222 self = (class_3222)entity;
            ServerNetworking.syncSelf(self);
        }
        for (class_3222 watcher : PlayerLookup.tracking((class_1297)entity)) {
            ServerNetworking.syncBody(entity, watcher);
        }
    }

    private static void syncSelf(class_3222 self) {
        class_2540 buf = PacketByteBufs.create();
        Body body = ((BodyProvider)self).getBody();
        body.prepareBucketSync();
        for (BodyPart part : body.getParts()) {
            class_2960 idf = part.getIdentifier();
            buf.method_10812(idf);
            buf.writeFloat(part.getHealth());
            buf.writeFloat(part.getMaxHealth());
            buf.writeBoolean(part.isBroken());
            boolean hasHalf = part.getBrokenTopHalf() != null;
            buf.writeBoolean(hasHalf);
            if (hasHalf) {
                buf.writeBoolean(part.getBrokenTopHalf().booleanValue());
            }
            buf.writeFloat(body.getAbsorptionForPart(idf));
            buf.writeFloat(body.getBoostForPart(idf));
        }
        buf.writeBoolean(body.isDowned());
        buf.writeInt(body.getBleedOutTicksRemaining());
        buf.writeBoolean(body.isBeingRevived());
        ServerPlayNetworking.send((class_3222)self, (class_2960)BHSMain.MOD_IDENTIFIER, (class_2540)buf);
    }

    private static void handleUseHealingItem(MinecraftServer minecraftServer, class_3222 serverPlayerEntity, class_3244 serverPlayNetworkHandler, class_2540 packetByteBuf, PacketSender packetSender) {
        boolean isUpgraded;
        class_1297 entity = serverPlayerEntity.method_37908().method_8469(packetByteBuf.readInt());
        class_2960 partID = packetByteBuf.method_10810();
        class_1799 itemStack = packetByteBuf.method_10819();
        if (!(entity instanceof BodyProvider)) {
            return;
        }
        Body body = ((BodyProvider)entity).getBody();
        BodyPart part = body.getPart(partID);
        if (part == null) {
            return;
        }
        boolean bl = isUpgraded = itemStack.method_7909() == ModItems.UPGRADED_MEDKIT_ITEM;
        if (isUpgraded) {
            boolean didSomething = false;
            if (part.isBroken()) {
                part.setBroken(false);
                part.setBrokenTopHalf(null);
                part.setHealth(Math.max(1.0f, part.getHealth()));
                body.onBoneTreatmentApplied();
                didSomething = true;
            }
            float effMax = part.getMaxHealth() + Math.max(0.0f, body.getBoostForPart(partID));
            if (part.getHealth() < effMax) {
                body.healPart(4, partID);
                didSomething = true;
            }
            if (didSomething) {
                if (serverPlayerEntity.method_31548().method_7391().method_7909() == itemStack.method_7909()) {
                    serverPlayerEntity.method_31548().method_7391().method_7934(1);
                } else {
                    int slot = serverPlayerEntity.method_31548().method_7395(itemStack);
                    if (slot >= 0) {
                        serverPlayerEntity.method_31548().method_5438(slot).method_7934(1);
                    }
                }
                ServerNetworking.syncBody((class_1657)entity);
            }
            return;
        }
        if (part.isDamaged()) {
            body.healPart(4, partID);
            if (serverPlayerEntity.method_31548().method_7391().method_7909() == itemStack.method_7909()) {
                serverPlayerEntity.method_31548().method_7391().method_7934(1);
            } else {
                int slot = serverPlayerEntity.method_31548().method_7395(itemStack);
                if (slot >= 0) {
                    serverPlayerEntity.method_31548().method_5438(slot).method_7934(1);
                }
            }
            ServerNetworking.syncBody((class_1657)entity);
        }
    }

    public static void syncBody(class_3244 spnh, PacketSender packetSender, MinecraftServer server) {
        class_3222 self = spnh.field_14140;
        server.execute(() -> {
            ServerNetworking.syncSelf(self);
            ServerNetworking.syncBody((class_1297)self, self);
        });
    }

    public static void syncBody(class_1657 pe) {
        if (pe instanceof class_3222) {
            class_3222 self = (class_3222)pe;
            ServerNetworking.syncSelf(self);
        }
        for (class_3222 watcher : PlayerLookup.tracking((class_1297)pe)) {
            ServerNetworking.syncBody((class_1297)pe, watcher);
        }
    }
}

