/*
 * Decompiled with CFR 0.152.
 */
package xyz.srgnis.bodyhealthsystem.util;

import net.minecraft.class_332;
import xyz.srgnis.bodyhealthsystem.body.Body;
import xyz.srgnis.bodyhealthsystem.body.BodyPart;
import xyz.srgnis.bodyhealthsystem.body.player.BodyProvider;
import xyz.srgnis.bodyhealthsystem.constants.GUIConstants;

public class Draw {
    static final int dark_green = -13076963;
    static final int green = -7352832;
    static final int red = -4784128;
    static final int black = -15132391;
    static final int yellow = -9882;
    static final int orange = -492544;
    static final int gray = -10790053;
    private static final int TEMP_HOT = -1172709;
    private static final int TEMP_NORMAL = -13373925;
    private static final int TEMP_COLD = -14987026;

    public static int selectHealthColor(BodyPart part) {
        float boost = 0.0f;
        try {
            if (part != null && part.getIdentifier() != null && ((BodyProvider)part.getEntity()).getBody() != null) {
                Body body = ((BodyProvider)part.getEntity()).getBody();
                boost = Math.max(0.0f, body.getBoostForPart(part.getIdentifier()));
            }
        }
        catch (Throwable body) {
            // empty catch block
        }
        float effectiveMax = part.getMaxHealth() + boost;
        if (effectiveMax <= 0.0f) {
            return -10790053;
        }
        float percent = part.getHealth() / effectiveMax;
        if (percent >= 1.0f) {
            return -13076963;
        }
        if ((double)percent > 0.75) {
            return -7352832;
        }
        if ((double)percent > 0.5) {
            return -9882;
        }
        if ((double)percent > 0.25) {
            return -492544;
        }
        if (percent > 0.0f) {
            return -4784128;
        }
        return -10790053;
    }

    public static int selectTemperatureColor(double bodyTempC) {
        double coldMin = 28.0;
        double greenMin = 36.0;
        double greenMax = 38.0;
        double hotMax = 42.0;
        if (bodyTempC < 36.0) {
            double t = Draw.clamp01((bodyTempC - 28.0) / 8.0);
            return Draw.lerpColor(-14987026, -13373925, t);
        }
        if (bodyTempC > 38.0) {
            double t = Draw.clamp01((bodyTempC - 38.0) / 4.0);
            return Draw.lerpColor(-13373925, -1172709, t);
        }
        return -13373925;
    }

    private static double clamp01(double v) {
        return v < 0.0 ? 0.0 : (v > 1.0 ? 1.0 : v);
    }

    private static int lerpColor(int a, int b, double t) {
        int ar = a >> 16 & 0xFF;
        int ag = a >> 8 & 0xFF;
        int ab = a & 0xFF;
        int br = b >> 16 & 0xFF;
        int bg = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int rr = (int)Math.round((double)ar + (double)(br - ar) * t);
        int rg = (int)Math.round((double)ag + (double)(bg - ag) * t);
        int rb = (int)Math.round((double)ab + (double)(bb - ab) * t);
        return 0xFF000000 | rr << 16 | rg << 8 | rb;
    }

    public static void drawHealthRectangle(class_332 drawContext, int startX, int startY, int width, int height, int color) {
        int endX = startX + width;
        int endY = startY + height;
        drawContext.method_25294(startX, startY, endX, endY, -15132391);
        drawContext.method_25294(startX + GUIConstants.BORDER_SIZE, startY + GUIConstants.BORDER_SIZE, endX - GUIConstants.BORDER_SIZE, endY - GUIConstants.BORDER_SIZE, color);
    }
}

