/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest;

import com.google.common.primitives.Longs;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.class_1799;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2276;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public class CustomCarvingsManager
extends class_4309 {
    private static final List<long[]> FACES = new ArrayList<long[]>();
    private static final List<long[]> FANTASY = new ArrayList<long[]>();

    public CustomCarvingsManager(class_7225.class_7874 provider) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "pumpkin_carvings");
    }

    public static void placeRandomPumpkin(class_2338 pos, class_1936 level, class_2350 direction, boolean onlyFaces, float vanillaChance, float lanternChance, int flag) {
        boolean isLantern;
        boolean isVanilla = !CommonConfigs.customCarvings() || level.method_8409().method_43057() < vanillaChance;
        boolean bl = isLantern = level.method_8409().method_43057() < lanternChance;
        if (isVanilla) {
            level.method_8652(pos, (class_2680)(isLantern ? class_2246.field_10009 : class_2246.field_10147).method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)direction), flag);
        } else {
            level.method_8652(pos, (class_2680)(isLantern ? ModRegistry.JACK_O_LANTERN : ModRegistry.CARVED_PUMPKIN).get().method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)direction), flag);
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof ModCarvedPumpkinBlockTile) {
                ModCarvedPumpkinBlockTile tile = (ModCarvedPumpkinBlockTile)class_25862;
                tile.setPixels(PumpkinCarvingData.unpack(CustomCarvingsManager.getRandomCarving(level.method_8409(), onlyFaces)));
                tile.method_5431();
            }
        }
    }

    public static class_1799 getRandomPumpkinItem(class_1936 level, boolean onlyFaces, float vanillaChance, float lanternChance) {
        class_1799 item;
        boolean isLantern;
        boolean isVanilla = !CommonConfigs.customCarvings() || level.method_8409().method_43057() < vanillaChance;
        boolean bl = isLantern = level.method_8409().method_43057() < lanternChance;
        if (isVanilla) {
            item = (isLantern ? class_2246.field_10009 : class_2246.field_10147).method_8389().method_7854();
        } else {
            item = (isLantern ? ModRegistry.JACK_O_LANTERN : ModRegistry.CARVED_PUMPKIN).get().method_8389().method_7854();
            item.method_57379(ModRegistry.PUMPKIN_CARVING.get(), (Object)PumpkinCarvingData.of(PumpkinCarvingData.unpack(CustomCarvingsManager.getRandomCarving(level.method_8409(), onlyFaces)), PumpkinType.fromPumpkinItem(item.method_7909()), false));
        }
        return item;
    }

    public static long[] getRandomCarving(class_5819 randomSource, boolean onlyFaces) {
        int i;
        if (FACES.isEmpty()) {
            return new long[]{0L, 0L, 0L, 0L};
        }
        long[] l = onlyFaces ? FACES.get(randomSource.method_43048(FACES.size())) : ((i = randomSource.method_43048(FACES.size() + FANTASY.size())) > FACES.size() ? FANTASY.get(i - FACES.size()) : FACES.get(i));
        return l;
    }

    public static void debugPlaceAllPumpkins(class_2338 pos, class_1936 level) {
        ArrayList<long[]> l = new ArrayList<long[]>(FACES);
        l.addAll(FANTASY);
        for (long[] c : l) {
            level.method_8652(pos, (class_2680)ModRegistry.CARVED_PUMPKIN.get().method_9564().method_11657((class_2769)class_2276.field_10748, (Comparable)class_2350.field_11039), 3);
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof ModCarvedPumpkinBlockTile) {
                ModCarvedPumpkinBlockTile tile = (ModCarvedPumpkinBlockTile)class_25862;
                tile.setPixels(PumpkinCarvingData.unpack(c));
                tile.method_5431();
            }
            pos = pos.method_10093(class_2350.field_11043);
        }
    }

    protected void apply(Map<class_2960, JsonElement> jsons, class_3300 resourceManager, class_3695 profiler) {
        FACES.clear();
        FANTASY.clear();
        jsons.forEach((key, json) -> {
            CustomCarving data = (CustomCarving)CustomCarving.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
            if (data.isFace) {
                FACES.add(Longs.toArray(data.pixels));
            } else {
                FANTASY.add(Longs.toArray(data.pixels));
            }
        });
    }

    private static JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = CustomCarvingsManager.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }

    private record CustomCarving(String author, boolean isFace, List<Long> pixels) {
        private static final Codec<CustomCarving> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("author", (Object)"").forGetter(CustomCarving::author), (App)Codec.BOOL.optionalFieldOf("is_face", (Object)false).forGetter(CustomCarving::isFace), (App)Codec.LONG.listOf().fieldOf("pixels").forGetter(CustomCarving::pixels)).apply((Applicative)i, CustomCarving::new));
    }
}

