/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest;

import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.HHPlatformStuff;
import net.mehvahdjukaar.hauntedharvest.SeasonManager;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.entity.ICustomPumpkinHolder;
import net.mehvahdjukaar.hauntedharvest.integration.CompatHandler;
import net.mehvahdjukaar.hauntedharvest.network.NetworkHandler;
import net.mehvahdjukaar.hauntedharvest.network.SyncSnowGolemPumpkinPacket;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModCommands;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTabs;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2969;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3962;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HauntedHarvest {
    public static final String MOD_ID = "hauntedharvest";
    public static final Logger LOGGER = LogManager.getLogger((String)"hauntedharvest");
    private static SeasonManager seasonManager;

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        CommonConfigs.init();
        ModCommands.init();
        ModRegistry.init();
        ModTabs.init();
        NetworkHandler.init();
        CompatHandler.init();
        HalloweenVillagerAI.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientRegistry.init();
            ClientHelper.addClientReloadListener(() -> CarvingManager.INSTANCE, (class_2960)HauntedHarvest.res("pumpkin_carvings"));
        }
        PlatHelper.addCommonSetup(HauntedHarvest::commonSetup);
        RegHelper.registerSimpleRecipeCondition((class_2960)HauntedHarvest.res("flag"), CommonConfigs::isEnabled);
        PlatHelper.addServerReloadListener(CustomCarvingsManager::new, (class_2960)HauntedHarvest.res("pumpkin_carvings"));
    }

    public static void commonSetup() {
        PumpkinType.setup();
        CompatHandler.setup();
        HalloweenVillagerAI.setup();
        class_3962.field_17566.put((Object)ModRegistry.ROTTEN_APPLE.get().method_8389(), 0.65f);
        class_3962.field_17566.put((Object)ModRegistry.GRIM_APPLE.get().method_8389(), 0.65f);
        class_3962.field_17566.put((Object)ModRegistry.CARVED_PUMPKIN.get().method_8389(), 0.65f);
        class_3962.field_17566.put((Object)ModRegistry.KERNELS.get().method_8389(), 0.3f);
        class_3962.field_17566.put((Object)ModRegistry.COB_ITEM.get().method_8389(), 0.5f);
        class_2969 armorBehavior = new class_2969(){

            protected class_1799 method_10135(class_2342 source, class_1799 stack) {
                this.method_27955(class_1738.method_7684((class_2342)source, (class_1799)stack));
                return stack;
            }
        };
        class_2315.method_10009((class_1935)((class_1935)ModRegistry.PAPER_BAG.get()), (class_2357)armorBehavior);
    }

    public static SeasonManager getSeasonManager() {
        if (seasonManager == null) {
            seasonManager = new SeasonManager();
        }
        return seasonManager;
    }

    public static boolean isPlayerOnCooldown(class_1309 self) {
        return false;
    }

    public static boolean isHalloweenSeason(class_1937 level) {
        return seasonManager.isHalloween(level);
    }

    public static boolean isTrickOrTreatTime(class_1937 level) {
        return seasonManager.isTrickOrTreatTime(level);
    }

    public static void onTagLoad() {
        HalloweenVillagerAI.refreshCandies();
    }

    public static class_1269 onRightClickBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hit) {
        class_2338 pos;
        class_2680 state;
        class_1799 stack = player.method_5998(hand);
        class_2350 direction = hit.method_17780();
        PumpkinType t = PumpkinType.getFromTorch(stack.method_7909());
        if (t != null) {
            class_2338 pos2 = hit.method_17777();
            class_2680 state2 = level.method_8320(pos2);
            if (state2.method_26164(ModTags.CARVED_PUMPKINS)) {
                class_2680 toPlace;
                ModCarvedPumpkinBlockTile tile;
                class_2487 tag = null;
                class_2586 class_25862 = level.method_8321(pos2);
                if (class_25862 instanceof ModCarvedPumpkinBlockTile) {
                    tile = (ModCarvedPumpkinBlockTile)class_25862;
                    if (tile.isWaxed()) {
                        return class_1269.field_5811;
                    }
                    tag = tile.method_38244((class_7225.class_7874)level.method_30349());
                    toPlace = t.getPumpkin().method_34725(state2);
                } else {
                    toPlace = t.getVanillaPumpkin().method_34725(state2);
                }
                level.method_8501(pos2, toPlace);
                if (tag != null && (class_25862 = level.method_8321(pos2)) instanceof ModCarvedPumpkinBlockTile) {
                    tile = (ModCarvedPumpkinBlockTile)class_25862;
                    tile.method_58690(tag, (class_7225.class_7874)level.method_30349());
                }
                class_2498 soundType = toPlace.method_26231();
                level.method_8396(player, pos2, soundType.method_10598(), class_3419.field_15245, (soundType.method_10597() + 1.0f) / 2.0f, soundType.method_10599() * 0.8f);
                level.method_43276((class_6880)class_5712.field_28164, pos2, class_5712.class_7397.method_43286((class_1297)player, (class_2680)toPlace));
                if (!player.method_31549().field_7477) {
                    stack.method_7934(1);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    class_174.field_24478.method_23889(serverPlayer, pos2, stack);
                }
                return class_1269.method_29236((boolean)level.field_9236);
            }
            return class_1269.field_5811;
        }
        if (direction == class_2350.field_11036 && HHPlatformStuff.isTopCarver(stack) && (state = level.method_8320(pos = hit.method_17777())).method_27852(class_2246.field_46282)) {
            level.method_8396(player, pos, class_3417.field_14619, class_3419.field_15245, 1.0f, 1.0f);
            class_1542 itemEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)((float)pos.method_10264() + 1.15f), (double)pos.method_10260() + 0.5, new class_1799((class_1935)class_1802.field_46249, 4));
            itemEntity.method_18800(level.field_9229.method_43058() * 0.02, 0.05 + level.field_9229.method_43058() * 0.02, level.field_9229.method_43058() * 0.02);
            level.method_8649((class_1297)itemEntity);
            stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
            level.method_8652(pos, (class_2680)ModRegistry.CARVED_PUMPKIN.get().method_34725(state).method_11657((class_2769)ModCarvedPumpkinBlock.field_10748, (Comparable)player.method_5735().method_10153()), 11);
            if (player instanceof class_3222) {
                ModCarvedPumpkinBlockTile te;
                class_2586 class_25863;
                class_3222 serverPlayer = (class_3222)player;
                class_174.field_24478.method_23889(serverPlayer, pos, stack);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                level.method_33596((class_1297)player, (class_6880)class_5712.field_28730, pos);
                Utils.awardAdvancement((class_3222)serverPlayer, (class_2960)HauntedHarvest.res("husbandry/carve_custom_pumpkin"));
                if (!player.method_21823() && (class_25863 = level.method_8321(pos)) instanceof ModCarvedPumpkinBlockTile && (te = (ModCarvedPumpkinBlockTile)class_25863).getCarveMode().canOpenGui()) {
                    te.tryOpeningEditGui(serverPlayer, pos, stack, player.method_5735().method_10153());
                }
            }
            return class_1269.method_29236((boolean)level.field_9236);
        }
        return class_1269.field_5811;
    }

    public static void onClientEntityLoad(class_1297 entity, class_1937 level) {
        if (!entity.method_37908().field_9236) {
            return;
        }
        if (entity instanceof ICustomPumpkinHolder) {
            ICustomPumpkinHolder q = (ICustomPumpkinHolder)entity;
            NetworkHelper.sendToServer((class_8710)new SyncSnowGolemPumpkinPacket(entity, q));
        }
    }
}

