/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest;

import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Calendar;
import java.util.Date;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.integration.CompatHandler;
import net.mehvahdjukaar.hauntedharvest.integration.SeasonModCompat;
import net.minecraft.class_1937;

public class SeasonManager {
    private int trickOrTreatStart;
    private int trickOrTreatEnd;
    private boolean isHalloweenRealTime;
    private boolean isPumpkinWearTime;
    private boolean isPreciselyHalloweenRealTime;
    private boolean useSeasonMod;

    public int getTrickOrTreatEnd() {
        return this.trickOrTreatEnd;
    }

    public int getTrickOrTreatStart() {
        return this.trickOrTreatStart;
    }

    public void refresh() {
        this.isHalloweenRealTime = this.isDayInBetween(CommonConfigs.START_MONTH.get(), CommonConfigs.START_DAY.get(), CommonConfigs.END_MONTH.get(), CommonConfigs.END_DAY.get());
        this.isPumpkinWearTime = this.isDayInBetween(CommonConfigs.P_START_MONTH.get(), CommonConfigs.P_START_DAY.get(), CommonConfigs.P_END_MONTH.get(), CommonConfigs.P_END_DAY.get());
        LocalDate localdate = LocalDate.now();
        this.isPreciselyHalloweenRealTime = localdate.get(ChronoField.DAY_OF_MONTH) == 31 && localdate.get(ChronoField.MONTH_OF_YEAR) == 10;
        this.trickOrTreatStart = CommonConfigs.START_TIME.get();
        this.trickOrTreatEnd = CommonConfigs.END_TIME.get();
        boolean bl = this.useSeasonMod = CompatHandler.SEASON_MOD_INSTALLED && CommonConfigs.SEASONS_MOD_COMPAT.get() != false;
        if (this.useSeasonMod) {
            SeasonModCompat.refresh();
        }
    }

    private boolean isDayInBetween(int startM, int startD, int endM, int endD) {
        boolean inv = --startM > --endM;
        Calendar calendar = Calendar.getInstance();
        calendar.set(0, startM, startD);
        Date start = calendar.getTime();
        calendar.set(inv ? 1 : 0, endM, endD);
        Date end = calendar.getTime();
        Calendar todayCalendar = Calendar.getInstance();
        int ii = todayCalendar.getTime().before(start) && inv ? 1 : 0;
        todayCalendar.set(ii, todayCalendar.get(2), todayCalendar.get(5));
        Date today = todayCalendar.getTime();
        return SeasonManager.after(today, start) && SeasonManager.before(today, end);
    }

    public static boolean before(Date obj, Date that) {
        int objYear = obj.getYear();
        int thatYear = that.getYear();
        int objMonth = obj.getMonth();
        int thatMonth = that.getMonth();
        int objDay = obj.getDate();
        int thatDay = that.getDate();
        if (objYear < thatYear) {
            return true;
        }
        if (objYear > thatYear) {
            return false;
        }
        if (objMonth < thatMonth) {
            return true;
        }
        if (objMonth > thatMonth) {
            return false;
        }
        return objDay < thatDay;
    }

    public static boolean after(Date obj, Date that) {
        return !SeasonManager.before(obj, that) && !obj.equals(that);
    }

    public boolean isHalloween(class_1937 level) {
        if (this.useSeasonMod) {
            return SeasonModCompat.isAutumn(level);
        }
        return this.isHalloweenRealTime;
    }

    public boolean shouldWearCustomPumpkin(class_1937 level) {
        if (this.isPreciselyHalloweenRealTime) {
            return false;
        }
        if (this.useSeasonMod) {
            return SeasonModCompat.shouldMobWearPumpkin(level);
        }
        return this.isPumpkinWearTime;
    }

    public boolean isTrickOrTreatTime(class_1937 level) {
        return this.isHalloween(level) && this.isBetween(this.trickOrTreatStart, this.trickOrTreatEnd, level.method_8532() % 24000L);
    }

    private boolean isBetween(float start, float end, float mid) {
        if (start < end) {
            return mid >= start && mid <= end;
        }
        return mid <= end || mid >= start;
    }
}

