/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_4095;
import net.minecraft.class_4097;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4168;
import org.jetbrains.annotations.Nullable;

public class GiveCandyToPlayers
extends class_4097<class_1646> {
    private boolean hasGivenCandy = false;
    private int tickSinceStarted = 0;
    private int timeToGiveCandy = 0;

    public GiveCandyToPlayers() {
        super((Map)ImmutableMap.of((Object)class_4140.field_18444, (Object)class_4141.field_18456, (Object)class_4140.field_18445, (Object)class_4141.field_18458, (Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_18447, (Object)class_4141.field_18457));
    }

    protected boolean checkExtraStartConditions(class_3218 pLevel, class_1646 pOwner) {
        if (!HauntedHarvest.isHalloweenSeason((class_1937)pLevel)) {
            return false;
        }
        return this.getValidTarget((class_1309)pOwner) != null;
    }

    public static boolean isValidTrickOrTreater(class_1309 self, class_1309 villagerTarget) {
        if (self.method_5858((class_1297)villagerTarget) <= 12.0 && !HauntedHarvest.isPlayerOnCooldown(self)) {
            class_1297 lookTarget = villagerTarget.method_18868().method_18904(class_4140.field_18447).orElse(null);
            return lookTarget == self;
        }
        return false;
    }

    @Nullable
    private class_1309 getValidTarget(class_1309 self) {
        List list = self.method_18868().method_18904(class_4140.field_19006).orElse(List.of());
        return list.stream().filter(t -> GiveCandyToPlayers.isValidTrickOrTreater(self, t)).findFirst().orElse(null);
    }

    protected boolean canStillUse(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        if (this.tickSinceStarted < 300 && !this.hasGivenCandy) {
            Optional p = pEntity.method_18868().method_18904(class_4140.field_18447);
            return p.isPresent() && GiveCandyToPlayers.isValidTrickOrTreater((class_1309)pEntity, (class_1309)p.get());
        }
        return false;
    }

    protected void tick(class_3218 pLevel, class_1646 pOwner, long pGameTime) {
        class_1309 target = this.lookAtTarget(pOwner);
        if (target != null && this.tickSinceStarted > this.timeToGiveCandy) {
            int r = pLevel.method_8409().method_43048(12);
            if (r == 0) {
                class_1799 stack = new class_1799((class_1935)class_1802.field_8665);
                GiveCandyToPlayers.throwCandy((class_1309)pOwner, target, stack);
                pLevel.method_8421((class_1297)pOwner, (byte)13);
            } else if (r < 3) {
                GiveCandyToPlayers.spookVillager(pOwner, target);
            } else {
                pLevel.method_8421((class_1297)pOwner, (byte)14);
            }
            this.hasGivenCandy = true;
            if (target instanceof IHalloweenVillager) {
                IHalloweenVillager e = (IHalloweenVillager)target;
                e.hauntedharvest$setEntityOnCooldown((class_1297)pOwner);
            }
        }
        ++this.tickSinceStarted;
    }

    public static void spookVillager(class_1646 target, class_1309 cause) {
        class_1937 level = target.method_37908();
        ((class_3218)level).method_14199((class_2394)ModRegistry.SPOOKED_PARTICLE.get(), target.method_23317(), target.method_23318() + 1.25, target.method_23321(), 5, (double)(target.method_17681() / 2.0f), (double)(target.method_17682() / 3.0f), (double)(target.method_17681() / 2.0f), 0.02);
        class_1282 dmg = level.method_48963().method_48830();
        target.method_6015(cause);
        target.method_5643(dmg, 0.1f);
        target.method_6025(0.1f);
        target.method_18868().method_24526(class_4168.field_18599);
        target.method_18868().method_18878(class_4140.field_18451, (Object)dmg);
        target.method_18868().method_18878(class_4140.field_18452, (Object)cause);
    }

    public static void throwCandy(class_1309 self, class_1309 pTarget, class_1799 stack) {
        class_243 vec3 = pTarget.method_18798();
        double pX = pTarget.method_23317() + vec3.field_1352 - self.method_23317();
        double d1 = pTarget.method_23320() - (double)1.1f - self.method_23318();
        double pZ = pTarget.method_23321() + vec3.field_1350 - self.method_23321();
        double d3 = Math.sqrt(pX * pX + pZ * pZ);
        double d0 = self.method_23320() - (double)0.3f;
        class_1937 level = self.method_37908();
        class_1542 itementity = new class_1542(level, self.method_23317(), d0, self.method_23321(), stack);
        float pVelocity = 0.2f;
        double pY = d1 + d3 * 0.7;
        itementity.method_18799(new class_243(pX, pY, pZ).method_1029().method_1021((double)pVelocity));
        level.method_8649((class_1297)itementity);
    }

    protected void start(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        super.method_18920(pLevel, (class_1309)pEntity, pGameTime);
        pEntity.method_18400();
        class_1309 target = this.lookAtTarget(pEntity);
        this.timeToGiveCandy = 20 + pLevel.field_9229.method_43048(30);
        this.tickSinceStarted = 0;
        this.hasGivenCandy = false;
    }

    @Nullable
    private class_1309 lookAtTarget(class_1646 self) {
        class_1309 entity = this.getValidTarget((class_1309)self);
        if (entity != null) {
            class_4095 brain = self.method_18868();
            brain.method_18878(class_4140.field_18447, (Object)entity);
            brain.method_18878(class_4140.field_18446, (Object)new class_4102((class_1297)entity, true));
            brain.method_18875(class_4140.field_18445);
        }
        return entity;
    }

    protected void stop(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        class_4095 brain = pEntity.method_18868();
        brain.method_18875(class_4140.field_18446);
        brain.method_18875(class_4140.field_18447);
        this.hasGivenCandy = false;
        this.tickSinceStarted = 0;
        super.method_18926(pLevel, (class_1309)pEntity, pGameTime);
    }
}

