/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.ai.CarvePumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.EatCandy;
import net.mehvahdjukaar.hauntedharvest.ai.FindAdultThatHasCandy;
import net.mehvahdjukaar.hauntedharvest.ai.GiveCandyToBabies;
import net.mehvahdjukaar.hauntedharvest.ai.GoToAttackTargetIfFurtherThan;
import net.mehvahdjukaar.hauntedharvest.ai.LightUpPumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.PlacePumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.RemovePumpkin;
import net.mehvahdjukaar.hauntedharvest.ai.ThrowEggs;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.entity.VillagerAIHooks;
import net.mehvahdjukaar.moonlight.api.events.IVillagerBrainEvent;
import net.minecraft.class_1277;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_4112;
import net.minecraft.class_4116;
import net.minecraft.class_4117;
import net.minecraft.class_4118;
import net.minecraft.class_4127;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4168;
import net.minecraft.class_4289;
import net.minecraft.class_4458;
import net.minecraft.class_6880;
import net.minecraft.class_7893;
import net.minecraft.class_7923;

public class HalloweenVillagerAI {
    private static final Set<class_1792> BABY_VILLAGER_EATABLE = new HashSet<class_1792>();

    public static void init() {
        VillagerAIHooks.addBrainModification(HalloweenVillagerAI::onVillagerBrainInitialize);
    }

    public static void setup() {
        VillagerAIHooks.registerMemory((class_4140)class_4140.field_22355);
        VillagerAIHooks.registerMemory(ModRegistry.PUMPKIN_POS.get());
        VillagerAIHooks.registerMemory(ModRegistry.NEAREST_PUMPKIN.get());
    }

    public static void onVillagerBrainInitialize(IVillagerBrainEvent event) {
        class_1646 villager = event.getVillager();
        if (HauntedHarvest.isHalloweenSeason(villager.method_37908())) {
            event.addSensor(ModRegistry.PUMPKIN_POI_SENSOR.get());
            if (villager.method_6109()) {
                event.addOrReplaceActivity(ModRegistry.TRICK_OR_TREAT.get(), HalloweenVillagerAI.getTrickOrTreatPackage(0.5f));
                event.addTaskToActivity(class_4168.field_18885, Pair.of((Object)9, (Object)((Object)new EatCandy(100, 130))));
                event.addTaskToActivity(class_4168.field_18885, Pair.of((Object)10, (Object)((Object)new CarvePumpkin(0.5f))));
                event.scheduleActivity(ModRegistry.TRICK_OR_TREAT.get(), HauntedHarvest.getSeasonManager().getTrickOrTreatStart(), HauntedHarvest.getSeasonManager().getTrickOrTreatEnd());
            } else {
                event.addTaskToActivity(class_4168.field_18597, Pair.of((Object)1, (Object)((Object)new GiveCandyToBabies())));
                event.addTaskToActivity(class_4168.field_18595, Pair.of((Object)3, (Object)((Object)new PlacePumpkin(0.5f))));
            }
        } else if (!villager.method_6109()) {
            event.addTaskToActivity(class_4168.field_18595, Pair.of((Object)3, (Object)((Object)new RemovePumpkin(0.5f))));
        }
    }

    private static ImmutableList<Pair<Integer, ? extends class_7893<? super class_1646>>> getTrickOrTreatPackage(float speed) {
        return ImmutableList.of((Object)Pair.of((Object)1, (Object)((Object)new FindAdultThatHasCandy(26, speed * 1.15f))), (Object)Pair.of((Object)1, (Object)new class_4112(210, 320)), (Object)Pair.of((Object)0, (Object)((Object)new AskCandy(2900, 3800))), (Object)Pair.of((Object)3, (Object)((Object)new GoToAttackTargetIfFurtherThan(speed * 1.25f, 10.0f))), (Object)Pair.of((Object)2, (Object)((Object)new ThrowEggs(12))), (Object)Pair.of((Object)7, (Object)((Object)new LightUpPumpkin(speed))), (Object)Pair.of((Object)10, (Object)new class_4118((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18457, (Object)class_4140.field_22355, (Object)class_4141.field_18457, (Object)class_4140.field_18447, (Object)class_4141.field_18457), (List)ImmutableList.of((Object)Pair.of((Object)class_4289.method_46949((float)speed), (Object)7), (Object)Pair.of((Object)class_4458.method_46934((float)speed, (int)4), (Object)10), (Object)Pair.of((Object)class_4116.method_47153((class_4140)class_4140.field_18440, (float)1.0f, (int)50), (Object)2), (Object)Pair.of((Object)class_4117.method_47192((float)speed, (int)25, (int)7), (Object)1)))), (Object)Pair.of((Object)99, (Object)class_4127.method_47184()));
    }

    public static boolean isTrickOrTreater(class_1309 entity) {
        return entity.method_6109() && entity.method_6047().method_31574(class_1802.field_27023);
    }

    public static boolean isCandyOrApple(class_1799 stack) {
        return BABY_VILLAGER_EATABLE.contains(stack.method_7909());
    }

    public static boolean hasCandyOrApple(class_1277 inventory) {
        return inventory.method_18862(BABY_VILLAGER_EATABLE);
    }

    public static void refreshCandies() {
        BABY_VILLAGER_EATABLE.clear();
        HashSet<class_1792> temp = new HashSet<class_1792>();
        for (class_6880 p : class_7923.field_41178.method_40286(ModTags.SWEETS)) {
            temp.add((class_1792)p.comp_349());
        }
        temp.add(ModRegistry.GRIM_APPLE.get());
        temp.add(ModRegistry.ROTTEN_APPLE.get());
        for (class_1792 i : temp) {
            if (i == class_1802.field_8162) continue;
            BABY_VILLAGER_EATABLE.add(i);
        }
    }
}

