/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_4097;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class PlacePumpkin
extends class_4097<class_1646> {
    private final float speedModifier;
    private class_2338 targetPos;
    private int ticksSinceReached = 0;
    private int cooldown = 600;

    public PlacePumpkin(float speed) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18447, (Object)class_4141.field_18457, ModRegistry.PUMPKIN_POS.get(), (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457), 190, 270);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(class_3218 pLevel, class_1646 pOwner) {
        if (!HauntedHarvest.isHalloweenSeason((class_1937)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (pOwner.method_6109()) {
            return false;
        }
        if (pLevel.field_9229.method_43048(2) == 0) {
            this.cooldown = 400;
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((class_1937)pLevel, (class_1297)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        return true;
    }

    protected void start(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        this.cooldown = 20 * (15 + pLevel.field_9229.method_43048(10)) + pLevel.field_9229.method_43048(20);
        this.ticksSinceReached = 0;
        this.targetPos = PlacePumpkin.getValidPumpkinPos(pLevel, (class_1309)pEntity);
        if (this.targetPos != null) {
            pEntity.method_18868().method_18875(class_4140.field_18447);
            pEntity.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos, this.speedModifier, 1));
            AskCandy.displayAsHeldItem(pEntity, new class_1799((class_1935)class_1802.field_17518));
        }
    }

    protected void stop(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        super.method_18926(pLevel, (class_1309)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
        this.targetPos = null;
    }

    protected boolean canStillUse(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        return this.targetPos != null && PlacePumpkin.isValidPlacementSpot(pLevel, this.targetPos);
    }

    protected void tick(class_3218 pLevel, class_1646 pOwner, long pGameTime) {
        if (this.targetPos != null) {
            pOwner.method_18868().method_18875(class_4140.field_18447);
            pOwner.method_18868().method_18878(class_4140.field_18445, (Object)new class_4142(this.targetPos, this.speedModifier, 2));
            pOwner.method_18868().method_18878(class_4140.field_18446, (Object)new class_4099(this.targetPos));
            if (this.targetPos.method_19769((class_2374)pOwner.method_19538(), 2.3)) {
                ++this.ticksSinceReached;
                if (this.ticksSinceReached > 20) {
                    class_2680 state = class_2246.field_46282.method_9564();
                    pLevel.method_8501(this.targetPos, state);
                    class_2498 soundtype = state.method_26231();
                    pLevel.method_8396(null, this.targetPos, soundtype.method_10598(), class_3419.field_15245, (soundtype.method_10597() + 1.0f) / 2.0f, soundtype.method_10599() * 0.8f);
                    pOwner.method_18868().method_18878(ModRegistry.PUMPKIN_POS.get(), (Object)class_4208.method_19443((class_5321)pLevel.method_27983(), (class_2338)this.targetPos));
                    this.targetPos = null;
                }
            }
        }
    }

    @Nullable
    private static class_2338 getValidPumpkinPos(class_3218 pLevel, class_1309 pWalker) {
        class_5819 random = pWalker.method_59922();
        class_2338 blockpos = pWalker.method_24515();
        for (int i = 0; i < 6; ++i) {
            class_2338 pos = blockpos.method_10069(random.method_43048(20) - 10, random.method_43048(6) - 3, random.method_43048(20) - 10);
            if (!PlacePumpkin.isValidPlacementSpot(pLevel, pos)) continue;
            return pos;
        }
        return null;
    }

    public static boolean isValidPlacementSpot(class_3218 serverLevel, class_2338 pos) {
        class_2680 state;
        if (serverLevel.method_8311(pos) && (double)serverLevel.method_8598(class_2902.class_2903.field_13197, pos).method_10264() >= 64.0 && (state = serverLevel.method_8320(pos)).method_45474() && state.method_26227().method_15769()) {
            class_2680 below = serverLevel.method_8320(pos.method_10074());
            return below.method_26164(ModTags.PUMPKIN_SUPPORT);
        }
        return false;
    }
}

