/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.IHarmlessProjectile;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1646;
import net.minecraft.class_1681;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4215;
import org.jetbrains.annotations.Nullable;

public class ThrowEggs
extends class_4097<class_1646> {
    private int cooldownBetweenAttacks;
    private int eggs;
    private final int maxRange;
    private int duration = 400;

    public ThrowEggs(int range) {
        super((Map)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18458, (Object)class_4140.field_22355, (Object)class_4141.field_18456));
        this.maxRange = range;
    }

    protected boolean checkExtraStartConditions(class_3218 pLevel, class_1646 pOwner) {
        class_1309 livingentity = this.getAttackTarget((class_1309)pOwner);
        if (livingentity == null || !livingentity.method_5805()) {
            ThrowEggs.clearAnger(pOwner);
            return false;
        }
        return class_4215.method_24565((class_1309)pOwner, (class_1309)livingentity) && livingentity.method_5649(pOwner.method_23317(), pOwner.method_23318(), pOwner.method_23321()) < (double)(this.maxRange * this.maxRange);
    }

    protected boolean canStillUse(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        return this.eggs == 0 || this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void start(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        class_1309 livingentity = this.getAttackTarget((class_1309)pEntity);
        class_4215.method_19554((class_1309)pEntity, (class_1309)livingentity);
        ThrowEggs.displayAsHeldItem(pEntity, new class_1799((class_1935)class_1802.field_8803));
        if (this.eggs == 0) {
            this.duration = 400;
            this.eggs = pLevel.field_9229.method_43048(2) + 1;
            this.cooldownBetweenAttacks = 35 + pLevel.field_9229.method_43048(30);
        }
    }

    protected void tick(class_3218 pLevel, class_1646 pOwner, long pGameTime) {
        class_1309 target = this.getAttackTarget((class_1309)pOwner);
        if (target == null) {
            return;
        }
        class_4215.method_19554((class_1309)pOwner, (class_1309)target);
        if (this.cooldownBetweenAttacks-- == 0) {
            this.cooldownBetweenAttacks = 20 + pLevel.field_9229.method_43048(30);
            --this.eggs;
            class_1681 egg = new class_1681((class_1937)pLevel, (class_1309)pOwner);
            if (egg instanceof IHarmlessProjectile) {
                IHarmlessProjectile e = (IHarmlessProjectile)egg;
                e.hauntedharvest$setHarmless(true);
            }
            double d0 = target.method_23318() - 0.5;
            double d1 = target.method_23317() - pOwner.method_23317();
            double d2 = d0 - egg.method_23318();
            double d3 = target.method_23321() - pOwner.method_23321();
            double distFactor = Math.sqrt(d1 * d1 + d3 * d3) * (double)0.2f;
            egg.method_7485(d1, (d2 + distFactor) * 0.5, d3, 1.1f, 8.0f);
            pLevel.method_43128(null, pOwner.method_23317(), pOwner.method_23318(), pOwner.method_23321(), class_3417.field_15012, class_3419.field_15254, 0.5f, 0.4f / (pLevel.method_8409().method_43057() * 0.4f + 0.8f));
            pLevel.method_8649((class_1297)egg);
            if (this.eggs <= 0) {
                ThrowEggs.clearAnger(pOwner);
            }
        }
        if (this.duration-- <= 0) {
            ThrowEggs.clearAnger(pOwner);
        }
    }

    public static void clearAnger(class_1646 pOwner) {
        pOwner.method_18868().method_18875(class_4140.field_22355);
        ThrowEggs.displayAsHeldItem(pOwner, class_1799.field_8037);
    }

    private static void displayAsHeldItem(class_1646 self, class_1799 p_182372_) {
        self.method_5673(class_1304.field_6173, p_182372_);
        self.method_5946(class_1304.field_6173, 0.0f);
    }

    protected void stop(class_3218 pLevel, class_1646 pEntity, long pGameTime) {
        super.method_18926(pLevel, (class_1309)pEntity, pGameTime);
    }

    @Nullable
    private class_1309 getAttackTarget(class_1309 pMob) {
        return pMob.method_18868().method_18904(class_4140.field_22355).orElse(null);
    }
}

