/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.blocks.CandyBagTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PaperBagBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2358;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3922;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.class_9062;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class CandyBagBlock
extends class_2248
implements class_2343 {
    public static final class_2754<Content> CONTENT = class_2754.method_11850((String)"content", Content.class);
    public static final class_2758 FILL_LEVEL = class_2758.method_11867((String)"fill_level", (int)1, (int)6);
    private static final int POPCORN_COOK_TIME = 200;

    public CandyBagBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9564().method_11657(CONTENT, (Comparable)((Object)Content.POPCORN))).method_11657((class_2769)FILL_LEVEL, (Comparable)Integer.valueOf(1)));
    }

    public static boolean tryFilling(class_1657 player, class_1937 level, class_2338 pos, class_1799 stack) {
        Content content = Content.get(stack);
        if (content != null) {
            class_2586 class_25862;
            class_1799 remove = player.method_7337() ? stack.method_7972() : stack.method_7971(1);
            remove.method_7939(1);
            class_2680 state = (class_2680)ModRegistry.CANDY_BAG.get().method_9564().method_11657(CONTENT, (Comparable)((Object)content));
            level.method_8501(pos, state);
            CandyBagBlock.playSound(level, pos);
            CandyBagBlock.schedulePopTickIfPossible(state, level, pos);
            if (content == Content.OTHER_CANDY && (class_25862 = level.method_8321(pos)) instanceof CandyBagTile) {
                CandyBagTile tile = (CandyBagTile)class_25862;
                tile.setDisplayedItem(remove);
            }
            return true;
        }
        return false;
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 stack) {
        super.method_9567(level, pos, state, placer, stack);
        CandyBagBlock.schedulePopTickIfPossible(state, level, pos);
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return PaperBagBlock.SHAPE;
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{CONTENT, FILL_LEVEL});
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        class_1792 i;
        List list = super.method_9560(state, builder);
        Object object = builder.method_51876(class_181.field_1228);
        if (object instanceof CandyBagTile) {
            CandyBagTile tile = (CandyBagTile)((Object)object);
            list.add(tile.getDisplayedItem().method_7972());
        }
        if ((i = this.getContent(state)) != null) {
            list.add(new class_1799((class_1935)i, ((Integer)state.method_11654((class_2769)FILL_LEVEL)).intValue()));
        }
        return list;
    }

    protected class_9062 method_55765(class_1799 held, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hitResult) {
        class_1799 item;
        int fill = (Integer)state.method_11654((class_2769)FILL_LEVEL);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof CandyBagTile) {
            CandyBagTile tile = (CandyBagTile)class_25862;
            item = tile.getDisplayedItem();
            if (item.method_7960()) {
                item = null;
            }
        } else {
            item = new class_1799((class_1935)this.getContent(state), fill);
        }
        if (item == null) {
            return class_9062.field_47731;
        }
        int delta = 0;
        if (player.method_5715() && held.method_7960()) {
            class_1799 extracted = item.method_7972().method_7971(1);
            if (!extracted.method_7960()) {
                Utils.swapItem((class_1657)player, (class_1268)hand, (class_1799)extracted);
                delta = -1;
            }
        } else if (fill != 6 && Content.get(held) == state.method_11654(CONTENT)) {
            if (!player.method_7337()) {
                held.method_7934(1);
            }
            CandyBagBlock.playSound(level, pos);
            ++delta;
        } else if (item.method_57826(class_9334.field_50075) && player.method_7332(false) && !player.method_7337()) {
            player.method_60492(level, item.method_7972());
            delta = -1;
            if (level.field_9236) {
                class_2392 particleOptions = new class_2392(class_2398.field_11218, item);
                double dy = 0.005 + (double)fill / 16.0;
                double power = 0.2;
                for (int i = 0; i < 12; ++i) {
                    level.method_8406((class_2394)particleOptions, (double)((float)pos.method_10263() + 0.125f + level.field_9229.method_43057() * 12.0f / 16.0f), (double)pos.method_10264() + dy, (double)((float)pos.method_10260() + 0.125f + level.field_9229.method_43057() * 12.0f / 16.0f), ((double)level.field_9229.method_43057() - 0.5) * power, (double)level.field_9229.method_43057() * power * 0.7, ((double)level.field_9229.method_43057() - 0.5) * power);
                }
            }
        }
        if (delta != 0) {
            int newFill = fill + delta;
            if (newFill == 0) {
                level.method_8501(pos, ModRegistry.PAPER_BAG.get().method_9564());
            } else {
                level.method_8501(pos, (class_2680)state.method_11657((class_2769)FILL_LEVEL, (Comparable)Integer.valueOf(newFill)));
            }
            return class_9062.method_55644((boolean)level.field_9236);
        }
        return class_9062.field_47731;
    }

    private static void playSound(class_1937 level, class_2338 pos) {
        level.method_8396(null, pos, class_3417.field_17611, class_3419.field_15248, 1.0f, 1.2f);
    }

    @Nullable
    public class_1792 getContent(class_2680 state) {
        Optional i;
        Content c = (Content)((Object)state.method_11654(CONTENT));
        if (c.drop != null && (i = class_7923.field_41178.method_17966(class_2960.method_60654((String)c.drop))).isPresent()) {
            return (class_1792)i.get();
        }
        return null;
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 neighbor, class_2338 fromPos, boolean isMoving) {
        super.method_9612(state, level, pos, neighbor, fromPos, isMoving);
        if (state.method_11654(CONTENT) == Content.KERNELS && CandyBagBlock.canCook(level.method_8320(fromPos))) {
            level.method_39279(pos, (class_2248)this, 200);
        }
    }

    public void method_9588(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        boolean canPop;
        if (state.method_11654(CONTENT) == Content.KERNELS && (canPop = Arrays.stream(class_2350.values()).anyMatch(d -> CandyBagBlock.canCook(level.method_8320(pos.method_10093(d)))))) {
            this.popCorn(state, level, pos);
            level.method_39279(pos, (class_2248)this, 3);
        }
    }

    private static void schedulePopTickIfPossible(class_2680 state, class_1937 level, class_2338 pos) {
        boolean canPop = Arrays.stream(class_2350.values()).anyMatch(d -> CandyBagBlock.canCook(level.method_8320(pos.method_10093(d))));
        if (canPop) {
            level.method_39279(pos, state.method_26204(), 200);
        }
    }

    private void popCorn(class_2680 state, class_3218 level, class_2338 pos) {
        int fill = (Integer)state.method_11654((class_2769)FILL_LEVEL);
        class_1799 item = new class_1799((class_1935)ModRegistry.POP_CORN.get());
        level.method_8427(pos, (class_2248)this, 1, 0);
        if (fill == 1) {
            level.method_8501(pos, ModRegistry.PAPER_BAG.get().method_9564());
        } else {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)FILL_LEVEL, (Comparable)Integer.valueOf(fill - 1)));
        }
        class_1542 itemEntity = new class_1542((class_1937)level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.6, (double)pos.method_10260() + 0.5, item);
        itemEntity.method_18800(level.field_9229.method_43058() * 0.02, 0.08 + level.field_9229.method_43058() * 0.2, level.field_9229.method_43058() * 0.02);
        level.method_8649((class_1297)itemEntity);
        level.method_8396(null, pos, class_3417.field_14917, class_3419.field_15245, 0.2f, 2.0f);
    }

    public boolean method_9592(class_2680 state, class_1937 level, class_2338 pos, int id, int param) {
        if (id == 1) {
            if (level.field_9236) {
                int fill = (Integer)state.method_11654((class_2769)FILL_LEVEL);
                class_1799 item = new class_1799((class_1935)ModRegistry.POP_CORN.get());
                class_2392 particleOptions = new class_2392(class_2398.field_11218, item);
                double dy = 0.005 + (double)fill / 16.0;
                double power = 0.3;
                for (int i = 0; i < 7; ++i) {
                    level.method_8406((class_2394)particleOptions, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + dy, (double)pos.method_10260() + 0.5, ((double)level.field_9229.method_43057() - 0.5) * power, (double)level.field_9229.method_43057() * power + 0.2, ((double)level.field_9229.method_43057() - 0.5) * power);
                }
            }
            return true;
        }
        return super.method_9592(state, level, pos, id, param);
    }

    private static boolean canCook(class_2680 neighbor) {
        return neighbor.method_26164(class_3481.field_23799) && (Boolean)neighbor.method_11654((class_2769)class_3922.field_17352) != false || neighbor.method_26204() instanceof class_2358;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return state.method_11654(CONTENT) == Content.OTHER_CANDY ? new CandyBagTile(pos, state) : null;
    }

    public class_1799 method_9574(class_4538 level, class_2338 pos, class_2680 state) {
        return ModRegistry.PAPER_BAG.get().method_8389().method_7854();
    }

    public static enum Content implements class_3542
    {
        CANDY("supplementaries:candy"),
        CANDY_CANE("snowyspirit:candy_cane"),
        CANDY_CORN("hauntedharvest:candy_corn"),
        POPCORN("hauntedharvest:popcorn"),
        KERNELS("hauntedharvest:kernels"),
        OTHER_CANDY(null);

        private final String drop;

        private Content(String drop) {
            this.drop = drop;
        }

        @Nullable
        public static Content get(class_1799 item) {
            if (item.method_7960()) {
                return null;
            }
            String name = Utils.getID((class_1792)item.method_7909()).toString();
            for (Content c : Content.values()) {
                if (c.drop == null || !c.drop.equals(name)) continue;
                return c;
            }
            if (item.method_31573(ModTags.MODDED_CANDIES)) {
                return OTHER_CANDY;
            }
            return null;
        }

        public String method_15434() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

