/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.misc.MapRegistry;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class PumpkinType {
    private static final MapRegistry<PumpkinType> TYPES = new MapRegistry("pumpkin_types");
    private static final Map<class_1792, PumpkinType> TORCH_MAP = new Object2ObjectOpenHashMap();
    public static final Codec<PumpkinType> CODEC = TYPES;
    public static final class_9139<class_2540, PumpkinType> STREAM_CODEC = TYPES.getStreamCodec();
    public static final PumpkinType NORMAL = PumpkinType.register(new PumpkinType(class_2960.method_60656((String)"carved_pumpkin"), () -> null, ModRegistry.CARVED_PUMPKIN, () -> class_2246.field_10147));
    public static final PumpkinType JACK = PumpkinType.register(new PumpkinType(class_2960.method_60656((String)"jack_o_lantern"), () -> class_1802.field_8810, ModRegistry.JACK_O_LANTERN, () -> class_2246.field_10009));
    private final class_2960 name;
    private final Supplier<? extends class_1792> torch;
    private final Supplier<? extends ModCarvedPumpkinBlock> pumpkin;
    private final Supplier<? extends class_2248> vanillaPumpkin;

    public PumpkinType(class_2960 name, Supplier<? extends class_1792> torch, Supplier<? extends ModCarvedPumpkinBlock> pumpkin, Supplier<? extends class_2248> vanillaPumpkin) {
        this.name = name;
        this.torch = torch;
        this.pumpkin = pumpkin;
        this.vanillaPumpkin = vanillaPumpkin;
    }

    public static PumpkinType fromPumpkinItem(class_1792 item) {
        class_1747 bi;
        class_2248 class_22482;
        if (item instanceof class_1747 && (class_22482 = (bi = (class_1747)item).method_7711()) instanceof ModCarvedPumpkinBlock) {
            ModCarvedPumpkinBlock block = (ModCarvedPumpkinBlock)class_22482;
            return block.getType(block.method_9564());
        }
        throw new IllegalArgumentException("Item is not a pumpkin");
    }

    public class_1792 getTorch() {
        return this.torch.get();
    }

    public class_2248 getPumpkin() {
        return (class_2248)this.pumpkin.get();
    }

    public class_2248 getVanillaPumpkin() {
        return this.vanillaPumpkin.get();
    }

    public class_2960 getName() {
        return this.name;
    }

    public String getTextureKey() {
        if (this.name.method_12836().equals("minecraft")) {
            return this.name.method_12832();
        }
        return this.name.method_12836() + "/" + this.name.method_12832();
    }

    public boolean isJackOLantern() {
        return this != NORMAL;
    }

    public static PumpkinType byName(class_2960 type) {
        return (PumpkinType)TYPES.getValueOrDefault(type, (Object)NORMAL);
    }

    @Nullable
    public static PumpkinType getFromTorch(class_1792 torch) {
        return TORCH_MAP.get(torch);
    }

    public static PumpkinType register(PumpkinType pumpkinType) {
        Preconditions.checkArgument((boolean)TORCH_MAP.isEmpty(), (Object)"Pumpkin type must be registered in mod init as it will affect registered blocks");
        TYPES.register(pumpkinType.name, (Object)pumpkinType);
        return pumpkinType;
    }

    public static Collection<PumpkinType> getTypes() {
        return TYPES.getValues();
    }

    public static void setup() {
        for (PumpkinType pumpkinType : TYPES.getValues()) {
            TORCH_MAP.put(pumpkinType.getTorch(), pumpkinType);
        }
    }
}

