/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.minecraft.class_1043;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_777;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CarvingManager
implements class_3302 {
    public static final CarvingManager INSTANCE = new CarvingManager();
    private static final LoadingCache<PumpkinCarvingData, CarvingVisuals> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        CarvingVisuals value = (CarvingVisuals)i.getValue();
        if (value != null) {
            RenderSystem.recordRenderCall(value::close);
        }
    }).build((CacheLoader)new CacheLoader<PumpkinCarvingData, CarvingVisuals>(){

        public CarvingVisuals load(PumpkinCarvingData key) {
            return null;
        }
    });
    private static CarvingVisuals currentCarvingBlur = null;
    private static FrameBufferBackedDynamicTexture pumpkinBlur = null;

    public CompletableFuture<Void> method_25931(class_3302.class_4045 preparationBarrier, class_3300 resourceManager, class_3695 profilerFiller, class_3695 profilerFiller2, Executor executor, Executor executor2) {
        Objects.requireNonNull(preparationBarrier);
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(arg_0 -> ((class_3302.class_4045)preparationBarrier).method_18352(arg_0))).thenAcceptAsync(preparation -> CarvingManager.onTextureReload(), executor2);
    }

    public static CarvingVisuals getInstance(@NotNull PumpkinCarvingData key) {
        CarvingVisuals textureInstance = (CarvingVisuals)TEXTURE_CACHE.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new CarvingVisuals(key.getPixelsUnsafe(), key.getType());
            TEXTURE_CACHE.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    @Nullable
    public static class_2960 getCachedBlurTexture(CarvingVisuals carving) {
        if (pumpkinBlur == null) {
            RenderedTexturesManager.requestTexture((class_2960)HauntedHarvest.res("pumpkinblur"), (int)512, t -> {
                PumpkinTextureGenerator.drawBlur(t, carving);
                pumpkinBlur = t;
            }, (boolean)false);
            return null;
        }
        if (carving != currentCarvingBlur) {
            PumpkinTextureGenerator.drawBlur(pumpkinBlur, carving);
        }
        currentCarvingBlur = carving;
        return pumpkinBlur.getTextureLocation();
    }

    public static void onTextureReload() {
        if (pumpkinBlur != null) {
            pumpkinBlur.close();
            pumpkinBlur = null;
        }
    }

    public static class CarvingVisuals
    implements AutoCloseable {
        public static final int WIDTH = 16;
        private final Map<class_2350, List<class_777>> quadsCache = new EnumMap<class_2350, List<class_777>>(class_2350.class);
        private final boolean[][] pixels;
        private final PumpkinType type;
        @Nullable
        private class_1043 texture;
        @Nullable
        private class_1921 renderType;
        @Nullable
        private class_2960 textureLocation;

        private CarvingVisuals(boolean[][] pixels, PumpkinType type) {
            this.pixels = pixels;
            this.type = type;
        }

        public boolean[][] getPixels() {
            return this.pixels;
        }

        public PumpkinType getType() {
            return this.type;
        }

        private void initializeTexture() {
            this.texture = new class_1043(16, 16, false);
            PumpkinTextureGenerator.drawCarving(this.texture, this);
            this.textureLocation = class_310.method_1551().method_1531().method_4617("carving/", this.texture);
            this.renderType = class_1921.method_23572((class_2960)this.textureLocation);
        }

        public List<class_777> getOrCreateModel(class_2350 dir, BiFunction<CarvingVisuals, class_2350, List<class_777>> modelFactory) {
            return this.quadsCache.computeIfAbsent(dir, d -> (List)modelFactory.apply(this, (class_2350)d));
        }

        public class_2960 getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @Nullable
        public class_2960 getPumpkinBlur() {
            return CarvingManager.getCachedBlurTexture(this);
        }

        public class_1921 getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
            if (this.textureLocation != null) {
                class_310.method_1551().method_1531().method_4615(this.textureLocation);
            }
        }
    }
}

