/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.resources.textures.SpriteUtils;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1058;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4730;
import net.minecraft.class_5253;
import net.minecraft.class_9801;

public class PumpkinTextureGenerator {
    private static class_1043 dummy = null;
    private static class_2960 dummyLocation = null;

    public static void drawCarving(class_1043 texture, CarvingManager.CarvingVisuals carving) {
        boolean[][] pixels = carving.getPixels();
        class_4730[][] materials = PumpkinTextureGenerator.computePixelMaterialMap(pixels, carving.getType());
        for (int y = 0; y < pixels.length && y < 16; ++y) {
            for (int x = 0; x < pixels[y].length && x < 16; ++x) {
                int c = ClientHelper.getPixelRGBA((class_1058)materials[x][y].method_24148(), (int)0, (int)x, (int)y);
                texture.method_4525().method_4305(x, y, c);
            }
        }
        texture.method_4524();
    }

    public static class_4730[][] computePixelMaterialMap(boolean[][] pixels, PumpkinType pumpkinType) {
        PixelType[][] colors = new PixelType[16][16];
        PumpkinTextureGenerator.forEachPixel((Object[][])colors, (j, i) -> {
            colors[j.intValue()][i.intValue()] = !pixels[j][i] ? PixelType.UNCARVED : (PumpkinTextureGenerator.shouldShade(colors, j, i) ? PixelType.SHADE : PixelType.BACKGROUND);
        });
        PumpkinTextureGenerator.addExtraShade(colors);
        PumpkinTextureGenerator.forEachPixel((Object[][])colors, (j, i) -> PumpkinTextureGenerator.addHighlight(colors, j, i));
        Object[][] materials = new class_4730[16][16];
        PumpkinTextureGenerator.forEachPixel(materials, (arg_0, arg_1) -> PumpkinTextureGenerator.lambda$computePixelMaterialMap$2((class_4730[][])materials, pumpkinType, colors, arg_0, arg_1));
        return materials;
    }

    private static void addExtraShade(PixelType[][] px) {
        ArrayList shades = new ArrayList();
        PumpkinTextureGenerator.forEachPixel((Object[][])px, (j, i) -> {
            if (!PumpkinTextureGenerator.isUnCarved(px, j, i) && PumpkinTextureGenerator.isShaded(px, j, i - 1)) {
                if (PumpkinTextureGenerator.isShaded(px, j - 1, i) && PumpkinTextureGenerator.isShaded(px, j + 1, i) && (PumpkinTextureGenerator.isShaded(px, j - 1, i + 1) || PumpkinTextureGenerator.isShaded(px, j + 1, i + 1))) {
                    shades.add(Pair.of((Object)j, (Object)i));
                }
                if (PumpkinTextureGenerator.isShaded(px, j, i + 1) && (PumpkinTextureGenerator.isShaded(px, j + 1, i - 1) && PumpkinTextureGenerator.isShaded(px, j - 1, i) || PumpkinTextureGenerator.isShaded(px, j - 1, i - 1) && PumpkinTextureGenerator.isShaded(px, j + 1, i))) {
                    shades.add(Pair.of((Object)j, (Object)i));
                }
            }
        });
        shades.forEach(p -> {
            px[((Integer)p.getFirst()).intValue()][((Integer)p.getSecond()).intValue()] = PixelType.SHADE;
        });
    }

    private static void addHighlight(PixelType[][] px, int j, int i) {
        if (!(!PumpkinTextureGenerator.isUnCarved(px, j, i) || PumpkinTextureGenerator.isUnCarved(px, j - 1, i) && PumpkinTextureGenerator.isUnCarved(px, j, i - 1))) {
            px[j][i] = PixelType.HIGHLIGHT;
        }
    }

    private static boolean shouldShade(PixelType[][] px, int j, int i) {
        return PumpkinTextureGenerator.isUnCarved(px, j - 1, i) || PumpkinTextureGenerator.isUnCarved(px, j, i - 1);
    }

    private static boolean isUnCarved(PixelType[][] px, int j, int i) {
        if (j < 0 || i < 0 || j > 15 || i > 15) {
            return true;
        }
        PixelType t = px[j][i];
        return t == PixelType.UNCARVED || t == PixelType.HIGHLIGHT;
    }

    private static boolean isShaded(PixelType[][] px, int j, int i) {
        if (j < 0 || i < 0 || j > 15 || i > 15) {
            return true;
        }
        return px[j][i] == PixelType.SHADE;
    }

    public static void forEachPixel(Object[][] px, BiConsumer<Integer, Integer> function) {
        for (int j = 0; j < px.length; ++j) {
            for (int i = 0; i < px[j].length; ++i) {
                function.accept(j, i);
            }
        }
    }

    public static void drawBlur(FrameBufferBackedDynamicTexture t, CarvingManager.CarvingVisuals carving) {
        boolean[][] pixels = carving.getPixels();
        if (dummyLocation == null) {
            dummy = new class_1043(18, 18, false);
            dummyLocation = class_310.method_1551().method_1531().method_4617("carving/", dummy);
        }
        class_1011 p = dummy.method_4525();
        SpriteUtils.forEachPixel((class_1011)p, (T x, U y) -> {
            int alpha = 0;
            if (x == 0 || x == 17 || y == 0 || y == 17 || !pixels[x - 1][y - 1]) {
                alpha = 255;
            }
            p.method_4305(x.intValue(), y.intValue(), class_5253.class_8045.method_48344((int)alpha, (int)0, (int)0, (int)0));
        });
        dummy.method_4524();
        dummy.method_4527(true, false);
        RenderedTexturesManager.drawAsInGUI((FrameBufferBackedDynamicTexture)t, s -> {
            float u0 = 0.055555556f;
            float u1 = 0.9444444f;
            RenderSystem.setShaderTexture((int)0, (class_2960)dummyLocation);
            class_4587.class_4665 matrix = s.method_51448().method_23760();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableBlend();
            RenderSystem.setShader(ClientRegistry::getBlur);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_56824(matrix, 0.0f, 16.0f, 0.0f).method_22913(u0, u0);
            bufferBuilder.method_56824(matrix, 16.0f, 16.0f, 0.0f).method_22913(u1, u0);
            bufferBuilder.method_56824(matrix, 16.0f, 0.0f, 0.0f).method_22913(u1, u1);
            bufferBuilder.method_56824(matrix, 0.0f, 0.0f, 0.0f).method_22913(u0, u1);
            class_286.method_43433((class_9801)bufferBuilder.method_60794());
        });
        t.method_4527(true, false);
    }

    private static /* synthetic */ void lambda$computePixelMaterialMap$2(class_4730[][] materials, PumpkinType pumpkinType, PixelType[][] colors, Integer j, Integer i) {
        materials[j.intValue()][i.intValue()] = ClientRegistry.getMaterial(pumpkinType, colors[j][i].ordinal());
    }

    private static enum PixelType {
        UNCARVED,
        SHADE,
        BACKGROUND,
        HIGHLIGHT;

    }
}

