/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client.screens;

import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.hauntedharvest.client.screens.CarvingButton;
import net.mehvahdjukaar.hauntedharvest.network.ServerBoundCarvePumpkinPacket;
import net.mehvahdjukaar.moonlight.api.misc.CircularList;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.minecraft.class_1657;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4730;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_8710;

public class CarvingScreen
extends class_437 {
    private static final class_5250 UNDO = class_2561.method_43471((String)"gui.hauntedharvest.carving.undo");
    private static final class_5250 CLEAR = class_2561.method_43471((String)"gui.hauntedharvest.carving.clear");
    private static final class_5250 EDIT = class_2561.method_43471((String)"gui.hauntedharvest.carving.edit");
    private final ModCarvedPumpkinBlockTile tile;
    private final CarvingButton[][] buttons = new CarvingButton[16][16];
    private final Deque<List<Entry>> history = new CircularList(20);
    private final class_2350 clickedFace;
    private List<Entry> currentHistoryStep = new ArrayList<Entry>();
    private class_4185 historyButton;

    private CarvingScreen(ModCarvedPumpkinBlockTile teBoard, class_2350 dir) {
        super((class_2561)EDIT);
        this.tile = teBoard;
        this.clickedFace = dir;
    }

    public static void open(ModCarvedPumpkinBlockTile tile, class_2350 dir) {
        class_310.method_1551().method_1507((class_437)new CarvingScreen(tile, dir));
    }

    public void recomputeMaterials() {
        class_4730[][] materials = PumpkinTextureGenerator.computePixelMaterialMap(this.computePixelMatrix(), this.tile.getPumpkinType());
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setMaterial(materials[xx][yy]);
            }
        }
    }

    private boolean[][] computePixelMatrix() {
        boolean[][] pixels = new boolean[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].carved;
            }
        }
        return pixels;
    }

    public void method_25393() {
        if (!this.isValid()) {
            this.method_25419();
        } else if (!(this.method_25399() instanceof CarvingButton)) {
            this.method_25395(null);
        }
    }

    private boolean isValid() {
        return this.field_22787 != null && this.field_22787.field_1724 != null && !this.tile.method_11015() && this.tile.isEditingPlayer(this.tile.method_11016(), (class_1657)this.field_22787.field_1724);
    }

    public void method_25419() {
        this.tile.method_5431();
        super.method_25419();
    }

    public void method_25432() {
        boolean[][] pixels = new boolean[16][16];
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                pixels[xx][yy] = this.buttons[xx][yy].getCarved();
            }
        }
        NetworkHelper.sendToServer((class_8710)new ServerBoundCarvePumpkinPacket(this.tile.method_11016(), pixels, this.clickedFace));
    }

    public void updateBlackboard(int x, int y, boolean newColor) {
        this.tile.setPixel(x, y, newColor);
        this.recomputeMaterials();
    }

    public void addHistory(int x, int y, boolean oldColor) {
        this.currentHistoryStep.add(new Entry(x, y, oldColor));
    }

    public void saveHistoryStep() {
        if (!this.currentHistoryStep.isEmpty()) {
            this.history.add(this.currentHistoryStep);
            this.currentHistoryStep = new ArrayList<Entry>();
            this.historyButton.field_22763 = true;
        }
    }

    public void onButtonDragged(double mx, double my, boolean buttonValue) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                CarvingButton b = this.buttons[xx][yy];
                if (!b.method_25405(mx, my) || b.getCarved() == buttonValue) continue;
                b.setCarved(buttonValue);
            }
        }
    }

    private void clearPressed(class_4185 button) {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                this.buttons[xx][yy].setCarved(false);
            }
        }
        this.saveHistoryStep();
    }

    private void undoPressed(class_4185 button) {
        if (!this.history.isEmpty()) {
            for (Entry v : this.history.pollLast()) {
                this.buttons[v.x()][v.y()].setCarved(v.carved);
            }
            this.currentHistoryStep.clear();
        }
        if (this.history.isEmpty()) {
            this.historyButton.field_22763 = false;
        }
    }

    protected void method_25426() {
        for (int xx = 0; xx < 16; ++xx) {
            for (int yy = 0; yy < 16; ++yy) {
                boolean pixel = this.tile.getPixel(xx, yy);
                CarvingButton widget = new CarvingButton(this, this.field_22789 / 2, 65, xx, yy, pixel);
                this.buttons[xx][yy] = (CarvingButton)this.method_37063(widget);
            }
        }
        this.recomputeMaterials();
        int buttonW = 56;
        int sep = 4;
        this.method_37063((class_364)class_4185.method_46430((class_2561)CLEAR, this::clearPressed).method_46434(this.field_22789 / 2 - buttonW / 2 - buttonW + sep / 2, this.field_22790 / 4 + 120, buttonW - sep, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.method_25419()).method_46434(this.field_22789 / 2 - buttonW / 2 + sep / 2, this.field_22790 / 4 + 120, buttonW - sep, 20).method_46431());
        this.historyButton = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)UNDO, this::undoPressed).method_46434(this.field_22789 / 2 + buttonW / 2 + sep / 2, this.field_22790 / 4 + 120, buttonW - sep, 20).method_46431());
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, 40, 0xFFFFFF);
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
    }

    private record Entry(int x, int y, boolean carved) {
    }
}

