/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.blocks.AbstractCornBlock;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.integration.CompatHandler;
import net.mehvahdjukaar.hauntedharvest.integration.FDCompat;
import net.mehvahdjukaar.hauntedharvest.integration.SuppCompat;
import net.minecraft.class_1936;
import net.minecraft.class_2195;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2513;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3481;
import net.minecraft.class_3542;
import net.minecraft.class_5281;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_5821;

public class FarmFieldFeature
extends class_3031<Config> {
    public FarmFieldFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<Config> context) {
        Config config = (Config)context.method_33656();
        class_5819 random = context.method_33654();
        class_2338 blockPos = context.method_33655();
        class_5281 level = context.method_33652();
        CropType crop = config.crop();
        if (!crop.isEnabled()) {
            return false;
        }
        boolean scarecrow = config.scarecrow();
        if (scarecrow) {
            this.placeScarecrow(blockPos, level, random);
        }
        int i = 0;
        class_2338.class_2339 p = new class_2338.class_2339();
        int j = config.xzSpread() + 1;
        int k = config.ySpread() + 1;
        block5: for (int l = 0; l < config.tries(); ++l) {
            p.method_25504((class_2382)blockPos, random.method_43048(j) - random.method_43048(j), random.method_43048(k) - random.method_43048(k), random.method_43048(j) - random.method_43048(j));
            if (!level.method_8320(p.method_10074()).method_26164(class_3481.field_29822)) continue;
            switch (crop.ordinal()) {
                case 1: {
                    if (!this.placeCorn(p, level, random)) continue block5;
                    break;
                }
                case 2: {
                    if (!SuppCompat.placeFlax(p, level, random)) continue block5;
                    break;
                }
                case 3: {
                    if (!this.placeTomatoes(p, level, random)) continue block5;
                    break;
                }
                default: {
                    if (!this.placePumpkin(p, level, random)) continue block5;
                }
            }
            level.method_8652(p.method_10074(), class_2246.field_10362.method_9564(), 2);
            ++i;
        }
        return i > 0;
    }

    private boolean placeTomatoes(class_2338.class_2339 p, class_5281 level, class_5819 random) {
        if (level.method_8320((class_2338)p).method_26215()) {
            level.method_8652((class_2338)p, FDCompat.getTomato(random), 2);
            return true;
        }
        return false;
    }

    private void placeScarecrow(class_2338 blockPos, class_5281 level, class_5819 random) {
        level.method_8652(blockPos, class_2246.field_10020.method_9564(), 2);
        class_2338 above = blockPos.method_10084();
        class_2350 dir = class_2350.class_2353.field_11062.method_10183(random);
        level.method_8652(above, class_2246.field_10359.method_9564(), 3);
        class_2338 left = above.method_10093(dir);
        level.method_8652(left, class_2248.method_9510((class_2680)class_2246.field_10020.method_9564(), (class_1936)level, (class_2338)left), 2);
        class_2338 right = above.method_10093(dir.method_10153());
        level.method_8652(right, class_2248.method_9510((class_2680)class_2246.field_10020.method_9564(), (class_1936)level, (class_2338)right), 2);
        CustomCarvingsManager.placeRandomPumpkin(above.method_10084(), (class_1936)level, dir.method_10170(), true, 0.2f, 0.15f, 2);
    }

    private boolean placeCorn(class_2338.class_2339 pos, class_5281 level, class_5819 random) {
        int age = random.method_43048(7);
        return AbstractCornBlock.spawn((class_2338)pos, (class_1936)level, age);
    }

    private boolean placePumpkin(class_2338.class_2339 pos, class_5281 level, class_5819 random) {
        class_2350 dir = class_2350.class_2353.field_11062.method_10183(random);
        class_2338 pumpkinPos = pos.method_10093(dir);
        if (level.method_8320((class_2338)pos).method_26215()) {
            if (random.method_43056()) {
                if (level.method_8320(pumpkinPos).method_26215() && level.method_8320(pumpkinPos.method_10074()).method_26164(class_3481.field_29822)) {
                    level.method_8652(pumpkinPos, class_2246.field_46282.method_9564(), 2);
                    level.method_8652((class_2338)pos, (class_2680)class_2246.field_46284.method_9564().method_11657((class_2769)class_2195.field_9873, (Comparable)dir), 2);
                    return true;
                }
            } else {
                level.method_8652((class_2338)pos, (class_2680)class_2246.field_46286.method_9564().method_11657((class_2769)class_2513.field_11584, (Comparable)Integer.valueOf(random.method_43048(8))), 2);
                return true;
            }
        }
        return false;
    }

    public record Config(int tries, int xzSpread, int ySpread, CropType crop, boolean scarecrow) implements class_3037
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33442.fieldOf("tries").orElse((Object)64).forGetter(Config::tries), (App)class_5699.field_33441.fieldOf("xz_spread").orElse((Object)7).forGetter(Config::xzSpread), (App)class_5699.field_33441.fieldOf("y_spread").orElse((Object)3).forGetter(Config::ySpread), (App)class_3542.method_28140(CropType::values).fieldOf("crop").forGetter(Config::crop), (App)Codec.BOOL.optionalFieldOf("has_scarecrow", (Object)false).forGetter(Config::scarecrow)).apply((Applicative)instance, Config::new));
    }

    public static enum CropType implements class_3542
    {
        PUMPKIN,
        CORN,
        FLAX,
        TOMATOES;


        public boolean isEnabled() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> CommonConfigs.CORN_ENABLED.get();
                case 2 -> {
                    if (CompatHandler.SUPP_INSTALLED && SuppCompat.isFlaxOn()) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> true;
                case 3 -> CompatHandler.FD_INSTALLED;
            };
        }

        public String method_15434() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

