/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest;

import com.google.common.primitives.Longs;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.RandomSource;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomCarvingsManager
extends SimpleJsonResourceReloadListener {
    private static final List<long[]> FACES = new ArrayList<long[]>();
    private static final List<long[]> FANTASY = new ArrayList<long[]>();

    public CustomCarvingsManager(HolderLookup.Provider provider) {
        super(new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create(), "pumpkin_carvings");
    }

    public static void placeRandomPumpkin(BlockPos pos, LevelAccessor level, Direction direction, boolean onlyFaces, float vanillaChance, float lanternChance, int flag) {
        boolean isLantern;
        boolean isVanilla = !CommonConfigs.customCarvings() || level.getRandom().nextFloat() < vanillaChance;
        boolean bl = isLantern = level.getRandom().nextFloat() < lanternChance;
        if (isVanilla) {
            level.setBlock(pos, (BlockState)(isLantern ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN).defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)direction), flag);
        } else {
            level.setBlock(pos, (BlockState)(isLantern ? ModRegistry.JACK_O_LANTERN : ModRegistry.CARVED_PUMPKIN).get().defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)direction), flag);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
                ModCarvedPumpkinBlockTile tile = (ModCarvedPumpkinBlockTile)blockEntity;
                tile.setPixels(PumpkinCarvingData.unpack(CustomCarvingsManager.getRandomCarving(level.getRandom(), onlyFaces)));
                tile.setChanged();
            }
        }
    }

    public static ItemStack getRandomPumpkinItem(LevelAccessor level, boolean onlyFaces, float vanillaChance, float lanternChance) {
        ItemStack item;
        boolean isLantern;
        boolean isVanilla = !CommonConfigs.customCarvings() || level.getRandom().nextFloat() < vanillaChance;
        boolean bl = isLantern = level.getRandom().nextFloat() < lanternChance;
        if (isVanilla) {
            item = (isLantern ? Blocks.JACK_O_LANTERN : Blocks.CARVED_PUMPKIN).asItem().getDefaultInstance();
        } else {
            item = (isLantern ? ModRegistry.JACK_O_LANTERN : ModRegistry.CARVED_PUMPKIN).get().asItem().getDefaultInstance();
            item.set(ModRegistry.PUMPKIN_CARVING.get(), (Object)PumpkinCarvingData.of(PumpkinCarvingData.unpack(CustomCarvingsManager.getRandomCarving(level.getRandom(), onlyFaces)), PumpkinType.fromPumpkinItem(item.getItem()), false));
        }
        return item;
    }

    public static long[] getRandomCarving(RandomSource randomSource, boolean onlyFaces) {
        int i;
        if (FACES.isEmpty()) {
            return new long[]{0L, 0L, 0L, 0L};
        }
        long[] l = onlyFaces ? FACES.get(randomSource.nextInt(FACES.size())) : ((i = randomSource.nextInt(FACES.size() + FANTASY.size())) > FACES.size() ? FANTASY.get(i - FACES.size()) : FACES.get(i));
        return l;
    }

    public static void debugPlaceAllPumpkins(BlockPos pos, LevelAccessor level) {
        ArrayList<long[]> l = new ArrayList<long[]>(FACES);
        l.addAll(FANTASY);
        for (long[] c : l) {
            level.setBlock(pos, (BlockState)ModRegistry.CARVED_PUMPKIN.get().defaultBlockState().setValue((Property)CarvedPumpkinBlock.FACING, (Comparable)Direction.WEST), 3);
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
                ModCarvedPumpkinBlockTile tile = (ModCarvedPumpkinBlockTile)blockEntity;
                tile.setPixels(PumpkinCarvingData.unpack(c));
                tile.setChanged();
            }
            pos = pos.relative(Direction.NORTH);
        }
    }

    protected void apply(Map<ResourceLocation, JsonElement> jsons, ResourceManager resourceManager, ProfilerFiller profiler) {
        FACES.clear();
        FANTASY.clear();
        jsons.forEach((key, json) -> {
            CustomCarving data = (CustomCarving)CustomCarving.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
            if (data.isFace) {
                FACES.add(Longs.toArray(data.pixels));
            } else {
                FANTASY.add(Longs.toArray(data.pixels));
            }
        });
    }

    private static JsonObject sortJson(JsonObject jsonObject) {
        try {
            TreeMap<String, JsonElement> joToMap = new TreeMap<String, JsonElement>();
            jsonObject.entrySet().forEach(e -> {
                JsonElement j = (JsonElement)e.getValue();
                if (j instanceof JsonObject) {
                    JsonObject jo = (JsonObject)j;
                    j = CustomCarvingsManager.sortJson(jo);
                }
                joToMap.put((String)e.getKey(), j);
            });
            JsonObject sortedJSON = new JsonObject();
            joToMap.forEach((arg_0, arg_1) -> ((JsonObject)sortedJSON).add(arg_0, arg_1));
            return sortedJSON;
        }
        catch (Exception exception) {
            return jsonObject;
        }
    }

    private record CustomCarving(String author, boolean isFace, List<Long> pixels) {
        private static final Codec<CustomCarving> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.optionalFieldOf("author", (Object)"").forGetter(CustomCarving::author), (App)Codec.BOOL.optionalFieldOf("is_face", (Object)false).forGetter(CustomCarving::isFace), (App)Codec.LONG.listOf().fieldOf("pixels").forGetter(CustomCarving::pixels)).apply((Applicative)i, CustomCarving::new));
    }
}

