/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest;

import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.HHPlatformStuff;
import net.mehvahdjukaar.hauntedharvest.SeasonManager;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.entity.ICustomPumpkinHolder;
import net.mehvahdjukaar.hauntedharvest.integration.CompatHandler;
import net.mehvahdjukaar.hauntedharvest.network.NetworkHandler;
import net.mehvahdjukaar.hauntedharvest.network.SyncSnowGolemPumpkinPacket;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModCommands;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTabs;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HauntedHarvest {
    public static final String MOD_ID = "hauntedharvest";
    public static final Logger LOGGER = LogManager.getLogger((String)"hauntedharvest");
    private static SeasonManager seasonManager;

    public static ResourceLocation res(String name) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)name);
    }

    public static void commonInit() {
        CommonConfigs.init();
        ModCommands.init();
        ModRegistry.init();
        ModTabs.init();
        NetworkHandler.init();
        CompatHandler.init();
        HalloweenVillagerAI.init();
        if (PlatHelper.getPhysicalSide().isClient()) {
            ClientRegistry.init();
            ClientHelper.addClientReloadListener(() -> CarvingManager.INSTANCE, (ResourceLocation)HauntedHarvest.res("pumpkin_carvings"));
        }
        PlatHelper.addCommonSetup(HauntedHarvest::commonSetup);
        RegHelper.registerSimpleRecipeCondition((ResourceLocation)HauntedHarvest.res("flag"), CommonConfigs::isEnabled);
        PlatHelper.addServerReloadListener(CustomCarvingsManager::new, (ResourceLocation)HauntedHarvest.res("pumpkin_carvings"));
    }

    public static void commonSetup() {
        PumpkinType.setup();
        CompatHandler.setup();
        HalloweenVillagerAI.setup();
        ComposterBlock.COMPOSTABLES.put((Object)ModRegistry.ROTTEN_APPLE.get().asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)ModRegistry.GRIM_APPLE.get().asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)ModRegistry.CARVED_PUMPKIN.get().asItem(), 0.65f);
        ComposterBlock.COMPOSTABLES.put((Object)ModRegistry.KERNELS.get().asItem(), 0.3f);
        ComposterBlock.COMPOSTABLES.put((Object)ModRegistry.COB_ITEM.get().asItem(), 0.5f);
        OptionalDispenseItemBehavior armorBehavior = new OptionalDispenseItemBehavior(){

            protected ItemStack execute(BlockSource source, ItemStack stack) {
                this.setSuccess(ArmorItem.dispenseArmor((BlockSource)source, (ItemStack)stack));
                return stack;
            }
        };
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)ModRegistry.PAPER_BAG.get()), (DispenseItemBehavior)armorBehavior);
    }

    public static SeasonManager getSeasonManager() {
        if (seasonManager == null) {
            seasonManager = new SeasonManager();
        }
        return seasonManager;
    }

    public static boolean isPlayerOnCooldown(LivingEntity self) {
        return false;
    }

    public static boolean isHalloweenSeason(Level level) {
        return seasonManager.isHalloween(level);
    }

    public static boolean isTrickOrTreatTime(Level level) {
        return seasonManager.isTrickOrTreatTime(level);
    }

    public static void onTagLoad() {
        HalloweenVillagerAI.refreshCandies();
    }

    public static InteractionResult onRightClickBlock(Player player, Level level, InteractionHand hand, BlockHitResult hit) {
        BlockPos pos;
        BlockState state;
        ItemStack stack = player.getItemInHand(hand);
        Direction direction = hit.getDirection();
        PumpkinType t = PumpkinType.getFromTorch(stack.getItem());
        if (t != null) {
            BlockPos pos2 = hit.getBlockPos();
            BlockState state2 = level.getBlockState(pos2);
            if (state2.is(ModTags.CARVED_PUMPKINS)) {
                BlockState toPlace;
                ModCarvedPumpkinBlockTile tile;
                CompoundTag tag = null;
                BlockEntity blockEntity = level.getBlockEntity(pos2);
                if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
                    tile = (ModCarvedPumpkinBlockTile)blockEntity;
                    if (tile.isWaxed()) {
                        return InteractionResult.PASS;
                    }
                    tag = tile.saveWithoutMetadata((HolderLookup.Provider)level.registryAccess());
                    toPlace = t.getPumpkin().withPropertiesOf(state2);
                } else {
                    toPlace = t.getVanillaPumpkin().withPropertiesOf(state2);
                }
                level.setBlockAndUpdate(pos2, toPlace);
                if (tag != null && (blockEntity = level.getBlockEntity(pos2)) instanceof ModCarvedPumpkinBlockTile) {
                    tile = (ModCarvedPumpkinBlockTile)blockEntity;
                    tile.loadWithComponents(tag, (HolderLookup.Provider)level.registryAccess());
                }
                SoundType soundType = toPlace.getSoundType();
                level.playSound(player, pos2, soundType.getPlaceSound(), SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
                level.gameEvent((Holder)GameEvent.BLOCK_PLACE, pos2, GameEvent.Context.of((Entity)player, (BlockState)toPlace));
                if (!player.getAbilities().instabuild) {
                    stack.shrink(1);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos2, stack);
                }
                return InteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            return InteractionResult.PASS;
        }
        if (direction == Direction.UP && HHPlatformStuff.isTopCarver(stack) && (state = level.getBlockState(pos = hit.getBlockPos())).is(Blocks.PUMPKIN)) {
            level.playSound(player, pos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)((float)pos.getY() + 1.15f), (double)pos.getZ() + 0.5, new ItemStack((ItemLike)Items.PUMPKIN_SEEDS, 4));
            itemEntity.setDeltaMovement(level.random.nextDouble() * 0.02, 0.05 + level.random.nextDouble() * 0.02, level.random.nextDouble() * 0.02);
            level.addFreshEntity((Entity)itemEntity);
            stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
            level.setBlock(pos, (BlockState)ModRegistry.CARVED_PUMPKIN.get().withPropertiesOf(state).setValue((Property)ModCarvedPumpkinBlock.FACING, (Comparable)player.getDirection().getOpposite()), 11);
            if (player instanceof ServerPlayer) {
                ModCarvedPumpkinBlockTile te;
                BlockEntity blockEntity;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.ITEM_USED_ON_BLOCK.trigger(serverPlayer, pos, stack);
                player.awardStat(Stats.ITEM_USED.get((Object)stack.getItem()));
                level.gameEvent((Entity)player, (Holder)GameEvent.SHEAR, pos);
                Utils.awardAdvancement((ServerPlayer)serverPlayer, (ResourceLocation)HauntedHarvest.res("husbandry/carve_custom_pumpkin"));
                if (!player.isSecondaryUseActive() && (blockEntity = level.getBlockEntity(pos)) instanceof ModCarvedPumpkinBlockTile && (te = (ModCarvedPumpkinBlockTile)blockEntity).getCarveMode().canOpenGui()) {
                    te.tryOpeningEditGui(serverPlayer, pos, stack, player.getDirection().getOpposite());
                }
            }
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.PASS;
    }

    public static void onClientEntityLoad(Entity entity, Level level) {
        if (!entity.level().isClientSide) {
            return;
        }
        if (entity instanceof ICustomPumpkinHolder) {
            ICustomPumpkinHolder q = (ICustomPumpkinHolder)entity;
            NetworkHelper.sendToServer((CustomPacketPayload)new SyncSnowGolemPumpkinPacket(entity, q));
        }
    }
}

