/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class AskCandy
extends Behavior<Villager> {
    private int lookTime;
    private boolean gotCandy = false;
    private LivingEntity currentVillager = null;

    public AskCandy(int minDuration, int maxDuration) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.INTERACTION_TARGET, (Object)MemoryStatus.VALUE_PRESENT), minDuration, maxDuration);
    }

    public boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        LivingEntity target = this.isTargetValid(pLevel, pOwner);
        return target != null && pOwner.distanceToSqr((Entity)target) <= 12.5;
    }

    @Nullable
    public LivingEntity isTargetValid(ServerLevel level, Villager owner) {
        Brain brain = owner.getBrain();
        LivingEntity livingentity = brain.getMemory(MemoryModuleType.INTERACTION_TARGET).orElse(null);
        if (livingentity != null && (livingentity.getType() == EntityType.VILLAGER || livingentity.getType() == EntityType.WITCH) && livingentity.isAlive() && owner.isBaby()) {
            return livingentity;
        }
        return null;
    }

    public boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        if (this.gotCandy || this.lookTime <= 0) {
            return false;
        }
        LivingEntity target = this.isTargetValid(pLevel, pEntity);
        return target != null && pEntity.distanceToSqr((Entity)target) <= 20.0;
    }

    public void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        LivingEntity target;
        super.start(pLevel, (LivingEntity)pEntity, pGameTime);
        this.currentVillager = target = this.lookAtTarget(pEntity);
        this.keepVillageAwake(target);
        target.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.BUNDLE));
        BehaviorUtils.lockGazeAndWalkToEachOther((LivingEntity)pEntity, (LivingEntity)target, (float)0.5f, (int)2);
        this.lookTime = 200;
        this.gotCandy = false;
    }

    public void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        LivingEntity target = this.lookAtTarget(pOwner);
        --this.lookTime;
        this.keepVillageAwake(target);
        if (!pOwner.getMainHandItem().is(Items.BUNDLE)) {
            this.gotCandy = true;
        }
    }

    private void keepVillageAwake(LivingEntity target) {
        if (target instanceof Villager) {
            Villager v = (Villager)target;
            target.getBrain().setMemory(MemoryModuleType.LAST_WOKEN, (Object)(target.level().getGameTime() - 1L));
            if (target.isSleeping()) {
                target.stopSleeping();
                target.getBrain().eraseMemory(MemoryModuleType.NEAREST_BED);
                target.level().broadcastEntityEvent((Entity)target, (byte)26);
                target.getBrain().setActiveActivityIfPossible(Activity.REST);
            }
        }
    }

    public void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
        if (!this.gotCandy) {
            Brain brain = pEntity.getBrain();
            if (this.currentVillager instanceof Villager && this.currentVillager.isAlive() && !this.currentVillager.isBaby()) {
                pLevel.broadcastEntityEvent((Entity)pEntity, (byte)13);
                if (pLevel.random.nextInt(10) < 7) {
                    brain.setMemory(MemoryModuleType.ATTACK_TARGET, (Object)this.currentVillager);
                    if (pEntity instanceof IHalloweenVillager) {
                        IHalloweenVillager c = (IHalloweenVillager)pEntity;
                        c.hauntedharvest$setEntityOnCooldown((Entity)this.currentVillager);
                    }
                }
            }
        }
        pEntity.getBrain().eraseMemory(MemoryModuleType.LOOK_TARGET);
        pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
    }

    public static void clearHeldItem(Villager self) {
        self.setItemSlot(EquipmentSlot.MAINHAND, ItemStack.EMPTY);
        self.setDropChance(EquipmentSlot.MAINHAND, 0.085f);
    }

    public static void displayAsHeldItem(Villager self, ItemStack stack) {
        self.setItemSlot(EquipmentSlot.MAINHAND, stack);
        self.setDropChance(EquipmentSlot.MAINHAND, 0.0f);
    }

    private LivingEntity lookAtTarget(Villager self) {
        Brain brain = self.getBrain();
        LivingEntity livingentity = (LivingEntity)brain.getMemory(MemoryModuleType.INTERACTION_TARGET).get();
        brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)livingentity, true));
        return livingentity;
    }
}

