/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.ai.AskCandy;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;

public class CarvePumpkin
extends Behavior<Villager> {
    private final float speedModifier;
    private int ticksSinceReached = 0;
    private int cooldown = 200;

    public CarvePumpkin(float speed) {
        super((Map)ImmutableMap.of(ModRegistry.NEAREST_PUMPKIN.get(), (Object)MemoryStatus.VALUE_PRESENT), 150, 250);
        this.speedModifier = speed;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        if (!HauntedHarvest.isHalloweenSeason((Level)pLevel)) {
            return false;
        }
        if (this.cooldown-- > 0) {
            return false;
        }
        if (!pOwner.isBaby()) {
            return false;
        }
        if (!PlatHelper.isMobGriefingOn((Level)pLevel, (Entity)pOwner)) {
            this.cooldown = 1200;
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        this.cooldown = 20 * (30 + pLevel.random.nextInt(30)) + pLevel.random.nextInt(20);
        this.ticksSinceReached = 0;
        BlockPos targetPos = ((GlobalPos)pEntity.getBrain().getMemory(ModRegistry.NEAREST_PUMPKIN.get()).get()).pos();
        pEntity.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pEntity.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetPos, this.speedModifier, 2));
        AskCandy.displayAsHeldItem(pEntity, new ItemStack((ItemLike)Items.SHEARS));
    }

    protected void stop(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        super.stop(pLevel, (LivingEntity)pEntity, pGameTime);
        AskCandy.clearHeldItem(pEntity);
    }

    protected boolean canStillUse(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        return pEntity.getBrain().hasMemoryValue(ModRegistry.NEAREST_PUMPKIN.get()) && CarvePumpkin.isValidPumpkin(pLevel, pEntity);
    }

    protected void tick(ServerLevel pLevel, Villager pOwner, long pGameTime) {
        BlockPos targetPos = ((GlobalPos)pOwner.getBrain().getMemory(ModRegistry.NEAREST_PUMPKIN.get()).get()).pos();
        pOwner.getBrain().eraseMemory(MemoryModuleType.INTERACTION_TARGET);
        pOwner.getBrain().setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget(targetPos, this.speedModifier, 1));
        pOwner.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, (Object)new BlockPosTracker(targetPos));
        if (targetPos.closerToCenterThan((Position)pOwner.position(), 2.3)) {
            ++this.ticksSinceReached;
            if (this.ticksSinceReached > 40) {
                pLevel.playSound(null, targetPos, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.0f);
                CustomCarvingsManager.placeRandomPumpkin(targetPos, (LevelAccessor)pLevel, pOwner.getDirection().getOpposite(), true, 0.1f, 0.0f, 3);
                pOwner.getBrain().eraseMemory(ModRegistry.NEAREST_PUMPKIN.get());
                pOwner.getBrain().setMemory(ModRegistry.PUMPKIN_POS.get(), (Object)GlobalPos.of((ResourceKey)pLevel.dimension(), (BlockPos)targetPos));
            }
        }
    }

    public static boolean isValidPumpkin(ServerLevel serverLevel, Villager villager) {
        return serverLevel.getBlockState(((GlobalPos)villager.getBrain().getMemory(ModRegistry.NEAREST_PUMPKIN.get()).get()).pos()).is(Blocks.PUMPKIN);
    }
}

