/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.HalloweenVillagerAI;
import net.mehvahdjukaar.hauntedharvest.ai.IHalloweenVillager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;

public class FindAdultThatHasCandy
extends Behavior<LivingEntity> {
    private final float speedModifier;
    private final int interactionRangeSqr;
    private final MemoryModuleType<LivingEntity> memory = MemoryModuleType.INTERACTION_TARGET;

    public FindAdultThatHasCandy(int range, float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.NEAREST_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT));
        this.speedModifier = speed;
        this.interactionRangeSqr = range * range;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, LivingEntity pOwner) {
        if (HalloweenVillagerAI.isTrickOrTreater(pOwner)) {
            return false;
        }
        List list = (List)pOwner.getBrain().getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).get();
        return list.stream().anyMatch(t -> this.isTargetValid(pOwner, (LivingEntity)t));
    }

    private boolean isTargetValid(LivingEntity self, LivingEntity target) {
        if (target.getType() == EntityType.VILLAGER && !target.isBaby() || target.getType() == EntityType.WITCH) {
            IHalloweenVillager e;
            return self instanceof IHalloweenVillager && !(e = (IHalloweenVillager)self).hauntedharvest$isEntityOnCooldown((Entity)target);
        }
        return false;
    }

    protected void start(ServerLevel pLevel, LivingEntity pEntity, long pGameTime) {
        Brain brain = pEntity.getBrain();
        brain.getMemory(MemoryModuleType.NEAREST_LIVING_ENTITIES).flatMap(t -> t.stream().filter(villager -> villager.distanceToSqr((Entity)pEntity) <= (double)this.interactionRangeSqr).filter(v -> this.isTargetValid(pEntity, (LivingEntity)v)).findFirst()).ifPresent(foundTarget -> {
            brain.setMemory(this.memory, foundTarget);
            brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)foundTarget, true));
            brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)new WalkTarget((PositionTracker)new EntityTracker((Entity)foundTarget, false), this.speedModifier, 2));
        });
    }
}

