/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.ai;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.ai.ThrowEggs;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.Villager;

public class GoToAttackTargetIfFurtherThan
extends Behavior<Villager> {
    private final float speedModifier;
    private final float range;

    public GoToAttackTargetIfFurtherThan(float speedModifier, float range) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_PRESENT, (Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.REGISTERED));
        this.speedModifier = speedModifier;
        this.range = range;
    }

    protected boolean checkExtraStartConditions(ServerLevel pLevel, Villager pOwner) {
        LivingEntity livingentity = pOwner.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).orElse(null);
        if (livingentity == null || !livingentity.isAlive()) {
            ThrowEggs.clearAnger(pOwner);
            return false;
        }
        return true;
    }

    protected void start(ServerLevel pLevel, Villager pEntity, long pGameTime) {
        LivingEntity livingentity = (LivingEntity)pEntity.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
        if (BehaviorUtils.canSee((LivingEntity)pEntity, (LivingEntity)livingentity) && !this.isOutOfRange((LivingEntity)pEntity, livingentity, this.range - 2.0f)) {
            this.clearWalkTarget((LivingEntity)pEntity);
        } else {
            this.setWalkAndLookTarget((LivingEntity)pEntity, livingentity);
        }
    }

    private boolean isOutOfRange(LivingEntity entity, LivingEntity other, float range) {
        return entity.distanceToSqr(other.getX(), other.getY(), other.getZ()) > (double)(range * range);
    }

    private void setWalkAndLookTarget(LivingEntity p_24038_, LivingEntity p_24039_) {
        Brain brain = p_24038_.getBrain();
        brain.setMemory(MemoryModuleType.LOOK_TARGET, (Object)new EntityTracker((Entity)p_24039_, true));
        WalkTarget walktarget = new WalkTarget((PositionTracker)new EntityTracker((Entity)p_24039_, false), this.speedModifier, 5);
        brain.setMemory(MemoryModuleType.WALK_TARGET, (Object)walktarget);
    }

    private void clearWalkTarget(LivingEntity p_24036_) {
        p_24036_.getBrain().eraseMemory(MemoryModuleType.WALK_TARGET);
    }
}

