/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import net.mehvahdjukaar.hauntedharvest.HHPlatformStuff;
import net.mehvahdjukaar.hauntedharvest.blocks.CornBaseBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CornMiddleBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CornTopBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IBeeGrowable;
import net.mehvahdjukaar.moonlight.api.platform.ForgeHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractCornBlock
extends CropBlock
implements IBeeGrowable {
    protected AbstractCornBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getAgeProperty()});
    }

    public boolean isRandomlyTicking(BlockState state) {
        return !this.isMaxAge(state);
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        float f;
        if (!PlatHelper.isAreaLoaded((LevelReader)level, (BlockPos)pos, (int)1)) {
            return;
        }
        if (level.getRawBrightness(pos, 0) >= 9 && (double)level.random.nextFloat() < 0.6 && this.isValidBonemealTarget((LevelReader)level, pos, state) && ForgeHelper.fireOnCropsGrowPre((ServerLevel)level, (BlockPos)pos, (BlockState)state, (random.nextInt((int)(30.0f / (f = HHPlatformStuff.getGrowthSpeed(state, level, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            this.growCropBy((Level)level, pos, state, 1);
            ForgeHelper.fireOnCropsGrowPost((ServerLevel)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public void growCropBy(Level level, BlockPos pos, BlockState state, int increment) {
        int maxAge;
        if (increment <= 0) {
            return;
        }
        int newAge = this.getAge(state) + increment;
        if (newAge > (maxAge = this.getMaxAge())) {
            BlockPos above = pos.above();
            BlockState aboveState = level.getBlockState(above);
            Block block = aboveState.getBlock();
            if (block instanceof AbstractCornBlock) {
                AbstractCornBlock cm = (AbstractCornBlock)block;
                cm.growCropBy(level, above, aboveState, increment);
            }
        } else {
            Block top = this.getTopBlock();
            if (newAge == maxAge && top != null) {
                level.setBlock(pos.above(), top.defaultBlockState(), 2);
            }
            level.setBlock(pos, this.getStateForAge(newAge), 2);
        }
    }

    public void growCrops(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, this.getBonemealAgeIncrease(level));
    }

    public boolean getPollinated(Level level, BlockPos pos, BlockState state) {
        this.growCropBy(level, pos, state, 1);
        return true;
    }

    protected ItemLike getBaseSeedId() {
        return (ItemLike)ModRegistry.KERNELS.get();
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        int maxAge;
        int age = this.getAge(state);
        if (age + 1 < (maxAge = this.getMaxAge())) {
            return true;
        }
        BlockPos above = pos.above();
        BlockState aboveState = level.getBlockState(above);
        if (age == maxAge) {
            AbstractCornBlock cb;
            Block block = aboveState.getBlock();
            return block instanceof AbstractCornBlock && (cb = (AbstractCornBlock)block).isValidBonemealTarget(level, above, aboveState);
        }
        return this.getTopBlock() == null || aboveState.canBeReplaced();
    }

    protected int getBonemealAgeIncrease(Level level) {
        return super.getBonemealAgeIncrease(level) / 3;
    }

    @Nullable
    protected abstract Block getTopBlock();

    public abstract int getHeight();

    public boolean isPlantFullyGrown(BlockState state, BlockPos pos, Level level) {
        Block block;
        while ((block = state.getBlock()) instanceof AbstractCornBlock) {
            AbstractCornBlock cb = (AbstractCornBlock)block;
            if (!cb.isMaxAge(state)) {
                return false;
            }
            if (cb.getTopBlock() == null) {
                return true;
            }
            pos = pos.above();
            state = level.getBlockState(pos);
        }
        return false;
    }

    public static boolean spawn(BlockPos pos, LevelAccessor level, int age) {
        if (level.getBlockState(pos).isAir()) {
            boolean top = false;
            if (age > 2) {
                if (!level.getBlockState(pos.above()).isAir()) {
                    return false;
                }
                BlockPos above1 = pos.above();
                if (age > 4) {
                    BlockPos above = pos.above(2);
                    if (!level.getBlockState(above).isAir()) {
                        return false;
                    }
                    top = true;
                    level.setBlock(above, (BlockState)ModRegistry.CORN_TOP.get().defaultBlockState().setValue((Property)CornTopBlock.AGE, (Comparable)Integer.valueOf(Math.min(age - 5, 1))), 2);
                }
                level.setBlock(above1, (BlockState)ModRegistry.CORN_MIDDLE.get().defaultBlockState().setValue((Property)CornMiddleBlock.AGE, (Comparable)Integer.valueOf(Math.min(age - 3, 2))), 2);
            }
            level.setBlock(pos, (BlockState)ModRegistry.CORN_BASE.get().defaultBlockState().setValue((Property)CornBaseBlock.AGE, (Comparable)Integer.valueOf(Math.min(age, 3))), 2);
            if (top && level.getBlockState(pos).isAir()) {
                boolean bl = true;
            }
            return true;
        }
        return false;
    }
}

