/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import net.mehvahdjukaar.hauntedharvest.blocks.AbstractCornBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.CornBaseBlock;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CornMiddleBlock
extends AbstractCornBlock {
    public static final int MAX_AGE = 2;
    public static final IntegerProperty AGE = BlockStateProperties.AGE_2;
    private static final VoxelShape[] SHAPE_BY_AGE = new VoxelShape[]{CornMiddleBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.0, (double)15.0), CornMiddleBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)11.0, (double)15.0), CornMiddleBlock.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)};

    public CornMiddleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected Block getTopBlock() {
        return ModRegistry.CORN_TOP.get();
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        CornBaseBlock base;
        Block top;
        if (this.getAge(state) == this.getMaxAge() && (top = this.getTopBlock()) != null && !level.getBlockState(pos.above()).is(top)) {
            return false;
        }
        BlockState below = level.getBlockState(pos.below());
        Block block = below.getBlock();
        if (!(block instanceof CornBaseBlock) || !(base = (CornBaseBlock)block).isMaxAge(below)) {
            return false;
        }
        return super.canSurvive(state, level, pos);
    }

    public IntegerProperty getAgeProperty() {
        return AGE;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE_BY_AGE[(Integer)state.getValue((Property)this.getAgeProperty())];
    }

    public int getMaxAge() {
        return 2;
    }

    protected boolean mayPlaceOn(BlockState state, BlockGetter level, BlockPos pos) {
        return state.is(ModRegistry.CORN_BASE.get());
    }

    @Override
    public int getHeight() {
        return 1;
    }
}

