/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import java.util.function.Predicate;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.entity.ICustomPumpkinHolder;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public class ModCarvedPumpkinBlock
extends CarvedPumpkinBlock
implements EntityBlock {
    private final PumpkinType type;
    private static final Predicate<BlockState> PUMPKINS_PREDICATE = blockState -> blockState != null && blockState.getBlock() instanceof ModCarvedPumpkinBlock;
    private static final BlockPattern SNOW_GOLEM_FULL = BlockPatternBuilder.start().aisle(new String[]{"^", "#", "#"}).where('^', BlockInWorld.hasState(PUMPKINS_PREDICATE)).where('#', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)Blocks.SNOW_BLOCK))).build();

    public ModCarvedPumpkinBlock(BlockBehaviour.Properties properties, PumpkinType type) {
        super(properties);
        this.type = type;
    }

    public PumpkinType getType(BlockState state) {
        return this.type;
    }

    public static Vector2i getHitSubPixel(BlockHitResult hit) {
        Vec3 pos = hit.getLocation();
        Vec3 v = pos.yRot((float)((double)hit.getDirection().toYRot() * Math.PI / 180.0));
        double fx = v.x % 1.0 * 16.0;
        if (fx < 0.0) {
            fx += 16.0;
        }
        int x = Mth.clamp((int)((int)fx), (int)-15, (int)15);
        int y = 15 - (int)Mth.clamp((double)Math.abs(v.y % 1.0 * 16.0), (double)0.0, (double)15.0);
        if (pos.y < 0.0) {
            y = 15 - y;
        }
        return new Vector2i(x, y);
    }

    public static boolean isCarverItem(ItemStack stack) {
        return stack.is(ModTags.CARVERS) || stack.getItem() instanceof SwordItem;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ModCarvedPumpkinBlockTile te;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ModCarvedPumpkinBlockTile && !(te = (ModCarvedPumpkinBlockTile)blockEntity).isWaxed()) {
            ItemInteractionResult waxingRes = te.tryWaxingWithItem(level, pos, player, stack);
            if (waxingRes.consumesAction()) {
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)level.getBlockState(pos)));
                te.setChanged();
            }
            if (waxingRes != ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION) {
                return waxingRes;
            }
            CarveMode mode = te.getCarveMode();
            if (mode != CarveMode.NONE) {
                if (hit.getDirection() == state.getValue((Property)FACING) && mode.canManualDraw() && ModCarvedPumpkinBlock.isCarverItem(stack)) {
                    int y;
                    int x;
                    Vector2i v = ModCarvedPumpkinBlock.getHitSubPixel(hit);
                    te.setPixel(x, y, !te.getPixel(x = v.x(), y = v.y()));
                    te.setChanged();
                    return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
                }
                if (mode.canOpenGui() && player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    te.tryOpeningEditGui(serverPlayer, pos, stack, hit.getDirection());
                }
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pPos, BlockState pState) {
        return new ModCarvedPumpkinBlockTile(pPos, pState);
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
            ModCarvedPumpkinBlockTile te = (ModCarvedPumpkinBlockTile)blockEntity;
            return Utils.saveTileToItem((BlockEntity)te);
        }
        return super.getCloneItemStack(level, pos, state);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.is(state.getBlock())) {
            this.trySpawnGolemWithCustomPumpkin(level, pos);
        }
    }

    protected void trySpawnGolemWithCustomPumpkin(Level level, BlockPos pos) {
        block9: {
            BlockPattern.BlockPatternMatch blockPatternMatch;
            block8: {
                blockPatternMatch = SNOW_GOLEM_FULL.find((LevelReader)level, pos);
                if (blockPatternMatch == null) break block8;
                SnowGolem snowGolem = (SnowGolem)EntityType.SNOW_GOLEM.create(level);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (blockEntity instanceof ModCarvedPumpkinBlockTile) {
                    ModCarvedPumpkinBlockTile tile = (ModCarvedPumpkinBlockTile)blockEntity;
                    if (snowGolem instanceof ICustomPumpkinHolder) {
                        ICustomPumpkinHolder customPumpkinHolder = (ICustomPumpkinHolder)snowGolem;
                        ItemStack stack = Utils.saveTileToItem((BlockEntity)tile);
                        customPumpkinHolder.hauntedharvest$setCustomPumpkin(stack);
                    }
                }
                for (int i = 0; i < SNOW_GOLEM_FULL.getHeight(); ++i) {
                    BlockInWorld blockInWorld = blockPatternMatch.getBlock(0, i, 0);
                    level.setBlock(blockInWorld.getPos(), Blocks.AIR.defaultBlockState(), 2);
                    level.levelEvent(2001, blockInWorld.getPos(), Block.getId((BlockState)blockInWorld.getState()));
                }
                BlockPos blockPos = blockPatternMatch.getBlock(0, 2, 0).getPos();
                ModCarvedPumpkinBlock.spawnToLocation(level, blockPos, (AbstractGolem)snowGolem);
                for (int j = 0; j < SNOW_GOLEM_FULL.getHeight(); ++j) {
                    BlockInWorld blockInWorld2 = blockPatternMatch.getBlock(0, j, 0);
                    level.blockUpdated(blockInWorld2.getPos(), Blocks.AIR);
                }
                break block9;
            }
            blockPatternMatch = this.getOrCreateIronGolemFull().find((LevelReader)level, pos);
            if (blockPatternMatch == null) break block9;
            for (int i = 0; i < this.getOrCreateIronGolemFull().getWidth(); ++i) {
                for (int k = 0; k < this.getOrCreateIronGolemFull().getHeight(); ++k) {
                    BlockInWorld blockInWorld3 = blockPatternMatch.getBlock(i, k, 0);
                    level.setBlock(blockInWorld3.getPos(), Blocks.AIR.defaultBlockState(), 2);
                    level.levelEvent(2001, blockInWorld3.getPos(), Block.getId((BlockState)blockInWorld3.getState()));
                }
            }
            BlockPos blockPos2 = blockPatternMatch.getBlock(1, 2, 0).getPos();
            IronGolem ironGolem = (IronGolem)EntityType.IRON_GOLEM.create(level);
            ironGolem.setPlayerCreated(true);
            ModCarvedPumpkinBlock.spawnToLocation(level, blockPos2, (AbstractGolem)ironGolem);
            for (int j = 0; j < this.getOrCreateIronGolemFull().getWidth(); ++j) {
                for (int l = 0; l < this.getOrCreateIronGolemFull().getHeight(); ++l) {
                    BlockInWorld blockInWorld4 = blockPatternMatch.getBlock(j, l, 0);
                    level.blockUpdated(blockInWorld4.getPos(), Blocks.AIR);
                }
            }
        }
    }

    private static void spawnToLocation(Level level, BlockPos blockPos2, AbstractGolem ironGolem) {
        ironGolem.moveTo((double)blockPos2.getX() + 0.5, (double)blockPos2.getY() + 0.05, (double)blockPos2.getZ() + 0.5, 0.0f, 0.0f);
        level.addFreshEntity((Entity)ironGolem);
        for (ServerPlayer serverPlayer : level.getEntitiesOfClass(ServerPlayer.class, ironGolem.getBoundingBox().inflate(5.0))) {
            CriteriaTriggers.SUMMONED_ENTITY.trigger(serverPlayer, (Entity)ironGolem);
        }
    }

    public static enum CarveMode {
        NONE,
        BOTH,
        GUI,
        MANUAL;


        public boolean canOpenGui() {
            return this != MANUAL && this != NONE;
        }

        public boolean canManualDraw() {
            return this != GUI && this != NONE;
        }
    }
}

