/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.blocks;

import com.mojang.serialization.DynamicOps;
import java.util.UUID;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.screens.CarvingScreen;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.block.IOnePlayerInteractable;
import net.mehvahdjukaar.moonlight.api.block.IWaxable;
import net.mehvahdjukaar.moonlight.api.client.IScreenProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ExtraModelData;
import net.mehvahdjukaar.moonlight.api.client.model.IExtraModelDataProvider;
import net.mehvahdjukaar.moonlight.api.client.model.ModelDataKey;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class ModCarvedPumpkinBlockTile
extends BlockEntity
implements IScreenProvider,
IOnePlayerInteractable,
IExtraModelDataProvider,
IWaxable {
    public static final ModelDataKey<PumpkinCarvingData> CARVING = new ModelDataKey(PumpkinCarvingData.class);
    @Nullable
    private UUID playerWhoMayEdit = null;
    private PumpkinCarvingData data = PumpkinCarvingData.empty(this.getPumpkinType());

    public ModCarvedPumpkinBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.MOD_CARVED_PUMPKIN_TILE.get(), pos, state);
    }

    public boolean tryOpeningEditGui(ServerPlayer player, BlockPos pos, ItemStack stack, Direction hitFace) {
        if (this.isWaxed()) {
            return false;
        }
        return super.tryOpeningEditGui(player, pos, stack, hitFace);
    }

    public UUID getPlayerWhoMayEdit() {
        return this.playerWhoMayEdit;
    }

    public void setPlayerWhoMayEdit(UUID playerWhoMayEdit) {
        this.playerWhoMayEdit = playerWhoMayEdit;
    }

    public PumpkinType getPumpkinType() {
        BlockState state = this.getBlockState();
        return ((ModCarvedPumpkinBlock)state.getBlock()).getType(state);
    }

    public void addExtraModelData(ExtraModelData.Builder builder) {
        super.addExtraModelData(builder);
        builder.with(CARVING, (Object)this.data);
    }

    public void setChanged() {
        if (this.level == null || this.level.isClientSide) {
            return;
        }
        this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
        super.setChanged();
    }

    public void afterDataPacket(ExtraModelData oldData) {
        this.refreshType();
        super.afterDataPacket(oldData);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        PumpkinType oldType = this.getPumpkinType();
        this.data = (PumpkinCarvingData)PumpkinCarvingData.CODEC.parse((DynamicOps)ops, (Object)tag).getOrThrow();
        if (oldType != this.data.getType()) {
            this.data = this.data.withType(oldType);
        }
        if (tag.contains("Pixels")) {
            this.data = this.data.withPixels(PumpkinCarvingData.unpack(tag.getLongArray("Pixels")));
        }
        this.requestModelReload();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        RegistryOps ops = registries.createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        tag.merge((CompoundTag)PumpkinCarvingData.CODEC.encodeStart((DynamicOps)ops, (Object)this.data).getOrThrow());
    }

    protected void collectImplicitComponents(DataComponentMap.Builder components) {
        super.collectImplicitComponents(components);
        if (!this.isEmpty()) {
            components.set(ModRegistry.PUMPKIN_CARVING.get(), (Object)this.data);
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput componentInput) {
        super.applyImplicitComponents(componentInput);
        PumpkinCarvingData data = (PumpkinCarvingData)componentInput.get(ModRegistry.PUMPKIN_CARVING.get());
        if (data != null) {
            this.data = data;
        } else {
            this.clearPixels();
        }
    }

    public void removeComponentsFromTag(CompoundTag tag) {
        super.removeComponentsFromTag(tag);
        tag.remove("values");
        tag.remove("type");
        tag.remove("waxed");
    }

    public void clear() {
        this.data = this.data.makeCleared();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void clearPixels() {
        this.data = this.data.makeCleared();
    }

    public void setPixel(int x, int y, boolean b) {
        this.data = this.data.withPixel(x, y, b);
    }

    public boolean getPixel(int xx, int yy) {
        return this.data.getPixel(xx, yy);
    }

    public void setPixels(boolean[][] pixels) {
        this.data = this.data.withPixels(pixels);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public Direction getDirection() {
        return (Direction)this.getBlockState().getValue((Property)ModCarvedPumpkinBlock.FACING);
    }

    public void openScreen(Level level, Player player, Direction direction) {
        CarvingScreen.open(this, direction);
    }

    public void setWaxed(boolean b) {
        this.data = this.data.withWaxed(b);
    }

    public boolean isWaxed() {
        return this.data.isWaxed();
    }

    public ModCarvedPumpkinBlock.CarveMode getCarveMode() {
        if (this.getPumpkinType().isJackOLantern()) {
            return CommonConfigs.JACK_O_LANTERN_CARVE_MODE.get();
        }
        return CommonConfigs.PUMPKIN_CARVE_MODE.get();
    }

    public void refreshType() {
        this.data = this.data.withType(this.getPumpkinType());
    }

    public boolean tryAcceptingClientPixels(ServerPlayer player, boolean[][] pixels, Direction dir) {
        if (!this.isEditingPlayer(this.worldPosition, (Player)player) || this.isWaxed() || !CommonConfigs.PUMPKIN_CARVE_MODE.get().canOpenGui()) {
            HauntedHarvest.LOGGER.warn("Player {} just tried to change non-editable carved pumpkin", (Object)player.getName().getString());
        }
        if (this.isEmpty()) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)ModCarvedPumpkinBlock.FACING, (Comparable)dir));
        }
        if (!this.data.hasSamePixels(pixels)) {
            this.level.playSound(null, this.worldPosition, SoundEvents.PUMPKIN_CARVE, SoundSource.BLOCKS, 1.0f, 1.2f);
            this.setPlayerWhoMayEdit(null);
            this.setPixels(pixels);
        }
        return true;
    }
}

