/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.systems.RenderSystem;
import net.mehvahdjukaar.hauntedharvest.client.CarvingManager;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class BlurOverlay {
    public static void renderPaperBag(ItemStack stack, Player player, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        BlurOverlay.renderScreenOverlay(stack, player, guiGraphics, deltaTracker, ClientRegistry.PAPER_BAG_OVERLAY);
    }

    public static void renderPumpkin(ItemStack stack, Player player, GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        PumpkinCarvingData data = (PumpkinCarvingData)stack.get(ModRegistry.PUMPKIN_CARVING.get());
        if (data == null) {
            return;
        }
        CarvingManager.CarvingVisuals carving = CarvingManager.getInstance(data);
        ResourceLocation textureLocation = carving.getPumpkinBlur();
        if (textureLocation == null) {
            return;
        }
        BlurOverlay.renderScreenOverlay(stack, player, guiGraphics, deltaTracker, textureLocation);
    }

    private static void renderScreenOverlay(ItemStack stack, Player player, GuiGraphics graphics, DeltaTracker deltaTracker, ResourceLocation textureLocation) {
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.enableBlend();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        graphics.blit(textureLocation, 0, 0, -90, 0.0f, 0.0f, graphics.guiWidth(), graphics.guiHeight(), graphics.guiWidth(), graphics.guiHeight());
        RenderSystem.disableBlend();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
    }
}

