/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlockTile;
import net.mehvahdjukaar.hauntedharvest.reg.ClientRegistry;
import net.mehvahdjukaar.moonlight.api.client.util.LOD;
import net.mehvahdjukaar.moonlight.api.client.util.RotHlpr;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2i;

public class CarvedPumpkinTileRenderer
implements BlockEntityRenderer<ModCarvedPumpkinBlockTile> {
    private static final int WIDTH = 6;
    private final Minecraft mc = Minecraft.getInstance();
    private final Camera camera;

    public CarvedPumpkinTileRenderer(BlockEntityRendererProvider.Context context) {
        this.camera = this.mc.gameRenderer.getMainCamera();
    }

    public int getViewDistance() {
        return 8;
    }

    public boolean shouldRender(ModCarvedPumpkinBlockTile blockEntity, Vec3 cameraPos) {
        return super.shouldRender((BlockEntity)blockEntity, cameraPos);
    }

    public void render(ModCarvedPumpkinBlockTile tile, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        LocalPlayer player;
        BlockHitResult blockHit;
        BlockPos pos;
        if (!tile.getCarveMode().canManualDraw()) {
            return;
        }
        Direction dir = tile.getDirection();
        float yaw = -dir.toYRot();
        Vec3 cameraPos = this.camera.getPosition();
        if (LOD.isOutOfFocus((Vec3)cameraPos, (BlockPos)(pos = tile.getBlockPos()), (float)yaw, (float)0.0f, (Direction)dir, (float)0.375f)) {
            return;
        }
        HitResult hit = this.mc.hitResult;
        if (hit != null && hit.getType() == HitResult.Type.BLOCK && (blockHit = (BlockHitResult)hit).getBlockPos().equals((Object)pos) && tile.getDirection() == blockHit.getDirection() && (player = this.mc.player) != null && tile.getLevel() != null && ModCarvedPumpkinBlock.isCarverItem(player.getMainHandItem())) {
            matrixStackIn.pushPose();
            matrixStackIn.translate(0.5, 0.5, 0.5);
            matrixStackIn.mulPose(RotHlpr.rot((Direction)dir));
            matrixStackIn.mulPose(RotHlpr.XN90);
            matrixStackIn.translate(-0.5, -0.5, 0.5);
            int frontLight = LevelRenderer.getLightColor((BlockAndTintGetter)tile.getLevel(), (BlockPos)pos.relative(dir));
            int lu = frontLight & 0xFFFF;
            int lv = frontLight >> 16 & 0xFFFF;
            Vector2i pair = ModCarvedPumpkinBlock.getHitSubPixel(blockHit);
            float p = 0.0625f;
            float x = (float)pair.x() * p;
            float y = (float)pair.y() * p;
            VertexConsumer builder2 = ClientRegistry.CARVING_OUTLINE.buffer(bufferIn, RenderType::entityCutout);
            matrixStackIn.pushPose();
            matrixStackIn.translate((double)x, (double)(1.0f - y - p), 0.001);
            CarvedPumpkinTileRenderer.addQuadSide(builder2, matrixStackIn, 0.0f, 0.0f, 0.0f, p, p, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 0.0f, 1.0f);
            matrixStackIn.popPose();
            matrixStackIn.popPose();
        }
    }

    @Deprecated(forRemoval=true)
    public static void addQuadSide(VertexConsumer builder, PoseStack matrixStackIn, float x0, float y0, float z0, float x1, float y1, float z1, float u0, float v0, float u1, float v1, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        CarvedPumpkinTileRenderer.addVert(builder, matrixStackIn, x0, y0, z0, u0, v1, r, g, b, a, lu, lv, nx, ny, nz);
        CarvedPumpkinTileRenderer.addVert(builder, matrixStackIn, x1, y0, z1, u1, v1, r, g, b, a, lu, lv, nx, ny, nz);
        CarvedPumpkinTileRenderer.addVert(builder, matrixStackIn, x1, y1, z1, u1, v0, r, g, b, a, lu, lv, nx, ny, nz);
        CarvedPumpkinTileRenderer.addVert(builder, matrixStackIn, x0, y1, z0, u0, v0, r, g, b, a, lu, lv, nx, ny, nz);
    }

    @Deprecated(forRemoval=true)
    public static void addVert(VertexConsumer builder, PoseStack matrixStackIn, float x, float y, float z, float u, float v, float r, float g, float b, float a, int lu, int lv, float nx, float ny, float nz) {
        builder.addVertex(matrixStackIn.last().pose(), x, y, z);
        builder.setColor(r, g, b, a);
        builder.setUv(u, v);
        builder.setOverlay(OverlayTexture.NO_OVERLAY);
        builder.setUv2(lu, lv);
        builder.setNormal(matrixStackIn.last(), nx, ny, nz);
    }
}

