/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.PumpkinTextureGenerator;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.RenderedTexturesManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CarvingManager
implements PreparableReloadListener {
    public static final CarvingManager INSTANCE = new CarvingManager();
    private static final LoadingCache<PumpkinCarvingData, CarvingVisuals> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).removalListener(i -> {
        CarvingVisuals value = (CarvingVisuals)i.getValue();
        if (value != null) {
            RenderSystem.recordRenderCall(value::close);
        }
    }).build((CacheLoader)new CacheLoader<PumpkinCarvingData, CarvingVisuals>(){

        public CarvingVisuals load(PumpkinCarvingData key) {
            return null;
        }
    });
    private static CarvingVisuals currentCarvingBlur = null;
    private static FrameBufferBackedDynamicTexture pumpkinBlur = null;

    public CompletableFuture<Void> reload(PreparableReloadListener.PreparationBarrier preparationBarrier, ResourceManager resourceManager, ProfilerFiller profilerFiller, ProfilerFiller profilerFiller2, Executor executor, Executor executor2) {
        Objects.requireNonNull(preparationBarrier);
        return ((CompletableFuture)CompletableFuture.completedFuture(null).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)preparationBarrier).wait(arg_0))).thenAcceptAsync(preparation -> CarvingManager.onTextureReload(), executor2);
    }

    public static CarvingVisuals getInstance(@NotNull PumpkinCarvingData key) {
        CarvingVisuals textureInstance = (CarvingVisuals)TEXTURE_CACHE.getIfPresent((Object)key);
        if (textureInstance == null) {
            textureInstance = new CarvingVisuals(key.getPixelsUnsafe(), key.getType());
            TEXTURE_CACHE.put((Object)key, (Object)textureInstance);
        }
        return textureInstance;
    }

    @Nullable
    public static ResourceLocation getCachedBlurTexture(CarvingVisuals carving) {
        if (pumpkinBlur == null) {
            RenderedTexturesManager.requestTexture((ResourceLocation)HauntedHarvest.res("pumpkinblur"), (int)512, t -> {
                PumpkinTextureGenerator.drawBlur(t, carving);
                pumpkinBlur = t;
            }, (boolean)false);
            return null;
        }
        if (carving != currentCarvingBlur) {
            PumpkinTextureGenerator.drawBlur(pumpkinBlur, carving);
        }
        currentCarvingBlur = carving;
        return pumpkinBlur.getTextureLocation();
    }

    public static void onTextureReload() {
        if (pumpkinBlur != null) {
            pumpkinBlur.close();
            pumpkinBlur = null;
        }
    }

    public static class CarvingVisuals
    implements AutoCloseable {
        public static final int WIDTH = 16;
        private final Map<Direction, List<BakedQuad>> quadsCache = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        private final boolean[][] pixels;
        private final PumpkinType type;
        @Nullable
        private DynamicTexture texture;
        @Nullable
        private RenderType renderType;
        @Nullable
        private ResourceLocation textureLocation;

        private CarvingVisuals(boolean[][] pixels, PumpkinType type) {
            this.pixels = pixels;
            this.type = type;
        }

        public boolean[][] getPixels() {
            return this.pixels;
        }

        public PumpkinType getType() {
            return this.type;
        }

        private void initializeTexture() {
            this.texture = new DynamicTexture(16, 16, false);
            PumpkinTextureGenerator.drawCarving(this.texture, this);
            this.textureLocation = Minecraft.getInstance().getTextureManager().register("carving/", this.texture);
            this.renderType = RenderType.entitySolid((ResourceLocation)this.textureLocation);
        }

        public List<BakedQuad> getOrCreateModel(Direction dir, BiFunction<CarvingVisuals, Direction, List<BakedQuad>> modelFactory) {
            return this.quadsCache.computeIfAbsent(dir, d -> (List)modelFactory.apply(this, (Direction)d));
        }

        public ResourceLocation getTextureLocation() {
            if (this.textureLocation == null) {
                this.initializeTexture();
            }
            return this.textureLocation;
        }

        @Nullable
        public ResourceLocation getPumpkinBlur() {
            return CarvingManager.getCachedBlurTexture(this);
        }

        public RenderType getRenderType() {
            if (this.renderType == null) {
                this.initializeTexture();
            }
            return this.renderType;
        }

        @Override
        public void close() {
            if (this.texture != null) {
                this.texture.close();
            }
            if (this.textureLocation != null) {
                Minecraft.getInstance().getTextureManager().release(this.textureLocation);
            }
        }
    }
}

