/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.entity.SplatteredEggEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;

public class SplatteredEggRenderer
extends EntityRenderer<SplatteredEggEntity> {
    public static final ResourceLocation TEXTURE = HauntedHarvest.res("textures/entity/egg/splattered_egg.png");
    public static final ResourceLocation TEXTURE_2 = HauntedHarvest.res("textures/entity/egg/splattered_egg_2.png");

    public SplatteredEggRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(SplatteredEggEntity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        pMatrixStack.pushPose();
        pMatrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - pEntityYaw));
        pMatrixStack.scale(0.0625f, 0.0625f, 0.0625f);
        VertexConsumer vertexconsumer = pBuffer.getBuffer(RenderType.entityCutoutNoCull((ResourceLocation)this.getTextureLocation(pEntity)));
        this.renderPainting(pMatrixStack, vertexconsumer, pEntity);
        pMatrixStack.popPose();
        super.render((Entity)pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
    }

    public ResourceLocation getTextureLocation(SplatteredEggEntity pEntity) {
        return pEntity.altTexture ? TEXTURE_2 : TEXTURE;
    }

    private void renderPainting(PoseStack poseStack, VertexConsumer consumer, SplatteredEggEntity entity) {
        PoseStack.Pose last = poseStack.last();
        float p = 8.0f;
        float n = -8.0f;
        int blockX = entity.getBlockX();
        int blockY = entity.getBlockY();
        int blockZ = entity.getBlockZ();
        Direction dir = entity.getDirection();
        switch (dir.getAxis()) {
            case X: {
                blockZ = Mth.floor((double)entity.getZ());
                break;
            }
            case Z: {
                blockX = Mth.floor((double)entity.getX());
                break;
            }
            case Y: {
                blockY = Mth.floor((double)entity.getY());
            }
        }
        int l1 = LevelRenderer.getLightColor((BlockAndTintGetter)entity.level(), (BlockPos)new BlockPos(blockX, blockY, blockZ));
        if (dir == Direction.DOWN) {
            this.vertex(last, consumer, p, -0.5f, 0.0f, 1.0f, n, 0, -1, 0, l1);
            this.vertex(last, consumer, n, -0.5f, 1.0f, 1.0f, n, 0, -1, 0, l1);
            this.vertex(last, consumer, n, -0.5f, 1.0f, 0.0f, p, 0, -1, 0, l1);
            this.vertex(last, consumer, p, -0.5f, 0.0f, 0.0f, p, 0, -1, 0, l1);
        } else if (dir == Direction.UP) {
            this.vertex(last, consumer, n, 0.5f, 0.0f, 1.0f, p, 0, 1, 0, l1);
            this.vertex(last, consumer, n, 0.5f, 1.0f, 1.0f, n, 0, 1, 0, l1);
            this.vertex(last, consumer, p, 0.5f, 1.0f, 0.0f, n, 0, 1, 0, l1);
            this.vertex(last, consumer, p, 0.5f, 0.0f, 0.0f, p, 0, 1, 0, l1);
        } else {
            this.vertex(last, consumer, p, n, 0.0f, 1.0f, -0.5f, 0, 0, 1, l1);
            this.vertex(last, consumer, n, n, 1.0f, 1.0f, -0.5f, 0, 0, 1, l1);
            this.vertex(last, consumer, n, p, 1.0f, 0.0f, -0.5f, 0, 0, 1, l1);
            this.vertex(last, consumer, p, p, 0.0f, 0.0f, -0.5f, 0, 0, 1, l1);
        }
    }

    private void vertex(PoseStack.Pose pose, VertexConsumer vertexConsumer, float x, float y, float u, float v, float z, int nx, int ny, int nz, int light) {
        vertexConsumer.addVertex(pose, x, y, z).setColor(-1).setUv(u, v).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pose, (float)nx, (float)ny, (float)nz);
    }
}

