/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.entity;

import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.entity.projectile.ThrowableProjectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SplatteredEggEntity
extends HangingEntity {
    public boolean altTexture = false;

    public SplatteredEggEntity(EntityType<? extends SplatteredEggEntity> type, Level level) {
        super(type, level);
    }

    public SplatteredEggEntity(Level level, BlockPos pos, Direction direction) {
        this(ModRegistry.SPLATTERED_EGG_ENTITY.get(), level, pos, direction);
    }

    public SplatteredEggEntity(EntityType<? extends SplatteredEggEntity> type, Level level, BlockPos pos, Direction direction) {
        super(type, level, pos);
        this.setDirection(direction);
    }

    public static void spawn(HitResult pResult, ThrowableProjectile egg) {
        HitResult.Type type = pResult.getType();
        if (type == HitResult.Type.BLOCK) {
            BlockHitResult hit = (BlockHitResult)pResult;
            BlockPos blockpos = hit.getBlockPos();
            Direction direction = hit.getDirection();
            BlockPos relative = blockpos.relative(direction);
            Level level = egg.level();
            SplatteredEggEntity hangingentity = new SplatteredEggEntity(level, relative, direction);
            if (hangingentity.survives() && !level.isClientSide) {
                hangingentity.playPlacementSound();
                level.gameEvent(egg.getOwner(), (Holder)GameEvent.ENTITY_PLACE, blockpos);
                level.addFreshEntity((Entity)hangingentity);
            }
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity serverEntity) {
        return new ClientboundAddEntityPacket((Entity)this, this.direction.get3DDataValue(), this.getPos());
    }

    public void recreateFromPacket(ClientboundAddEntityPacket p_149626_) {
        super.recreateFromPacket(p_149626_);
        this.setDirection(Direction.from3DDataValue((int)p_149626_.getData()));
    }

    protected void setDirection(Direction pFacingDirection) {
        this.direction = pFacingDirection;
        if (pFacingDirection.getAxis().isHorizontal()) {
            this.setXRot(0.0f);
            this.setYRot(this.direction.get2DDataValue() * 90);
        } else {
            this.setXRot(-90 * pFacingDirection.getAxisDirection().getStep());
            this.setYRot(0.0f);
        }
        this.xRotO = this.getXRot();
        this.yRotO = this.getYRot();
        this.recalculateBoundingBox();
        RandomSource ran = RandomSource.create((long)this.pos.asLong());
        this.altTexture = ran.nextInt(this.direction.getAxis() == Direction.Axis.Y ? 6 : 2) == 0;
    }

    protected AABB calculateBoundingBox(BlockPos blockPos, Direction direction) {
        float size = 0.875f;
        Vec3 vec3 = Vec3.atCenterOf((Vec3i)blockPos).relative(direction, -0.46875);
        Direction.Axis axis = direction.getAxis();
        double d = axis == Direction.Axis.X ? 0.0625 : (double)size;
        double e = axis == Direction.Axis.Y ? 0.0625 : (double)size;
        double g = axis == Direction.Axis.Z ? 0.0625 : (double)size;
        return AABB.ofSize((Vec3)vec3, (double)d, (double)e, (double)g);
    }

    public boolean survives() {
        Level level = this.level();
        if (!level.noCollision((Entity)this)) {
            return false;
        }
        BlockState blockstate = level.getBlockState(this.pos.relative(this.direction.getOpposite()));
        return (blockstate.isSolid() || this.direction.getAxis().isHorizontal() && DiodeBlock.isDiode((BlockState)blockstate)) && level.getEntities((Entity)this, this.getBoundingBox(), HANGING_ENTITY).isEmpty();
    }

    @Nullable
    public ItemStack getPickedResult(HitResult target) {
        return Items.EGG.getDefaultInstance();
    }

    public void dropItem(@Nullable Entity pBrokenEntity) {
    }

    public void playPlacementSound() {
        this.playSound(SoundEvents.HONEY_BLOCK_PLACE, 1.0f, 1.2f);
    }

    public boolean shouldRenderAtSqrDistance(double pDistance) {
        double d0 = 16.0;
        return pDistance < (d0 = d0 * 64.0 * SplatteredEggEntity.getViewScale()) * d0;
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        super.addAdditionalSaveData(pCompound);
        pCompound.putByte("Facing", (byte)this.direction.get3DDataValue());
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        super.readAdditionalSaveData(pCompound);
        this.setDirection(Direction.from3DDataValue((int)pCompound.getByte("Facing")));
    }

    public ItemStack getPickResult() {
        return new ItemStack((ItemLike)Items.EGG);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide && this.tickCount > 600) {
            this.discard();
        }
    }

    public boolean isInvulnerableTo(DamageSource pSource) {
        if (pSource.is(DamageTypeTags.IS_PROJECTILE)) {
            return true;
        }
        return super.isInvulnerableTo(pSource);
    }
}

