/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.integration;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.reg.ModTags;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.ItemLike;

public class SpecialRecipeDisplays {
    public static List<RecipeHolder<? extends CraftingRecipe>> createPumpkinDuplicate() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "hauntedharvest.jei.carved_pumpkin";
        ItemStack output = new ItemStack((ItemLike)ModRegistry.CARVED_PUMPKIN.get());
        long[] pixels = new long[]{0x1F10010000000000L, 3458817360039263256L, 4330272718253469696L, 0x1001F10L};
        output.set(ModRegistry.PUMPKIN_CARVING.get(), (Object)PumpkinCarvingData.of(PumpkinCarvingData.unpack(pixels), PumpkinType.NORMAL, false));
        Ingredient emptyBoard = Ingredient.of(ModTags.CARVABLE_PUMPKINS);
        Ingredient fullBoard = Ingredient.of((ItemStack[])new ItemStack[]{output});
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{fullBoard, emptyBoard});
        ResourceLocation id = HauntedHarvest.res("jei_carved_pumpkin");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, output, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    public static List<RecipeHolder<? extends CraftingRecipe>> createJackOLantern() {
        ArrayList<RecipeHolder<? extends CraftingRecipe>> recipes = new ArrayList<RecipeHolder<? extends CraftingRecipe>>();
        String group = "hauntedharvest.jei.jack_o_lantern";
        ItemStack output = new ItemStack((ItemLike)ModRegistry.JACK_O_LANTERN.get());
        long[] pixels = new long[]{4499109221882658816L, 2017679119407127804L, 4537409593239146464L, 26388795002096L};
        output.set(ModRegistry.PUMPKIN_CARVING.get(), (Object)PumpkinCarvingData.of(PumpkinCarvingData.unpack(pixels), PumpkinType.NORMAL, false));
        NonNullList inputs = NonNullList.of((Object)Ingredient.EMPTY, (Object[])new Ingredient[]{Ingredient.of((ItemLike[])new ItemLike[]{Items.TORCH}), Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModRegistry.CARVED_PUMPKIN.get()})});
        ResourceLocation id = HauntedHarvest.res("jei_jack_o_lantern");
        ShapelessRecipe recipe = new ShapelessRecipe(group, CraftingBookCategory.BUILDING, output, inputs);
        recipes.add(new RecipeHolder(id, (Recipe)recipe));
        return recipes;
    }

    public static void registerCraftingRecipes(Consumer<List<RecipeHolder<? extends CraftingRecipe>>> registry) {
        for (RecipeBookCategories c : (List)RecipeBookCategories.AGGREGATE_CATEGORIES.get(RecipeBookCategories.CRAFTING_SEARCH)) {
            SpecialRecipeDisplays.registerRecipes(c, registry);
        }
    }

    public static void registerRecipes(RecipeBookCategories category, Consumer<List<RecipeHolder<? extends CraftingRecipe>>> registry) {
        if (category == RecipeBookCategories.CRAFTING_BUILDING_BLOCKS && CommonConfigs.CARVED_PUMPKINS_ENABLED.get().booleanValue()) {
            registry.accept(SpecialRecipeDisplays.createJackOLantern());
            registry.accept(SpecialRecipeDisplays.createPumpkinDuplicate());
        }
    }
}

