/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.items;

import java.util.Optional;
import net.mehvahdjukaar.hauntedharvest.blocks.ModCarvedPumpkinBlock;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class ModCarvedPumpkinItem
extends BlockItem {
    private final PumpkinType type;

    public ModCarvedPumpkinItem(ModCarvedPumpkinBlock block, Item.Properties properties) {
        super((Block)block, properties);
        this.type = block.getType(block.defaultBlockState());
    }

    public PumpkinType getType() {
        return this.type;
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack pStack) {
        PumpkinCarvingData data = (PumpkinCarvingData)pStack.get(ModRegistry.PUMPKIN_CARVING.get());
        return Optional.ofNullable(data);
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return this.type.isJackOLantern() ? null : EquipmentSlot.HEAD;
    }

    public boolean isEnderMask(ItemStack stack, Player player, EnderMan enderMan) {
        return true;
    }

    public boolean canEquip(ItemStack stack, EquipmentSlot armorType, LivingEntity entity) {
        return this.getEquipmentSlot(stack) == armorType;
    }
}

