/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.reg;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.mehvahdjukaar.hauntedharvest.HauntedHarvest;
import net.mehvahdjukaar.hauntedharvest.blocks.PumpkinType;
import net.mehvahdjukaar.hauntedharvest.client.CarvedPumpkinItemRenderer;
import net.mehvahdjukaar.hauntedharvest.client.CarvedPumpkinTileRenderer;
import net.mehvahdjukaar.hauntedharvest.client.HalloweenMaskLayer;
import net.mehvahdjukaar.hauntedharvest.client.PaperBagRenderExtension;
import net.mehvahdjukaar.hauntedharvest.client.SplatteredEggRenderer;
import net.mehvahdjukaar.hauntedharvest.client.model.CarvedPumpkinBakedModel;
import net.mehvahdjukaar.hauntedharvest.client.screens.CarvingTooltipComponent;
import net.mehvahdjukaar.hauntedharvest.items.components.PumpkinCarvingData;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.moonlight.api.client.CoreShaderContainer;
import net.mehvahdjukaar.moonlight.api.client.ItemRenderExtension;
import net.mehvahdjukaar.moonlight.api.client.model.CustomModelLoader;
import net.mehvahdjukaar.moonlight.api.client.model.NestedModelLoader;
import net.mehvahdjukaar.moonlight.api.client.util.RenderUtil;
import net.mehvahdjukaar.moonlight.api.platform.ClientHelper;
import net.minecraft.Util;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.HeartParticle;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ClientRegistry {
    public static final ResourceLocation LOCATION_BLOCKS = ResourceLocation.parse((String)"textures/atlas/blocks.png");
    public static final ModelLayerLocation VILLAGER_MASK = ClientRegistry.loc("villager_mask");
    public static final Material PUMPKIN_HIGHLIGHT = new Material(LOCATION_BLOCKS, HauntedHarvest.res("block/pumpkin_highlight"));
    public static final Material PUMPKIN = new Material(LOCATION_BLOCKS, ResourceLocation.parse((String)"block/pumpkin_side"));
    public static final Material CARVING_OUTLINE = new Material(LOCATION_BLOCKS, HauntedHarvest.res("block/carving_grid"));
    public static final ResourceLocation PAPER_BAG_OVERLAY = HauntedHarvest.res("textures/misc/paper_bag_overlay.png");
    public static final ResourceLocation OUTLINE_SPRITE = HauntedHarvest.res("outline");
    public static final CoreShaderContainer BLUR_SHARED = new CoreShaderContainer(GameRenderer::getPositionTexColorShader);
    private static final Map<PumpkinType, Material[]> PUMPKIN_MATERIALS = (Map)Util.make(() -> {
        Object2ObjectOpenHashMap l = new Object2ObjectOpenHashMap();
        for (PumpkinType t : PumpkinType.getTypes()) {
            Material shade = new Material(LOCATION_BLOCKS, HauntedHarvest.res("block/" + t.getTextureKey() + "_shade"));
            Material background = new Material(LOCATION_BLOCKS, HauntedHarvest.res("block/" + t.getTextureKey() + "_background"));
            l.put((Object)t, (Object)new Material[]{PUMPKIN, shade, background, PUMPKIN_HIGHLIGHT});
        }
        return l;
    });
    private static final Map<PumpkinType, ModelResourceLocation> PUMPKIN_FRAMES = (Map)Util.make(() -> {
        Object2ObjectOpenHashMap l = new Object2ObjectOpenHashMap();
        for (PumpkinType t : PumpkinType.getTypes()) {
            l.put((Object)t, (Object)RenderUtil.getStandaloneModelLocation((ResourceLocation)HauntedHarvest.res("block/" + t.getTextureKey() + "_frame")));
        }
        return l;
    });

    public static Material getMaterial(PumpkinType type, int ordinal) {
        Material[] m = PUMPKIN_MATERIALS.get(type);
        if (m != null) {
            return m[ordinal];
        }
        throw new NullPointerException();
    }

    private static ModelLayerLocation loc(String name) {
        return new ModelLayerLocation(HauntedHarvest.res(name), name);
    }

    public static ModelResourceLocation getPumpkinFrame(PumpkinType type) {
        return PUMPKIN_FRAMES.getOrDefault(type, PUMPKIN_FRAMES.get(PumpkinType.JACK));
    }

    public static void init() {
        ClientHelper.addEntityRenderersRegistration(ClientRegistry::registerEntityRenderers);
        ClientHelper.addParticleRegistration(ClientRegistry::registerParticles);
        ClientHelper.addModelLoaderRegistration(ClientRegistry::registerModelLoaders);
        ClientHelper.addBlockEntityRenderersRegistration(ClientRegistry::registerBlockEntityRenderers);
        ClientHelper.addTooltipComponentRegistration(ClientRegistry::registerTooltipComponent);
        ClientHelper.addSpecialModelRegistration(ClientRegistry::registerSpecialModels);
        ClientHelper.addModelLayerRegistration(ClientRegistry::registerModelLayers);
        ClientHelper.addShaderRegistration(ClientRegistry::registerShaders);
        ClientHelper.addItemRenderersRegistration(ClientRegistry::registerItemRenderers);
        ClientHelper.addClientSetup(ClientRegistry::setup);
    }

    public static void setup() {
        ClientHelper.registerRenderType((Block)ModRegistry.CORN_BASE.get(), (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)ModRegistry.CORN_MIDDLE.get(), (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)ModRegistry.CORN_TOP.get(), (RenderType)RenderType.cutout());
        PumpkinType.getTypes().forEach(t -> ClientHelper.registerRenderType((Block)t.getPumpkin(), (RenderType)RenderType.cutout()));
        ClientHelper.registerRenderType((Block)Blocks.JACK_O_LANTERN, (RenderType)RenderType.cutout());
        ClientHelper.registerRenderType((Block)ModRegistry.CORN_POT.get(), (RenderType)RenderType.cutout());
    }

    private static void registerItemRenderers(ClientHelper.ItemRendererEvent event) {
        CarvedPumpkinItemRenderer renderer = new CarvedPumpkinItemRenderer();
        event.register((ItemLike)ModRegistry.CARVED_PUMPKIN.get(), (ItemRenderExtension)renderer);
        event.register((ItemLike)ModRegistry.JACK_O_LANTERN.get(), (ItemRenderExtension)renderer);
        event.register((ItemLike)ModRegistry.PAPER_BAG.get(), (ItemRenderExtension)new PaperBagRenderExtension());
    }

    private static void registerModelLayers(ClientHelper.ModelLayerEvent event) {
        event.register(VILLAGER_MASK, HalloweenMaskLayer::createMesh);
    }

    private static void registerParticles(ClientHelper.ParticleEvent event) {
        event.register((ParticleType)ModRegistry.SPOOKED_PARTICLE.get(), HeartParticle.AngryVillagerProvider::new);
    }

    private static void registerEntityRenderers(ClientHelper.EntityRendererEvent event) {
        event.register(ModRegistry.SPLATTERED_EGG_ENTITY.get(), SplatteredEggRenderer::new);
    }

    private static void registerTooltipComponent(ClientHelper.TooltipComponentEvent event) {
        event.register(PumpkinCarvingData.class, CarvingTooltipComponent::new);
    }

    private static void registerBlockEntityRenderers(ClientHelper.BlockEntityRendererEvent event) {
        event.register(ModRegistry.MOD_CARVED_PUMPKIN_TILE.get(), CarvedPumpkinTileRenderer::new);
    }

    private static void registerModelLoaders(ClientHelper.ModelLoaderEvent event) {
        event.register(HauntedHarvest.res("carved_pumpkin"), (CustomModelLoader)new NestedModelLoader("model", CarvedPumpkinBakedModel::new));
    }

    private static void registerSpecialModels(ClientHelper.SpecialModelEvent event) {
        for (ModelResourceLocation v : PUMPKIN_FRAMES.values()) {
            event.register(v);
        }
    }

    private static void registerShaders(ClientHelper.ShaderEvent event) {
        event.register(HauntedHarvest.res("blur"), DefaultVertexFormat.POSITION_TEX, arg_0 -> ((CoreShaderContainer)BLUR_SHARED).assign(arg_0));
    }

    public static ShaderInstance getBlur() {
        return BLUR_SHARED.get();
    }
}

