/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.DimensionPadding;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.pools.alias.PoolAliasLookup;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;

public final class AbandonedFarmStructure
extends Structure {
    public static final MapCodec<AbandonedFarmStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)AbandonedFarmStructure.settingsCodec((RecordCodecBuilder.Instance)instance), (App)StructureTemplatePool.CODEC.fieldOf("start_pool").forGetter(j -> j.startPool), (App)ResourceLocation.CODEC.optionalFieldOf("start_jigsaw_name").forGetter(j -> j.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(j -> j.maxDepth), (App)Heightmap.Types.CODEC.optionalFieldOf("project_start_to_heightmap").forGetter(j -> j.projectStartToHeightmap), (App)Codec.INT.fieldOf("min_y").forGetter(structure -> structure.minY), (App)Codec.INT.fieldOf("max_y").forGetter(structure -> structure.maxY)).apply((Applicative)instance, AbandonedFarmStructure::new)).flatXmap(AbandonedFarmStructure.verifyRange(), AbandonedFarmStructure.verifyRange());
    private final Holder<StructureTemplatePool> startPool;
    private final Optional<ResourceLocation> startJigsawName;
    private final int maxDepth;
    private final Optional<Heightmap.Types> projectStartToHeightmap;
    private final int maxY;
    private final int minY;

    private static Function<AbandonedFarmStructure, DataResult<AbandonedFarmStructure>> verifyRange() {
        return jigsawStructure -> jigsawStructure.maxY < jigsawStructure.minY ? DataResult.error(() -> "MaxY cannot be < MinY") : DataResult.success((Object)jigsawStructure);
    }

    public AbandonedFarmStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int depth, Optional<Heightmap.Types> projectStartToHeightmap, int minY, int maxY) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.maxDepth = depth;
        this.minY = minY;
        this.maxY = maxY;
        this.projectStartToHeightmap = projectStartToHeightmap;
    }

    public Optional<Structure.GenerationStub> findGenerationPoint(Structure.GenerationContext context) {
        ChunkPos chunkPos = context.chunkPos();
        BlockPos blockPos = new BlockPos(chunkPos.getMinBlockX(), 0, chunkPos.getMinBlockZ());
        LevelHeightAccessor heightLimitView = context.heightAccessor();
        RandomState randomState = context.randomState();
        ChunkGenerator generator = context.chunkGenerator();
        int y = generator.getFirstOccupiedHeight(blockPos.getX(), blockPos.getZ(), Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, randomState);
        if (y > this.maxY || y < this.minY) {
            return Optional.empty();
        }
        return JigsawPlacement.addPieces((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.maxDepth, (BlockPos)blockPos, (boolean)false, this.projectStartToHeightmap, (int)20, (PoolAliasLookup)PoolAliasLookup.EMPTY, (DimensionPadding)JigsawStructure.DEFAULT_DIMENSION_PADDING, (LiquidSettings)JigsawStructure.DEFAULT_LIQUID_SETTINGS);
    }

    public StructureType<?> type() {
        return ModRegistry.FARM.get();
    }

    public static class Type
    implements StructureType<AbandonedFarmStructure> {
        public MapCodec<AbandonedFarmStructure> codec() {
            return CODEC;
        }
    }
}

