/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.mehvahdjukaar.hauntedharvest.CustomCarvingsManager;
import net.mehvahdjukaar.hauntedharvest.blocks.AbstractCornBlock;
import net.mehvahdjukaar.hauntedharvest.configs.CommonConfigs;
import net.mehvahdjukaar.hauntedharvest.integration.CompatHandler;
import net.mehvahdjukaar.hauntedharvest.integration.FDCompat;
import net.mehvahdjukaar.hauntedharvest.integration.SuppCompat;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AttachedStemBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;

public class FarmFieldFeature
extends Feature<Config> {
    public FarmFieldFeature(Codec<Config> codec) {
        super(codec);
    }

    public boolean place(FeaturePlaceContext<Config> context) {
        Config config = (Config)context.config();
        RandomSource random = context.random();
        BlockPos blockPos = context.origin();
        WorldGenLevel level = context.level();
        CropType crop = config.crop();
        if (!crop.isEnabled()) {
            return false;
        }
        boolean scarecrow = config.scarecrow();
        if (scarecrow) {
            this.placeScarecrow(blockPos, level, random);
        }
        int i = 0;
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        int j = config.xzSpread() + 1;
        int k = config.ySpread() + 1;
        block5: for (int l = 0; l < config.tries(); ++l) {
            p.setWithOffset((Vec3i)blockPos, random.nextInt(j) - random.nextInt(j), random.nextInt(k) - random.nextInt(k), random.nextInt(j) - random.nextInt(j));
            if (!level.getBlockState(p.below()).is(BlockTags.DIRT)) continue;
            switch (crop.ordinal()) {
                case 1: {
                    if (!this.placeCorn(p, level, random)) continue block5;
                    break;
                }
                case 2: {
                    if (!SuppCompat.placeFlax(p, level, random)) continue block5;
                    break;
                }
                case 3: {
                    if (!this.placeTomatoes(p, level, random)) continue block5;
                    break;
                }
                default: {
                    if (!this.placePumpkin(p, level, random)) continue block5;
                }
            }
            level.setBlock(p.below(), Blocks.FARMLAND.defaultBlockState(), 2);
            ++i;
        }
        return i > 0;
    }

    private boolean placeTomatoes(BlockPos.MutableBlockPos p, WorldGenLevel level, RandomSource random) {
        if (level.getBlockState((BlockPos)p).isAir()) {
            level.setBlock((BlockPos)p, FDCompat.getTomato(random), 2);
            return true;
        }
        return false;
    }

    private void placeScarecrow(BlockPos blockPos, WorldGenLevel level, RandomSource random) {
        level.setBlock(blockPos, Blocks.SPRUCE_FENCE.defaultBlockState(), 2);
        BlockPos above = blockPos.above();
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        level.setBlock(above, Blocks.HAY_BLOCK.defaultBlockState(), 3);
        BlockPos left = above.relative(dir);
        level.setBlock(left, Block.updateFromNeighbourShapes((BlockState)Blocks.SPRUCE_FENCE.defaultBlockState(), (LevelAccessor)level, (BlockPos)left), 2);
        BlockPos right = above.relative(dir.getOpposite());
        level.setBlock(right, Block.updateFromNeighbourShapes((BlockState)Blocks.SPRUCE_FENCE.defaultBlockState(), (LevelAccessor)level, (BlockPos)right), 2);
        CustomCarvingsManager.placeRandomPumpkin(above.above(), (LevelAccessor)level, dir.getClockWise(), true, 0.2f, 0.15f, 2);
    }

    private boolean placeCorn(BlockPos.MutableBlockPos pos, WorldGenLevel level, RandomSource random) {
        int age = random.nextInt(7);
        return AbstractCornBlock.spawn((BlockPos)pos, (LevelAccessor)level, age);
    }

    private boolean placePumpkin(BlockPos.MutableBlockPos pos, WorldGenLevel level, RandomSource random) {
        Direction dir = Direction.Plane.HORIZONTAL.getRandomDirection(random);
        BlockPos pumpkinPos = pos.relative(dir);
        if (level.getBlockState((BlockPos)pos).isAir()) {
            if (random.nextBoolean()) {
                if (level.getBlockState(pumpkinPos).isAir() && level.getBlockState(pumpkinPos.below()).is(BlockTags.DIRT)) {
                    level.setBlock(pumpkinPos, Blocks.PUMPKIN.defaultBlockState(), 2);
                    level.setBlock((BlockPos)pos, (BlockState)Blocks.ATTACHED_PUMPKIN_STEM.defaultBlockState().setValue((Property)AttachedStemBlock.FACING, (Comparable)dir), 2);
                    return true;
                }
            } else {
                level.setBlock((BlockPos)pos, (BlockState)Blocks.PUMPKIN_STEM.defaultBlockState().setValue((Property)StemBlock.AGE, (Comparable)Integer.valueOf(random.nextInt(8))), 2);
                return true;
            }
        }
        return false;
    }

    public record Config(int tries, int xzSpread, int ySpread, CropType crop, boolean scarecrow) implements FeatureConfiguration
    {
        public static final Codec<Config> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("tries").orElse((Object)64).forGetter(Config::tries), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("xz_spread").orElse((Object)7).forGetter(Config::xzSpread), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("y_spread").orElse((Object)3).forGetter(Config::ySpread), (App)StringRepresentable.fromEnum(CropType::values).fieldOf("crop").forGetter(Config::crop), (App)Codec.BOOL.optionalFieldOf("has_scarecrow", (Object)false).forGetter(Config::scarecrow)).apply((Applicative)instance, Config::new));
    }

    public static enum CropType implements StringRepresentable
    {
        PUMPKIN,
        CORN,
        FLAX,
        TOMATOES;


        public boolean isEnabled() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> CommonConfigs.CORN_ENABLED.get();
                case 2 -> {
                    if (CompatHandler.SUPP_INSTALLED && SuppCompat.isFlaxOn()) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> true;
                case 3 -> CompatHandler.FD_INSTALLED;
            };
        }

        public String getSerializedName() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }
}

