/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.hauntedharvest.worldgen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.mehvahdjukaar.hauntedharvest.reg.ModRegistry;
import net.mehvahdjukaar.hauntedharvest.worldgen.FarmFieldFeature;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.FrontAndTop;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElementType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class RandomFeaturePoolElement
extends StructurePoolElement {
    public static final MapCodec<RandomFeaturePoolElement> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)SimpleWeightedRandomList.wrappedCodec((Codec)PlacedFeature.CODEC).fieldOf("features").forGetter(e -> e.features), (App)RandomFeaturePoolElement.projectionCodec()).apply((Applicative)i, RandomFeaturePoolElement::new));
    private final SimpleWeightedRandomList<Holder<PlacedFeature>> features;
    private final CompoundTag defaultJigsawNBT = this.fillDefaultJigsawNBT();

    protected RandomFeaturePoolElement(SimpleWeightedRandomList<Holder<PlacedFeature>> features, StructureTemplatePool.Projection projection) {
        super(projection);
        features = this.removeDisabledHack(features);
        this.features = features;
    }

    private SimpleWeightedRandomList<Holder<PlacedFeature>> removeDisabledHack(SimpleWeightedRandomList<Holder<PlacedFeature>> original) {
        SimpleWeightedRandomList.Builder newList = new SimpleWeightedRandomList.Builder();
        for (WeightedEntry.Wrapper v : original.unwrap()) {
            FarmFieldFeature.Config c;
            FeatureConfiguration featureConfiguration = ((ConfiguredFeature)((PlacedFeature)((Holder)v.data()).value()).feature().value()).config();
            if (featureConfiguration instanceof FarmFieldFeature.Config && !(c = (FarmFieldFeature.Config)featureConfiguration).crop().isEnabled()) continue;
            newList.add((Object)((Holder)v.data()), v.getWeight().asInt());
        }
        return newList.build();
    }

    private CompoundTag fillDefaultJigsawNBT() {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putString("name", "minecraft:bottom");
        compoundTag.putString("final_state", "minecraft:air");
        compoundTag.putString("pool", "minecraft:empty");
        compoundTag.putString("target", "minecraft:empty");
        compoundTag.putString("joint", JigsawBlockEntity.JointType.ROLLABLE.getSerializedName());
        return compoundTag;
    }

    public Vec3i getSize(StructureTemplateManager structureTemplateManager, Rotation rotation) {
        return Vec3i.ZERO;
    }

    public List<StructureTemplate.StructureBlockInfo> getShuffledJigsawBlocks(StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation, RandomSource randomSource) {
        ArrayList list = Lists.newArrayList();
        list.add(new StructureTemplate.StructureBlockInfo(blockPos, (BlockState)Blocks.JIGSAW.defaultBlockState().setValue((Property)JigsawBlock.ORIENTATION, (Comparable)FrontAndTop.fromFrontAndTop((Direction)Direction.DOWN, (Direction)Direction.SOUTH)), this.defaultJigsawNBT));
        return list;
    }

    public BoundingBox getBoundingBox(StructureTemplateManager structureTemplateManager, BlockPos blockPos, Rotation rotation) {
        Vec3i vec3i = this.getSize(structureTemplateManager, rotation);
        return new BoundingBox(blockPos.getX(), blockPos.getY(), blockPos.getZ(), blockPos.getX() + vec3i.getX(), blockPos.getY() + vec3i.getY(), blockPos.getZ() + vec3i.getZ());
    }

    public boolean place(StructureTemplateManager structureTemplateManager, WorldGenLevel level, StructureManager structureManager, ChunkGenerator generator, BlockPos blockPos, BlockPos centerPos, Rotation rotation, BoundingBox boundingBox, RandomSource random, LiquidSettings liquidSettings, boolean bl) {
        return ((PlacedFeature)((Holder)((WeightedEntry.Wrapper)this.features.getRandom(RandomSource.create((long)centerPos.asLong())).get()).data()).value()).place(level, generator, random, blockPos);
    }

    public StructurePoolElementType<?> getType() {
        return ModRegistry.RANDOM_FEATURE_POOL.get();
    }

    public String toString() {
        return "Features[" + String.valueOf(this.features) + "]";
    }
}

