/*
 * Decompiled with CFR 0.152.
 */
package win.dlp8.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.dlp8.config.JsoncParser;

public class TooltipConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tooltips-dlp8");
    private static TooltipConfig instance;
    private Map<String, String> tooltips = new HashMap<String, String>();
    private List<String> loadedResourcePacks = new ArrayList<String>();
    private class_3300 resourceManager;

    private TooltipConfig() {
    }

    public static TooltipConfig getInstance() {
        if (instance == null) {
            instance = new TooltipConfig();
        }
        return instance;
    }

    public void loadFromResourceManager(class_3300 manager) {
        this.resourceManager = manager;
        this.loadConfig();
    }

    public void loadConfig() {
        this.tooltips.clear();
        this.loadedResourcePacks.clear();
        LOGGER.info("[Tooltips DLP8] Starting tooltip loading...");
        this.loadFromResourceManager();
        this.loadFromResourcePackFiles();
        LOGGER.info("[Tooltips DLP8] Successfully loaded {} total tooltips from {} sources", (Object)this.tooltips.size(), (Object)this.loadedResourcePacks.size());
    }

    private void loadFromResourceManager() {
        if (this.resourceManager == null) {
            return;
        }
        try {
            Map resources = this.resourceManager.method_14488("tooltips-dlp8", path -> {
                try {
                    String pathStr = path.method_12832();
                    return pathStr != null && pathStr.endsWith(".jsonc");
                }
                catch (Exception e) {
                    return false;
                }
            });
            for (Map.Entry entry : resources.entrySet()) {
                String fullPath;
                class_2960 identifier = (class_2960)entry.getKey();
                class_3298 resource = (class_3298)entry.getValue();
                if (identifier == null || resource == null || (fullPath = identifier.toString()) == null || fullPath.isEmpty()) continue;
                try {
                    InputStream inputStream = resource.method_14482();
                    try {
                        String content = new String(inputStream.readAllBytes());
                        JsonObject json = JsoncParser.parseJsonc(content);
                        String packName = this.extractResourcePackName(identifier.toString());
                        if (!this.loadedResourcePacks.contains(packName)) {
                            this.loadedResourcePacks.add(packName);
                        }
                        this.loadTooltipsFromJson(json, packName);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("[Tooltips DLP8] Failed to load built-in tooltips from {}: {}", (Object)fullPath, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Tooltips DLP8] Failed to load built-in tooltips: {}", (Object)e.getMessage());
        }
    }

    private void loadFromResourcePackFiles() {
        try {
            String minecraftDir = System.getProperty("user.dir");
            if (minecraftDir.contains("PrismLauncher")) {
                minecraftDir = "C:\\Users\\victo\\AppData\\Roaming\\PrismLauncher\\instances\\SpEx - MC Civ Experiment\\minecraft";
            }
            Path resourcePacksDir = Path.of(minecraftDir, "resourcepacks");
            LOGGER.info("[Tooltips DLP8] Scanning resource packs directory: {}", (Object)resourcePacksDir);
            if (!Files.exists(resourcePacksDir, new LinkOption[0])) {
                LOGGER.warn("[Tooltips DLP8] Resource packs directory not found: {}", (Object)resourcePacksDir);
                return;
            }
            try (Stream<Path> stream = Files.list(resourcePacksDir);){
                stream.forEach(path -> {
                    if (path.toString().endsWith(".zip")) {
                        this.loadFromResourcePackZip((Path)path);
                    } else if (Files.isDirectory(path, new LinkOption[0])) {
                        this.loadFromResourcePackFolder((Path)path);
                    }
                });
            }
        }
        catch (Exception e) {
            LOGGER.error("[Tooltips DLP8] Failed to scan resource pack files", (Throwable)e);
        }
    }

    private void loadFromResourcePackZip(Path zipPath) {
        String packName = zipPath.getFileName().toString();
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".jsonc") || !entryName.startsWith("assets/tooltips-dlp8/") && !entryName.startsWith("assets\\tooltips-dlp8\\")) continue;
                String namespace = this.extractNamespaceFromPath(entryName);
                String fullPath = packName + "/" + entryName;
                try {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    try {
                        String content = new String(inputStream.readAllBytes());
                        JsonObject json = JsoncParser.parseJsonc(content);
                        if (!this.loadedResourcePacks.contains(packName)) {
                            this.loadedResourcePacks.add(packName);
                        }
                        this.loadTooltipsFromJson(json, packName + " (" + namespace + ")");
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error("[Tooltips DLP8] Failed to load tooltips from {}: {}", (Object)fullPath, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Tooltips DLP8] Failed to read resource pack {}: {}", (Object)packName, (Object)e.getMessage());
        }
    }

    private void loadFromResourcePackFolder(Path folderPath) {
        String packName = folderPath.getFileName().toString();
        Path tooltipsDir = folderPath.resolve("assets").resolve("tooltips-dlp8");
        if (Files.exists(tooltipsDir, new LinkOption[0]) && Files.isDirectory(tooltipsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(tooltipsDir);){
                List<Path> jsonFiles = stream.filter(path -> path.toString().endsWith(".jsonc")).toList();
                if (!jsonFiles.isEmpty()) {
                    if (!this.loadedResourcePacks.contains(packName)) {
                        this.loadedResourcePacks.add(packName);
                    }
                    for (Path jsonFile : jsonFiles) {
                        String fileName = jsonFile.getFileName().toString();
                        String fullPath = packName + "/assets/tooltips-dlp8/" + fileName;
                        try {
                            String content = Files.readString(jsonFile);
                            JsonObject json = JsoncParser.parseJsonc(content);
                            this.loadTooltipsFromJson(json, packName + " (tooltips-dlp8)");
                        }
                        catch (Exception e) {
                            LOGGER.error("[Tooltips DLP8] Failed to load tooltips from {}: {}", (Object)fullPath, (Object)e.getMessage());
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("[Tooltips DLP8] Failed to scan folder {}: {}", (Object)packName, (Object)e.getMessage());
            }
        }
    }

    private String extractNamespaceFromPath(String path) {
        String[] parts;
        String normalizedPath = path.replace("\\", "/");
        if (normalizedPath.startsWith("assets/") && normalizedPath.contains("/") && (parts = normalizedPath.split("/")).length >= 2) {
            return parts[1];
        }
        return "unknown";
    }

    private void loadTooltipsFromJson(JsonObject json, String packName) {
        int tooltipsLoaded = 0;
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("//") || !((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
            this.tooltips.put(key, ((JsonElement)entry.getValue()).getAsString());
            ++tooltipsLoaded;
        }
        LOGGER.info("[Tooltips DLP8] Loaded {} tooltips from: {}", (Object)tooltipsLoaded, (Object)packName);
    }

    private String extractResourcePackName(String resourcePath) {
        if (resourcePath.contains(":")) {
            String namespace = resourcePath.split(":")[0];
            if ("tooltips-dlp8".equals(namespace)) {
                return "Built-in";
            }
            return namespace;
        }
        if (resourcePath.contains("/")) {
            String[] parts = resourcePath.split("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                String namespace;
                if (!"assets".equals(parts[i]) || i + 1 >= parts.length || "tooltips-dlp8".equals(namespace = parts[i + 1])) continue;
                return namespace;
            }
        }
        return "External Pack";
    }

    public String getTooltip(String itemId) {
        return this.tooltips.get(itemId);
    }

    public Map<String, String> getAllTooltips() {
        return new HashMap<String, String>(this.tooltips);
    }

    public List<String> getLoadedResourcePacks() {
        return new ArrayList<String>(this.loadedResourcePacks);
    }

    public int getTooltipCount() {
        return this.tooltips.size();
    }

    public void reload() {
        this.loadConfig();
    }
}

