/*
 * Decompiled with CFR 0.152.
 */
package win.dlp8.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.dlp8.config.JsoncParser;

public class TooltipConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tooltips-dlp8");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("tooltips-dlp8.jsonc");
    private static TooltipConfig instance;
    private Map<String, String> tooltips = new HashMap<String, String>();

    private TooltipConfig() {
        this.loadConfig();
    }

    public static TooltipConfig getInstance() {
        if (instance == null) {
            instance = new TooltipConfig();
        }
        return instance;
    }

    public void loadConfig() {
        try {
            if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                String content = Files.readString(CONFIG_PATH);
                JsonObject json = JsoncParser.parseJsonc(content);
                this.tooltips.clear();
                for (Map.Entry entry : json.entrySet()) {
                    this.tooltips.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
                LOGGER.info("Loaded tooltip config with {} entries", (Object)this.tooltips.size());
            } else {
                this.createDefaultConfig();
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to load config", (Throwable)e);
            this.createDefaultConfig();
        }
    }

    public void saveConfig() {
        try {
            JsonObject json = new JsonObject();
            for (Map.Entry<String, String> entry : this.tooltips.entrySet()) {
                json.addProperty(entry.getKey(), entry.getValue());
            }
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((JsonElement)json), new OpenOption[0]);
            LOGGER.info("Saved tooltip config");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    private void createDefaultConfig() {
        this.tooltips.put("minecraft:netherite_upgrade_smithing_template", "#7e8c8dBlacksmith#n#f1c40fBuilder#n#2dc26bFarmer#n#e03e2dGuardsman#n#b96ad9Healer#n#3598dbLibrarian#n#ecf0f1Miner");
        this.saveConfigWithComments();
    }

    private void saveConfigWithComments() {
        try {
            StringBuilder configContent = new StringBuilder();
            configContent.append("{\n");
            configContent.append("  // Tooltips DLP8 Configuration\n");
            configContent.append("  // This file supports comments using // or /* */\n");
            configContent.append("  // \n");
            configContent.append("  // Color codes:\n");
            configContent.append("  //   #RRGGBB - Hex colors (e.g., #ff0000 for red)\n");
            configContent.append("  //   #reset  - Reset to default tooltip color\n");
            configContent.append("  //   #n      - New line\n");
            configContent.append("  //\n");
            configContent.append("  // CivLabs Classes Color Examples:\n");
            configContent.append("  //   #7e8c8d - Blacksmith (Gray)\n");
            configContent.append("  //   #f1c40f - Builder (Yellow)\n");
            configContent.append("  //   #2dc26b - Farmer (Green)\n");
            configContent.append("  //   #e03e2d - Guardsman (Red)\n");
            configContent.append("  //   #b96ad9 - Healer (Purple)\n");
            configContent.append("  //   #3598db - Librarian (Blue)\n");
            configContent.append("  //   #ecf0f1 - Miner (Light Gray)\n");
            configContent.append("  //\n");
            configContent.append("  // Example:\n");
            configContent.append("  //   \"item_id\": \"#color1text#n#color2more text\"\n");
            configContent.append("  //\n");
            for (Map.Entry<String, String> entry : this.tooltips.entrySet()) {
                configContent.append("  \"").append(entry.getKey()).append("\": \"");
                configContent.append(entry.getValue().replace("\"", "\\\""));
                configContent.append("\",\n");
            }
            if (configContent.length() > 2) {
                configContent.setLength(configContent.length() - 2);
                configContent.append("\n");
            }
            configContent.append("}\n");
            Files.writeString(CONFIG_PATH, (CharSequence)configContent.toString(), new OpenOption[0]);
            LOGGER.info("Saved tooltip config with JSON5 syntax");
        }
        catch (IOException e) {
            LOGGER.error("Failed to save config with JSON5 syntax", (Throwable)e);
            this.saveConfig();
        }
    }

    public String getTooltip(String itemId) {
        return this.tooltips.get(itemId);
    }

    public void setTooltip(String itemId, String tooltip) {
        this.tooltips.put(itemId, tooltip);
    }

    public void removeTooltip(String itemId) {
        this.tooltips.remove(itemId);
    }

    public Map<String, String> getAllTooltips() {
        return new HashMap<String, String>(this.tooltips);
    }

    public void reload() {
        this.loadConfig();
    }
}

