/*
 * Decompiled with CFR 0.152.
 */
package win.dlp8.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import win.dlp8.config.JsoncParser;

public class TooltipConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"tooltips-dlp8");
    private static TooltipConfig instance;
    private Map<String, String> tooltips = new HashMap<String, String>();
    private List<String> loadedResourcePacks = new ArrayList<String>();
    private List<String> detectedResourcePacks = new ArrayList<String>();
    private class_3300 resourceManager;

    private TooltipConfig() {
    }

    public static TooltipConfig getInstance() {
        if (instance == null) {
            instance = new TooltipConfig();
        }
        return instance;
    }

    public void loadFromResourceManager(class_3300 manager) {
        this.resourceManager = manager;
        this.loadConfig();
    }

    public void loadConfig() {
        this.tooltips.clear();
        this.loadedResourcePacks.clear();
        this.detectedResourcePacks.clear();
        LOGGER.info("[Tooltips DLP8] Starting tooltip loading...");
        this.loadFromResourceManager();
        this.detectNonActiveResourcePacks();
        LOGGER.info("[Tooltips DLP8] Successfully loaded {} total tooltips from {} active resource packs", (Object)this.tooltips.size(), (Object)this.loadedResourcePacks.size());
        if (!this.detectedResourcePacks.isEmpty()) {
            LOGGER.info("[Tooltips DLP8] Detected {} resource packs with tooltips (not active): {}", (Object)this.detectedResourcePacks.size(), (Object)String.join((CharSequence)", ", this.detectedResourcePacks));
        }
    }

    private void loadFromResourceManager() {
        if (this.resourceManager == null) {
            return;
        }
        try {
            LOGGER.info("[Tooltips DLP8] Loading tooltips from active resource packs...");
            List<String> knownJsoncFiles = this.scanForKnownJsoncFiles();
            LOGGER.info("[Tooltips DLP8] Found {} .jsonc files in filesystem: {}", (Object)knownJsoncFiles.size(), knownJsoncFiles);
            for (String fileName : knownJsoncFiles) {
                String identifierStr = "tooltips-dlp8:" + fileName;
                try {
                    class_2960 identifier = class_2960.method_60654((String)identifierStr);
                    if (this.resourceManager.method_14486(identifier).isPresent()) {
                        LOGGER.info("[Tooltips DLP8] FOUND active resource: {}", (Object)fileName);
                        class_3298 resource = (class_3298)this.resourceManager.method_14486(identifier).get();
                        this.loadTooltipFromResource(identifier, resource);
                        continue;
                    }
                    LOGGER.info("[Tooltips DLP8] NOT FOUND (not active): {}", (Object)fileName);
                }
                catch (Exception e) {
                    LOGGER.info("[Tooltips DLP8] ERROR testing {}: {}", (Object)fileName, (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[Tooltips DLP8] Failed to load tooltips from ResourceManager: {}", (Object)e.getMessage());
        }
    }

    private List<String> scanForKnownJsoncFiles() {
        ArrayList<String> jsoncFiles;
        block9: {
            jsoncFiles = new ArrayList<String>();
            try {
                Path resourcePacksDir;
                String minecraftDir = System.getProperty("user.dir");
                if (minecraftDir.contains("PrismLauncher")) {
                    minecraftDir = "C:\\Users\\victo\\AppData\\Roaming\\PrismLauncher\\instances\\SpEx - MC Civ Experiment\\minecraft";
                }
                if (!Files.exists(resourcePacksDir = Path.of(minecraftDir, "resourcepacks"), new LinkOption[0])) break block9;
                try (Stream<Path> stream = Files.list(resourcePacksDir);){
                    stream.forEach(path -> {
                        if (path.toString().endsWith(".zip")) {
                            this.scanZipForJsoncFiles((Path)path, (List<String>)jsoncFiles);
                        } else if (Files.isDirectory(path, new LinkOption[0])) {
                            this.scanFolderForJsoncFiles((Path)path, (List<String>)jsoncFiles);
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("[Tooltips DLP8] Failed to scan for known .jsonc files", (Throwable)e);
            }
        }
        return jsoncFiles;
    }

    private void scanZipForJsoncFiles(Path zipPath, List<String> jsoncFiles) {
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String fileName;
                ZipEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".jsonc") || !entryName.startsWith("assets/tooltips-dlp8/") && !entryName.startsWith("assets\\tooltips-dlp8\\") || jsoncFiles.contains(fileName = Path.of(entryName, new String[0]).getFileName().toString())) continue;
                jsoncFiles.add(fileName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void scanFolderForJsoncFiles(Path folderPath, List<String> jsoncFiles) {
        Path tooltipsDir = folderPath.resolve("assets").resolve("tooltips-dlp8");
        if (Files.exists(tooltipsDir, new LinkOption[0]) && Files.isDirectory(tooltipsDir, new LinkOption[0])) {
            try (Stream<Path> stream = Files.list(tooltipsDir);){
                stream.filter(path -> path.toString().endsWith(".jsonc")).forEach(path -> {
                    String fileName = path.getFileName().toString();
                    if (!jsoncFiles.contains(fileName)) {
                        jsoncFiles.add(fileName);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void loadTooltipFromResource(class_2960 identifier, class_3298 resource) {
        try (InputStream inputStream = resource.method_14482();){
            String content = new String(inputStream.readAllBytes());
            JsonObject json = JsoncParser.parseJsonc(content);
            String fileName = identifier.method_12832();
            String packName = this.extractResourcePackNameFromFile(fileName);
            if (!this.loadedResourcePacks.contains(packName)) {
                this.loadedResourcePacks.add(packName);
            }
            this.loadTooltipsFromJson(json, packName);
        }
        catch (Exception e) {
            LOGGER.error("[Tooltips DLP8] Failed to load tooltips from {}: {}", (Object)identifier, (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractResourcePackNameFromFile(String fileName) {
        try {
            Path resourcePacksDir;
            String minecraftDir = System.getProperty("user.dir");
            if (minecraftDir.contains("PrismLauncher")) {
                minecraftDir = "C:\\Users\\victo\\AppData\\Roaming\\PrismLauncher\\instances\\SpEx - MC Civ Experiment\\minecraft";
            }
            if (!Files.exists(resourcePacksDir = Path.of(minecraftDir, "resourcepacks"), new LinkOption[0])) return "Active Resource Pack (" + fileName + ")";
            try (Stream<Path> stream = Files.list(resourcePacksDir);){
                Path path;
                block14: {
                    Iterator<Path> iterator = stream.toList().iterator();
                    while (iterator.hasNext()) {
                        path = iterator.next();
                        if (path.toString().endsWith(".zip")) {
                            if (!this.checkZipContainsFile(path, fileName)) continue;
                            String string = path.getFileName().toString();
                            return string;
                        }
                        if (!Files.isDirectory(path, new LinkOption[0]) || !this.checkFolderContainsFile(path, fileName)) {
                            continue;
                        }
                        break block14;
                    }
                    return "Active Resource Pack (" + fileName + ")";
                }
                String string = path.getFileName().toString();
                return string;
            }
        }
        catch (Exception e) {
            LOGGER.debug("[Tooltips DLP8] Failed to extract pack name for {}: {}", (Object)fileName, (Object)e.getMessage());
        }
        return "Active Resource Pack (" + fileName + ")";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkZipContainsFile(Path zipPath, String fileName) {
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            ZipEntry entry;
            String entryName;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while (!(entryName = (entry = entries.nextElement()).getName()).endsWith(fileName) || !entryName.startsWith("assets/tooltips-dlp8/") && !entryName.startsWith("assets\\tooltips-dlp8\\"));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkFolderContainsFile(Path folderPath, String fileName) {
        Path tooltipsDir = folderPath.resolve("assets").resolve("tooltips-dlp8");
        Path targetFile = tooltipsDir.resolve(fileName);
        return Files.exists(targetFile, new LinkOption[0]);
    }

    private void detectNonActiveResourcePacks() {
        try {
            Path resourcePacksDir;
            String minecraftDir = System.getProperty("user.dir");
            if (minecraftDir.contains("PrismLauncher")) {
                minecraftDir = "C:\\Users\\victo\\AppData\\Roaming\\PrismLauncher\\instances\\SpEx - MC Civ Experiment\\minecraft";
            }
            if (!Files.exists(resourcePacksDir = Path.of(minecraftDir, "resourcepacks"), new LinkOption[0])) {
                return;
            }
            this.detectNonActiveResourcePacksWithTooltips(resourcePacksDir);
        }
        catch (Exception e) {
            LOGGER.error("[Tooltips DLP8] Failed to scan non-active resource packs", (Throwable)e);
        }
    }

    private void detectNonActiveResourcePacksWithTooltips(Path resourcePacksDir) {
        try (Stream<Path> stream = Files.list(resourcePacksDir);){
            stream.forEach(path -> {
                String packName = this.getResourcePackName((Path)path);
                boolean hasTooltips = false;
                if (path.toString().endsWith(".zip")) {
                    hasTooltips = this.checkZipForTooltips((Path)path);
                } else if (Files.isDirectory(path, new LinkOption[0])) {
                    hasTooltips = this.checkFolderForTooltips((Path)path);
                }
                if (hasTooltips) {
                    boolean isAlreadyLoaded;
                    boolean bl = isAlreadyLoaded = !this.loadedResourcePacks.isEmpty();
                    if (!isAlreadyLoaded) {
                        this.detectedResourcePacks.add(packName);
                    }
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("[Tooltips DLP8] Failed to detect non-active resource packs with tooltips", (Throwable)e);
        }
    }

    private String getResourcePackName(Path path) {
        String fileName = path.getFileName().toString();
        if (fileName.endsWith(".zip")) {
            return fileName.substring(0, fileName.length() - 4);
        }
        return fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkZipForTooltips(Path zipPath) {
        try (ZipFile zipFile = new ZipFile(zipPath.toFile());){
            ZipEntry entry;
            String entryName;
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            do {
                if (!entries.hasMoreElements()) return false;
            } while (!(entryName = (entry = entries.nextElement()).getName()).endsWith(".jsonc") || !entryName.startsWith("assets/tooltips-dlp8/") && !entryName.startsWith("assets\\tooltips-dlp8\\"));
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean checkFolderForTooltips(Path folderPath) {
        Path tooltipsDir = folderPath.resolve("assets").resolve("tooltips-dlp8");
        if (Files.exists(tooltipsDir, new LinkOption[0]) && Files.isDirectory(tooltipsDir, new LinkOption[0])) {
            boolean bl;
            block9: {
                Stream<Path> stream = Files.list(tooltipsDir);
                try {
                    bl = stream.anyMatch(path -> path.toString().endsWith(".jsonc"));
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    private void loadTooltipsFromJson(JsonObject json, String packName) {
        int tooltipsLoaded = 0;
        for (Map.Entry entry : json.entrySet()) {
            String key = (String)entry.getKey();
            if (key.startsWith("//") || !((JsonElement)entry.getValue()).isJsonPrimitive()) continue;
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (this.tooltips.containsKey(key)) {
                String existingTooltip = this.tooltips.get(key);
                this.tooltips.put(key, existingTooltip + "#n" + value);
            } else {
                this.tooltips.put(key, value);
            }
            ++tooltipsLoaded;
        }
        LOGGER.info("[Tooltips DLP8] Loaded {} tooltips from: {}", (Object)tooltipsLoaded, (Object)packName);
    }

    public String getTooltip(String itemId) {
        return this.tooltips.get(itemId);
    }

    public String getTooltipForTag(String tagId) {
        return this.tooltips.get(tagId);
    }

    public boolean isTagKey(String key) {
        return key.startsWith("#");
    }

    public Map<String, String> getAllTooltips() {
        return new HashMap<String, String>(this.tooltips);
    }

    public List<String> getLoadedResourcePacks() {
        return new ArrayList<String>(this.loadedResourcePacks);
    }

    public List<String> getDetectedResourcePacks() {
        return new ArrayList<String>(this.detectedResourcePacks);
    }

    public int getTooltipCount() {
        return this.tooltips.size();
    }

    public void reload() {
        this.loadConfig();
    }
}

