/*
 * Decompiled with CFR 0.152.
 */
package win.dlp8.mixin.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import win.dlp8.config.ColorParser;
import win.dlp8.config.TooltipConfig;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_1799.class})
public class TooltipMixin {
    @Inject(at={@At(value="RETURN")}, method={"getTooltip"})
    private void addCustomTooltip(CallbackInfoReturnable<List<class_2561>> cir) {
        class_1799 stack = (class_1799)this;
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        String itemIdString = itemId.toString();
        List<String> allTooltips = this.collectAllTooltips(stack, itemIdString);
        if (!allTooltips.isEmpty()) {
            List tooltips = (List)cir.getReturnValue();
            for (String tooltipText : allTooltips) {
                if (tooltipText == null || tooltipText.isEmpty()) continue;
                if (tooltipText.contains("#n")) {
                    List<class_2561> multilineTooltips = ColorParser.parseMultilineText(tooltipText);
                    tooltips.addAll(multilineTooltips);
                    continue;
                }
                class_2561 formattedTooltip = ColorParser.parseFormattedText(tooltipText);
                tooltips.add(formattedTooltip);
            }
        }
    }

    private List<String> collectAllTooltips(class_1799 stack, String itemIdString) {
        TooltipConfig config = TooltipConfig.getInstance();
        Map<String, String> allTooltips = config.getAllTooltips();
        ArrayList<String> applicableTooltips = new ArrayList<String>();
        String directTooltip = config.getTooltip(itemIdString);
        if (directTooltip != null && !directTooltip.isEmpty()) {
            applicableTooltips.add(directTooltip);
        }
        for (Map.Entry<String, String> entry : allTooltips.entrySet()) {
            String key = entry.getKey();
            if (!config.isTagKey(key)) continue;
            try {
                String tagTooltip;
                String tagId = key.substring(1);
                class_2960 tagIdentifier = class_2960.method_60654((String)tagId);
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7923.field_41178.method_46765(), (class_2960)tagIdentifier);
                if (!stack.method_31573(tagKey) || (tagTooltip = entry.getValue()) == null || tagTooltip.isEmpty()) continue;
                applicableTooltips.add(tagTooltip);
            }
            catch (Exception e) {}
        }
        return applicableTooltips;
    }
}

