/*
 * Decompiled with CFR 0.152.
 */
package win.dlp8.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import win.dlp8.config.TooltipConfig;

@Environment(value=EnvType.CLIENT)
public class ReloadConfigCommand {
    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"tooltips").then(ClientCommandManager.literal((String)"reload").executes(ReloadConfigCommand::executeReload))).then(ClientCommandManager.literal((String)"help").executes(ReloadConfigCommand::executeHelp)));
    }

    private static int executeReload(CommandContext<FabricClientCommandSource> context) {
        try {
            TooltipConfig.getInstance().reload();
            TooltipConfig config = TooltipConfig.getInstance();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7a[Tooltips DLP8] Configuration reloaded successfully!"));
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77Loaded " + config.getTooltipCount() + " tooltips from " + config.getLoadedResourcePacks().size() + " active resource packs")));
            if (!config.getLoadedResourcePacks().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aActive resource packs with tooltips:"));
                for (String packName : config.getLoadedResourcePacks()) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 \u00a7f" + packName)));
                }
            }
            if (!config.getDetectedResourcePacks().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7eDetected resource packs with tooltips (not active):"));
                for (String packName : config.getDetectedResourcePacks()) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 \u00a7e" + packName)));
                }
            }
            if (config.getLoadedResourcePacks().isEmpty() && config.getDetectedResourcePacks().isEmpty()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7eNo resource packs with tooltips found"));
            }
            return 1;
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43470((String)("\u00a7c[Tooltips DLP8] Failed to reload configuration: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeHelp(CommandContext<FabricClientCommandSource> context) {
        TooltipConfig config = TooltipConfig.getInstance();
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a76[Tooltips DLP8] Commands:"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7e/tooltips reload \u00a77- Reload the configuration"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7e/tooltips help \u00a77- Show this help"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77Current status:"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 Loaded tooltips: \u00a7f" + config.getTooltipCount())));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 Active resource packs: \u00a7f" + config.getLoadedResourcePacks().size())));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 Detected resource packs: \u00a7f" + config.getDetectedResourcePacks().size())));
        if (!config.getLoadedResourcePacks().isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7aActive resource packs with tooltips:"));
            for (String packName : config.getLoadedResourcePacks()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 \u00a7f" + packName)));
            }
        }
        if (!config.getDetectedResourcePacks().isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7eDetected resource packs with tooltips (not active):"));
            for (String packName : config.getDetectedResourcePacks()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)("\u00a77  \u2022 \u00a7e" + packName)));
            }
        }
        if (config.getLoadedResourcePacks().isEmpty() && config.getDetectedResourcePacks().isEmpty()) {
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a7eNo resource packs with tooltips found"));
        }
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77Configuration:"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77  \u2022 Path: \u00a7fassets/tooltips-dlp8/*.jsonc"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77  \u2022 Multiple resource packs supported"));
        ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"\u00a77  \u2022 Use different filenames for external packs"));
        return 1;
    }
}

