/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.cache;

import com.steveh259.shulkerboxlabels.common.cache.CacheEntry;
import com.steveh259.shulkerboxlabels.common.cache.ContainerIconEntry;
import com.steveh259.shulkerboxlabels.common.cache.OptimisticFacingEntry;
import com.steveh259.shulkerboxlabels.common.cache.ShulkerBoxBlockEntityEntry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.ShulkerBoxBlockEntity;
import org.jetbrains.annotations.Nullable;

public class Cache {
    public final HashMap<ShulkerBoxBlockEntity, ShulkerBoxBlockEntityEntry> shulkerBoxBlockEntityCache = new HashMap();
    public final HashMap<Integer, ContainerIconEntry> containerIconCache = new HashMap();
    public final HashMap<BlockPos, OptimisticFacingEntry> optimisticFacingCache = new HashMap();

    public void clearCaches() {
        this.shulkerBoxBlockEntityCache.clear();
        this.containerIconCache.clear();
        this.optimisticFacingCache.clear();
    }

    public void removeAllEntriesOlderThan(long millis) {
        Map[] caches = new Map[]{this.shulkerBoxBlockEntityCache, this.containerIconCache, this.optimisticFacingCache};
        long now = System.currentTimeMillis();
        for (Map cache : caches) {
            Iterator it = cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                CacheEntry entry = (CacheEntry)e.getValue();
                if (now - entry.lastCheckedMillis <= millis) continue;
                it.remove();
            }
        }
    }

    public void putShulkerBoxBlockEntityEntry(ShulkerBoxBlockEntity be, ShulkerBoxBlockEntityEntry entry) {
        this.shulkerBoxBlockEntityCache.put(be, entry);
    }

    @Nullable
    public ShulkerBoxBlockEntityEntry getShulkerBoxBlockEntityEntry(ShulkerBoxBlockEntity be) {
        ShulkerBoxBlockEntityEntry entry = this.shulkerBoxBlockEntityCache.get(be);
        if (entry == null) {
            return null;
        }
        entry.resetTime();
        return entry;
    }

    public void putContainerIcon(int containerId, ItemStack icon) {
        if (icon == null || icon.isEmpty()) {
            return;
        }
        ContainerIconEntry entry = new ContainerIconEntry(icon);
        this.containerIconCache.put(containerId, entry);
    }

    @Nullable
    public ItemStack getContainerIcon(int containerId) {
        ContainerIconEntry entry = this.containerIconCache.get(containerId);
        if (entry == null || entry.icon.isEmpty()) {
            return null;
        }
        entry.resetTime();
        return entry.icon;
    }

    public void putOptimisticFacing(BlockPos pos, Direction facing) {
        OptimisticFacingEntry entry = new OptimisticFacingEntry(facing);
        this.optimisticFacingCache.put(pos, entry);
    }

    @Nullable
    public Direction getOptimisticFacing(BlockPos pos) {
        OptimisticFacingEntry entry = this.optimisticFacingCache.get(pos);
        if (entry == null) {
            return null;
        }
        entry.resetTime();
        return entry.facing;
    }

    public void removeOptimisticFacing(BlockPos pos) {
        this.optimisticFacingCache.remove(pos);
    }
}

