/*
 * Decompiled with CFR 0.152.
 */
package com.steveh259.shulkerboxlabels.common.custom_transformations;

import com.steveh259.shulkerboxlabels.common.custom_transformations.CustomItemTransformations;
import java.util.HashMap;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.AzaleaBlock;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BigDripleafBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.CartographyTableBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.ChorusPlantBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.ConduitBlock;
import net.minecraft.world.level.block.CopperGolemStatueBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DirtPathBlock;
import net.minecraft.world.level.block.DragonEggBlock;
import net.minecraft.world.level.block.DriedGhastBlock;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.EndPortalBlock;
import net.minecraft.world.level.block.EndPortalFrameBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.GrindstoneBlock;
import net.minecraft.world.level.block.HeavyCoreBlock;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.MossyCarpetBlock;
import net.minecraft.world.level.block.MudBlock;
import net.minecraft.world.level.block.ScaffoldingBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.SculkShriekerBlock;
import net.minecraft.world.level.block.ShelfBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SmallDripleafBlock;
import net.minecraft.world.level.block.SoulSandBlock;
import net.minecraft.world.level.block.SporeBlossomBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StonecutterBlock;
import net.minecraft.world.level.block.StructureVoidBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;

public class CustomItemTransformationMap {
    public static final HashMap<Item, CustomItemTransformations> ITEM_TRANSFORMATIONS = new HashMap();
    private static final Direction.Axis X = Direction.Axis.X;
    private static final Direction.Axis Y = Direction.Axis.Y;
    private static final Direction.Axis Z = Direction.Axis.Z;
    private static final CustomItemTransformations.Perspective GUI = CustomItemTransformations.Perspective.GUI;
    private static final CustomItemTransformations.Perspective WORLD = CustomItemTransformations.Perspective.World;
    private static final CustomItemTransformations.Perspective FIRST_PERSON_HANDS = CustomItemTransformations.Perspective.FirstPersonHands;
    private static final CustomItemTransformations.Mode FLAT = CustomItemTransformations.Mode.FLAT;
    private static final CustomItemTransformations.Mode REGULAR = CustomItemTransformations.Mode.REGULAR;

    private static CustomItemTransformations transformations() {
        return new CustomItemTransformations();
    }

    private static void item(Item item, CustomItemTransformations transformation) {
        ITEM_TRANSFORMATIONS.put(item, transformation);
    }

    private static void block(Class<? extends Block> type, CustomItemTransformations transformation) {
        BuiltInRegistries.ITEM.stream().filter(item -> item instanceof BlockItem).map(item -> (BlockItem)item).filter(blockItem -> type.isAssignableFrom(blockItem.getBlock().getClass())).forEach(blockItem -> ITEM_TRANSFORMATIONS.put((Item)blockItem, transformation));
    }

    public static CustomItemTransformations getItemTransformation(Item key) {
        return ITEM_TRANSFORMATIONS.getOrDefault(key, new CustomItemTransformations());
    }

    static {
        CustomItemTransformationMap.block(StairBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(SlabBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(CarpetBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(EndRodBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(SoulSandBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(AbstractChestBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(FarmBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(CactusBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(AzaleaBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(MudBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(MossyCarpetBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(SculkShriekerBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(EnchantingTableBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(HoneyBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(ComposterBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(DirtPathBlock.class, CustomItemTransformationMap.transformations().treatAsBlock());
        CustomItemTransformationMap.block(LightningRodBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation());
        CustomItemTransformationMap.block(EndPortalFrameBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().rotation(X, 90.0f).translation(Z, -0.125f));
        CustomItemTransformationMap.block(WallBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Z, 0.03125f));
        CustomItemTransformationMap.block(TrapDoorBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().rotation(X, 90.0f).translation(Z, 0.1875f).translation(Z, GUI, 0.28125f));
        CustomItemTransformationMap.block(BigDripleafBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Y, 0.0625f).translation(Z, 0.0625f).rotation(X, 90.0f));
        CustomItemTransformationMap.block(SmallDripleafBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().rotation(X, 90.0f).rotation(X, GUI, REGULAR, 30.0f).rotation(Y, GUI, REGULAR, 45.0f).translation(Z, GUI, REGULAR, 0.5f));
        CustomItemTransformationMap.block(FenceBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().scale(WORLD, 0.375f).scale(GUI, 0.53125f));
        CustomItemTransformationMap.block(AnvilBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().rotation(X, FIRST_PERSON_HANDS, 20.0f).translation(Z, -0.046875f).translation(Z, FIRST_PERSON_HANDS, -0.046875f).topHeightOverflow(2));
        CustomItemTransformationMap.block(DragonEggBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().rotation(X, 90.0f).translation(Z, 0.0625f).topHeightOverflow(2));
        CustomItemTransformationMap.block(BasePressurePlateBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Z, -0.1875f).translation(Z, GUI, -0.25f));
        CustomItemTransformationMap.block(FenceGateBlock.class, new CustomItemTransformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Y, -0.078125f));
        CustomItemTransformationMap.block(BedBlock.class, CustomItemTransformationMap.transformations().translation(Z, -0.0625f));
        CustomItemTransformationMap.block(ScaffoldingBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().rotation(X, 90.0f).translation(Z, FIRST_PERSON_HANDS, 0.09375f));
        CustomItemTransformationMap.block(SkullBlock.class, CustomItemTransformationMap.transformations().disableDynamicBlockOffsetCalculation().translation(Z, -0.09375f).translation(Z, FIRST_PERSON_HANDS, 0.015625f).rotation(X, FIRST_PERSON_HANDS, 45.0f));
        CustomItemTransformationMap.block(BannerBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().scale(WORLD, 0.375f).scale(GUI, 0.375f).translation(Y, -0.15625f).translation(Y, GUI, -0.21875f));
        CustomItemTransformationMap.block(StonecutterBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Z, GUI, 0.015625f).rotation(X, 90.0f).rotation(X, GUI, FLAT, 0.0f).translation(Z, GUI, FLAT, 0.0f));
        CustomItemTransformationMap.block(LecternBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Z, 0.125f).translation(Z, GUI, 0.1875f).translation(Z, FIRST_PERSON_HANDS, 0.28125f).rotation(X, FIRST_PERSON_HANDS, 45.0f));
        CustomItemTransformationMap.block(DaylightDetectorBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Z, 0.125f).rotation(X, 90.0f));
        CustomItemTransformationMap.block(SculkSensorBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Z, 0.0625f).rotation(X, 90.0f).topHeightOverflow(4).rotation(X, GUI, FLAT, 0.0f));
        CustomItemTransformationMap.block(HeavyCoreBlock.class, CustomItemTransformationMap.transformations().disableDynamicBlockOffsetCalculation().translation(Z, -0.09375f));
        CustomItemTransformationMap.block(DecoratedPotBlock.class, CustomItemTransformationMap.transformations().disableDynamicBlockOffsetCalculation().treatAsBlock().rotation(X, 90.0f).translation(Z, -0.15625f).topHeightOverflow(2));
        CustomItemTransformationMap.block(ChorusPlantBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Z, -0.046875f).translation(Z, GUI, -0.03125f));
        CustomItemTransformationMap.block(ChorusFlowerBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Z, 0.046875f).translation(Z, GUI, 0.078125f));
        CustomItemTransformationMap.block(ConduitBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Z, -0.140625f));
        CustomItemTransformationMap.block(GrindstoneBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Z, -0.03125f).rotation(X, 90.0f).translation(Z, 0.25f).topHeightOverflow(2).rotation(X, GUI, FLAT, 0.0f));
        CustomItemTransformationMap.block(StructureVoidBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().scale(null, 0.375f).scale(GUI, 0.4375f));
        CustomItemTransformationMap.block(BarrierBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().scale(null, 0.375f).scale(GUI, 0.4375f));
        CustomItemTransformationMap.block(SporeBlossomBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().rotation(X, -90.0f).translation(Z, 0.25f).translation(Z, GUI, 0.3125f).scale(GUI, 0.625f));
        CustomItemTransformationMap.block(ButtonBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().scale(null, 0.75f).scale(GUI, 1.0f).rotation(X, 90.0f).translation(Z, -0.0625f));
        CustomItemTransformationMap.block(DriedGhastBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Z, 0.359375f).rotation(X, 90.0f).translation(Y, GUI, FLAT, 0.09375f).translation(Z, GUI, FLAT, 0.0f).rotation(X, GUI, FLAT, 0.0f).translation(Z, GUI, REGULAR, 0.5f).rotation(X, GUI, REGULAR, 90.0f).topHeightOverflow(4));
        CustomItemTransformationMap.block(CartographyTableBlock.class, CustomItemTransformationMap.transformations().rotation(X, 90.0f).rotation(Y, 90.0f));
        CustomItemTransformationMap.block(JukeboxBlock.class, CustomItemTransformationMap.transformations().rotation(X, 90.0f).rotation(Y, 90.0f));
        CustomItemTransformationMap.block(EndPortalBlock.class, CustomItemTransformationMap.transformations().rotation(X, 90.0f).translation(Z, 0.09375f).translation(Z, GUI, 0.15625f));
        CustomItemTransformationMap.block(PistonBaseBlock.class, CustomItemTransformationMap.transformations().rotation(X, 90.0f).translation(Z, GUI, 0.03125f));
        CustomItemTransformationMap.block(SculkShriekerBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().rotation(X, 90.0f).translation(Z, 0.0625f).topHeightOverflow(4));
        CustomItemTransformationMap.block(ShelfBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().translation(Z, -0.03125f));
        CustomItemTransformationMap.block(CopperGolemStatueBlock.class, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Y, -0.0625f).translation(Z, -0.015625f).scale(GUI, 0.5f).rotation(X, FIRST_PERSON_HANDS, 90.0f).translation(Z, FIRST_PERSON_HANDS, 0.3125f));
        CustomItemTransformationMap.item(Items.DRAGON_HEAD, CustomItemTransformationMap.transformations().rotation(X, 90.0f).translation(Y, 0.203125f).translation(Z, -0.03125f).scale(GUI, 0.5625f).topHeightOverflow(2).rotation(X, GUI, FLAT, 0.0f).translation(Y, GUI, FLAT, -0.09375f).translation(Z, GUI, FLAT, 0.0f));
        CustomItemTransformationMap.item(Items.SNOW, CustomItemTransformationMap.transformations().treatAsBlock().disableDynamicBlockOffsetCalculation().translation(Z, -0.21875f).translation(Z, GUI, -0.28125f));
        CustomItemTransformationMap.item(Items.SHIELD, CustomItemTransformationMap.transformations().disableDynamicBlockOffsetCalculation().scale(null, 0.75f).scale(GUI, 1.0f).translation(Z, -0.046875f));
        CustomItemTransformationMap.item(Items.DRIED_KELP_BLOCK, CustomItemTransformationMap.transformations().treatAsBlock().rotation(X, 90.0f).translation(Z, GUI, 0.03125f));
        CustomItemTransformationMap.item(Items.FARMLAND, CustomItemTransformationMap.transformations().treatAsBlock().rotation(X, 90.0f).translation(Z, 0.03125f).translation(Z, GUI, 0.0625f));
    }
}

